/*////////////////////////////////////////////////////////////////////////
Copyright (c) 2000 Yutaka Sato
Copyright (c) 2000 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	imap.c (IMAP4 RFC2060)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	000616	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "param.h"
#include "delegate.h"
#include "filter.h"
#include "ystring.h"
#define LNSIZE 1024
extern char *fgetsTIMEOUT();

static imap_change_server(Conn,login)
	Connection *Conn;
	char *login;
{	char *dp,host[LNSIZE];
	int port;

	dp = strrpbrk(login,"@%");
	if( dp == 0 )
		return;

	port = scan_hostportX("imap",dp+1,host,sizeof(host));
	if( strtailchr(login) == '"' )
		*dp++ = '"';
	*dp = 0;

	sv1log("IMAP LOGIN  %s @ %s:%d\n",login,host,port);
	set_realserver(Conn,"imap",host,port);
	connect_to_serv(Conn,FromC,ToC,0);
}

service_imap(Conn)
	Connection *Conn;
{	FILE *fc,*tc,*ts,*fs;
	char *dp,*ap;
	char req[LNSIZE],qtag[LNSIZE],qcmd[LNSIZE],qarg[LNSIZE],qrem[LNSIZE];
	char resp[LNSIZE],rtag[LNSIZE],rstat[LNSIZE];
	char myhost[LNSIZE];

	fc = fdopen(FromC,"r");
	tc = fdopen(ToC,"w");

	if( 0 <= ToS ){
		ts = fdopen(ToS,"w");
		fs = fdopen(FromS,"r");
		if( fgetsTIMEOUT(resp,sizeof(resp),fs) == NULL )
			return;
		sv1log("S: %s",resp);
	}else{
		ts = NULL;
		fs = NULL;
		ClientIF_name(Conn,FromC,myhost);
		sprintf(resp,"* OK %s Proxy IMAP4 server DeleGate/%s\r\n",
			myhost,DELEGATE_ver());
		sv1log("D: %s",resp);
	}
	fputs(resp,tc);

	for(;;){
		fflush(tc);
		if( fgetsTIMEOUT(req,sizeof(req),fc) == NULL ){
			sv1log("C: EOF\n");
			break;
		}
		dp = wordScan(req,qtag);
		ap = wordScan(dp,qcmd);
		dp = wordScan(ap,qarg);
		lineScan(dp,qrem);
		if( strcaseeq(qcmd,"LOGIN") ){
			sv1log("C: %s %s %s ****\n",qtag,qcmd,qarg);
		}else	sv1log("C: %s",req);

		if( ts == NULL ){
			if( strcaseeq(qcmd,"XECHO") ){
				while( *ap == ' ' || *ap == '\t' )
					ap++;
				fputs(ap,tc);
				continue;
			}
			if( strcaseeq(qcmd,"LOGOUT") ){
				sv1log("D: %s OK %s\r\n",qtag,qcmd);
				fprintf(tc,"%s OK %s\r\n",qtag,qcmd);
				fflush(tc);
				break;
			}
			if( strcaseeq(qcmd,"CAPABILITY") ){
				sv1log("D: %s OK %s\r\n",qtag,qcmd);
				fprintf(tc,"* CAPABILITY IMAP4 AUTH-LOGIN\r\n");
				fprintf(tc,"%s OK %s\r\n",qtag,qcmd);
				continue;
			}
			if( strcaseeq(qcmd,"LOGIN") )
				imap_change_server(Conn,qarg);

			if( ToS < 0 ){
				fprintf(tc,"%s BAD LOGIN user@host first.\r\n",
					qtag);
				sv1log("D: %s BAD LOGIN user@host first.\r\n",
					qtag);
				continue;
			}
			ts = fdopen(ToS,"w");
			fs = fdopen(FromS,"r");
			if( fgetsTIMEOUT(resp,sizeof(resp),fs) == NULL )
				return;
			sv1log(">>>> %s",resp);
			sprintf(req,"%s %s %s %s\r\n",qtag,qcmd,qarg,qrem);
			sv1log(">>>> %s %s %s ****\n",qtag,qcmd,qarg);
		}
		fputs(req,ts);
		fflush(ts);

		rstat[0] = 0;
		for(;;){
			if( fgetsTIMEOUT(resp,sizeof(resp),fs) == NULL ){
				sv1log("S: EOF\n");
				break;
			}
			dp = wordScan(resp,rtag);
			dp = wordScan(dp,rstat);
			fputs(resp,tc);
			if( qtag[0] == 0 || strcmp(qtag,rtag) == 0 )
				break;
			Verbose("S> %s",resp);
		}
		sv1log("S: %s",resp);
		fflush(tc);
		if( strcaseeq(qcmd,"LOGOUT") && strcaseeq(rstat,"OK")
		 || feof(fs) )
			break;
	}
EXIT:
	return;
}
