/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	http.h
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970708	extracted from httpd.c
//////////////////////////////////////////////////////////////////////#*/

#define URLSZ		(16*1024)
#define OBUFSIZE	(16*1024)
#define IBUFSIZE	(16*1024)
#define SOCKBUFSIZE	(16*1024)
#define RESP_LINEBUFSZ	(URLSZ*4)

#define MY_HTTPVER	"1.1"
#define MY_MIMEVER	"1.0"

#define ME_7bit		((char*)0)
#define ME_binary	"binary"

/*
 * result status in the logfile
 */
#define CS_AUTHERR	'A'
#define CS_CONNERR	'C'
#define CS_ERROR	'E'
#define CS_HITCACHE	'H'
#define CS_INTERNAL	'I'
#define CS_LOCAL	'L'	/* local file (or CGI,SSI) */
#define CS_KILLED	'K'
#define CS_MAKESHIFT	'M'	/* connection failed and make shift */
#define CS_EOF		'P'
#define CS_NEW		'N'	/* got first (not found) */
#define CS_OBSOLETE	'O'	/* obsolete (modified) */
#define CS_RELOAD	'R'	/* reload (Pragma: no-cache) */
#define CS_STABLE	'S'	/* stable (not modified) */
#define CS_WITHOUTC	'W'	/* without cache */
#define CS_BADREQUEST	'B'	/* illegal request */

typedef struct _HttpRequest {
	char	hq_method[32];
	char	hq_url[URLSZ];
	char	hq_ver[32];
	int	hq_vno;
} HttpRequest;

typedef struct {
	char	hr_ver[256];		/* HTTP version */
	int	hr_rcode;		/* status code */
	char	hr_reason[256];		/* reason */
	char	hr_isHTTP09;		/* before HTTP/1.0 */
} HttpResponse;

typedef struct {
	int	r_code;
	int	r_sav; /* if true, save the response message into r_msg[] */
	char	r_msg[0x8000];
	int	r_len;
	char	r_anchor_rem[1024];
		/* Pushed back fragment of anchor tag which is folded
		 * into multiple lines.
		 * Should be treated in general way in the input buffer
		 * operation... (-_-;
		 */
	char	r_line0[RESP_LINEBUFSZ];
	char	r_line1[RESP_LINEBUFSZ];
} HtResp;

typedef struct {
	char	r_oreqmsg[0x8000]; /* original request message */
	int	r_oreqlen;

	char	r_oreq[URLSZ];	/* original request line */
	char	r_ohost[1024];	/* original server host */
	int	r_oport;	/* original server port */
	char	r_vhost[256];	/* original Host: field */

	int	r_badRequest;
	int	r_normalized;
	int	r_checkServ;
	int	r_waitServ;
	int	r_badServ;
	char	r_badServResponse[128];
	char	r_badServDetected[32];
	char	r_req[URLSZ];	/* HTTP request possibly rewritten */
 HttpRequest	r_reqx;		/* decomposed r_req */

	char	r_fields[0x8000];
	char   *r_lastFname;	/* cache for getRequestField */
	char   *r_lastFbody;	/* (pointers into f_fields) */

	char	r_acclangs[1024]; /* merged list of Accept-Language for log */

	char	r_clntIfmod[256]; /* If-Mod-Since from the  client */
	int	r_clntIfmodClock; /* its value in int */

	int	r_flushhead;
	int	r_flushsmall;

	int	r_withCookie;
	char	r_dgCookie[256]; /* Proxy-Cookie */
	int	r_appletFilter;

	int	r_clntAccChunk;
	char	r_httpConn[128];
	int	r_get_cache;
	char	r_iconBase[256];	
	HtResp	r_resp;
} HTTP_env;

#define CurEnv		((HTTP_env*)Conn->cl_reqbuf)

#define OREQ_MSG	CurEnv->r_oreqmsg
#define OREQ_LEN	CurEnv->r_oreqlen

#define OREQ		CurEnv->r_oreq
#define OREQ_HOST	CurEnv->r_ohost
#define OREQ_PORT	CurEnv->r_oport
#define OREQ_VHOST	CurEnv->r_vhost

#define REQ		CurEnv->r_req
#define REQ_FIELDS	CurEnv->r_fields
#define REQX		CurEnv->r_reqx
#define REQ_METHOD	CurEnv->r_reqx.hq_method
#define REQ_URL		CurEnv->r_reqx.hq_url
#define REQ_VER		CurEnv->r_reqx.hq_ver
#define REQ_VNO		CurEnv->r_reqx.hq_vno

#define BadRequest	CurEnv->r_badRequest
#define Normalized	CurEnv->r_normalized
#define CheckServ	CurEnv->r_checkServ
#define WaitServ	CurEnv->r_waitServ
#define BadServ		CurEnv->r_badServ
#define BadServResponse	CurEnv->r_badServResponse
#define BadServDetected	CurEnv->r_badServDetected

#define AcceptLanguages	CurEnv->r_acclangs

#define FlushHead	CurEnv->r_flushhead
#define FlushIfSmall	CurEnv->r_flushsmall

#define ClntIfMod	CurEnv->r_clntIfmod
#define ClntIfModClock	CurEnv->r_clntIfmodClock

#define withCookie	CurEnv->r_withCookie
#define appletFilter	CurEnv->r_appletFilter
#define proxyCookie	CurEnv->r_dgCookie

#define iconBase	CurEnv->r_iconBase
#define GET_CACHE	CurEnv->r_get_cache
#define ClntAccChunk	CurEnv->r_clntAccChunk
#define httpConn	CurEnv->r_httpConn

#define RespCode	CurEnv->r_resp.r_code
#define anchor_rem	CurEnv->r_resp.r_anchor_rem
#define RESP_SAV	CurEnv->r_resp.r_sav
#define RESP_MSG	CurEnv->r_resp.r_msg
#define RESP_LEN	CurEnv->r_resp.r_len
#define Line0		CurEnv->r_resp.r_line0
#define Line1		CurEnv->r_resp.r_line1


#define F_HTTPVER	"HTTP/"
#define F_HTTPVERLEN	sizeof(F_HTTPVER)-1
#define F_DGVer		"DeleGate-Ver:"
#define F_ContType	"Content-Type:"
#define F_CtypeText	"Content-Type: text"
#define F_CtypePlain	"Content-Type: text/plain"
#define F_CtypeHTML	"Content-Type: text/html"
#define F_ContEncode	"Content-Encoding:"
#define F_TransEncode	"Transfer-Encoding:"
#define F_ContLeng	"Content-Length:"
#define F_ContRange	"Content-Range:"
#define F_Range		"Range:"
#define F_Location	"Location:"
#define F_SetProxy	"Set-Proxy:"
#define F_LastMod	"Last-Modified:"
#define F_Etag		"Etag:"
#define F_Server	"Server:"
#define F_Cookie	"Cookie:"
#define F_SetCookie	"Set-Cookie:"
#define F_Connection	"Connection:"
#define F_PConnection	"Proxy-Connection:"
#define F_CacheControl	"Cache-Control:"

#define STRH(field,fname) \
	(strncasecmp(field,fname,sizeof(fname)-1)==0?sizeof(fname)-1:0)

#define STRH_Connection(field) ( \
	  STRH(field,F_Connection) ? STRH(field,F_Connection) \
	: STRH(field,F_PConnection) )
