/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ftpgw.c (FTP on HTTP)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940321	creatged
//////////////////////////////////////////////////////////////////////#*/
/*
HTTP/FTP<- Accept: xxx
	<- Accept: ...
	...

	=> USER username
	=> PASS password
	=> TYPE I
	=> PORT h,h,h,h,p,p
	=> RETR filename

	-> HTTP/1.0 200 OK
	-> MIME-Version: 1.0
	-> Content-Type: application/octet-stream
	-> Content-Transfer-Encoding: 8bit
	-> Content-Lenght: 4096
	->
	<= data
	-> data
	...

	=> QUIT
*/

#include <stdio.h>
#include "ystring.h"
extern FILE *ftp_fopen();
extern char *malloc();
extern char *fgetsTIMEOUT();
extern char *scanLsDate();
extern char *isdigits();
extern char *filename2ctype();
extern char *filename2icon();
extern double GetStartTime(),Time();
extern FILE *openHttpResponseFilter();
extern FILE *TMPFILE();

#include "delegate.h"
#include "http.h" /* putHttpHeader */

#define FORM_GOPHER	1
#define FORM_HTML	2
#define CHECK_LENG	2048

static char *dgserv;
static char *DGserv()
{	char buff[128];

	if( dgserv == 0 ){
		sprintf(buff,"ETL-DeleGate/%s (as a FTP/HTTP gateway)",
			DELEGATE_ver());
		dgserv = strdup(buff);
	}
	return dgserv;
}
putAncestorAnchor(Conn,dst,proto,host,port,path,hidepass)
	Connection *Conn;
	FILE *dst;
	char *proto,*host,*path;
{	char url[256],durl[2048];
	char pathbuf[2048],*pb,*dp,dc;
	char hostport[512],purl[512],psite[512];

	HostPort(hostport,proto,host,port);
	sprintf(url,"%s://%s/",proto,hostport);
	redirect_url(Conn,url,durl);
	if( hidepass ) url_strippass(durl);

	strcpy(psite,hostport);
	if( hidepass )
		site_strippass(psite);
	sprintf(purl,"%s://%s/",proto,psite);
	fprintf(dst,"<A HREF=\"%s\">%s</A>",durl,purl);

	strcpy(pathbuf,path);
	for( pb = pathbuf; dp = strchr(pb,'/'); pb = dp +1 ){
		dc = dp[1];
		dp[1] = 0;
		strcat(url,pb);
		redirect_url(Conn,url,durl);
		if( hidepass ) url_strippass(durl);
		fprintf(dst,"<A HREF=\"%s\">%s</A>",durl,pb);
		dp[1] = dc;
	}
	if( *pb ){
		strcat(url,pb);
		redirect_url(Conn,url,durl);
		if( hidepass ) url_strippass(durl);
		fprintf(dst,"<A HREF=\"%s\">%s</A>",durl,pb);
	}
}
static char *get_ctype(path,binary,encodingp)
	char *path;
	char **encodingp;
{	char *ctype;

	if( encodingp ) *encodingp = 0;
	if( (ctype = filename2ctype(path)) == 0 ){
		if( binary ){
			ctype = "application/octet-stream";
			if( encodingp ) *encodingp = "binary";
		}else	ctype = "text/plain";
	}
	return ctype;
}


#define VNO 100		/* X-) */

typedef struct {
	char	*user;
	char	*host;
	int	 port;
	char	*path;
	int	 isdir;
	double	 proc_secs;
	int	 dir_lines;
	int	 cache_date;
} FtpEnv;
extern char *DELEGATE_ADMIN;
static printItem(Conn,fp,fmt,name,arg,env)
	Connection *Conn;
	FILE *fp;
	char *fmt,*name,*arg;
	FtpEnv *env;
{	char buff[1024];

	if( streq(name,"ADMIN") || streq(name,"MANAGER") ){
		fprintf(fp,fmt,DELEGATE_ADMIN);
	}else
	if( streq(name,"anonftpAuth") ){
		if( streq(arg,"nopass") )
			return CTX_auth_anonftp(Conn,"PASSWD","UUUU@DDDD","*");
	}else
	if( streq(name,"resptime") ){
		fprintf(fp,"%3.1f",env->proc_secs);
	}else
	if( streq(name,"isdir") ){
		return env->isdir;
	}else
	if( streq(name,"site") ){
		HostPort(buff,"ftp",env->host,env->port);
		if( streq(arg,"hidepass") )
			site_strippass(buff);
		fprintf(fp,"%s",buff);
	}else
	if( streq(name,"host") ){
		fprintf(fp,"%s",env->host);
	}else
	if( streq(name,"port") ){
		fprintf(fp,"%d",env->port);
	}else
	if( streq(name,"path") ){
		fprintf(fp,"%s",env->path);
	}else
	if( streq(name,"anonymous") ){
		return is_anonymous(env->user);
	}else
	if( streq(name,"ancestor") ){
		putAncestorAnchor(Conn,fp,"ftp",env->host,env->port,env->path,
			streq(arg,"hidepass"));
	}else
	if( streq(name,"lines") ){
		fprintf(fp,"%d",env->dir_lines);
	}else
	if( streq(name,"cache") ){
		if( streq(arg,"hit") ){
			if( 0 < env->cache_date )
				return 1;
			else	return 0;
		}else
		if( streq(arg,"date") ){
			StrftimeLocal(buff,sizeof(buff),TIMEFORM_mdHMS,
				env->cache_date);
			fprintf(fp,"%s",buff);
		}
	}
	return 0;
}

#ifndef MAIN

static needAuth(resp)
	char *resp;
{	char *dp;
	char *busy = "530-COMMAND: USER ";
	char user[256];
	char unknown[256];

	if( atoi(resp) == 530 ){
		if( dp = strstr(resp,busy) ){
			sscanf(dp+strlen(busy),"%s",user);
			if( is_anonymous(user) ){
				if( strstr(dp,"Guest login not permitted") )
					return 1;
				sprintf(unknown,"User %s unknown",user);
				if( strstr(dp,unknown) )
					return 1;

				/* maybe too many anonymous login, or
				 * no anonymous support.
				 */
				sv1log("NO (more) anonyomous ?\n");
				return 0;
			}
		}
		return 1;
	}
	return 0;
}
static putErrorHead(Conn,out,vno,req,host,resp)
	Connection *Conn;
	FILE *out;
	char *req,*host,*resp;
{
	if( atoi(resp) == 530 ){
		HTTP_delayReject(Conn,req,resp,1);
		if( needAuth(resp) )
			putNotAuthorized(Conn,out,req,ProxyAuth,NULL,"");
		else	putHttpNotAvailable(Conn,out,resp);
	}else{
		delayUnknown(Conn,1,req);
		putHttpNotFound(Conn,out,resp);
	}
}

extern int file_copy();
extern FILE *reusableTMPFILE();

static ident_copy(Conn,fsd,tc,cachefp,server,path,size,expire)
	Connection *Conn;
	FILE *fsd,*tc,*cachefp;
	char *server;
	char *path;
{	int binary;
	char *encoding;
	FILE *tmp;
	int totalc;
	char *ctype;
	int ci;
	char *base;
	FILE *ins[3];

	tmp = reusableTMPFILE("ident_copy",ident_copy);
	file_copy(fsd,tmp,NULL,CHECK_LENG,&binary);
	fflush(tmp);

	ctype = get_ctype(path,binary,&encoding);

	if( (base = strrchr(path,'/')) == 0 )
		base = path;

if( !Conn->body_only )
	putHttpHeader1(Conn,tc,server,ctype,encoding,size,expire);
	/* fprintf(tc,"X-Local-Filename: %s\r\n",base); */

	fseek(tmp,0,0);

/*
4.3.0: code conversion should be done at HttpResponseFilter
but CHARCODE env is not passed to the filter in Windows version...
*/
	if( strncmp(ctype,"text/",5) == 0 ){
		ins[0] = tmp;
		ins[1] = fsd;
		ins[2] = 0;
		totalc = CCV_relay_texts(Conn,ins,tc,cachefp);
	}else{
		totalc = file_copy(tmp,tc,cachefp,0,NULL);
		totalc += file_copy(fsd,tc,cachefp,0,NULL);
	}

	fclose(tmp);
	return totalc;
}

static ftp_cachepath(Conn,host,port,path,cachepath)
	Connection *Conn;
	char *host,*port,*path,*cachepath;
{
	char xpath[1024];

	cachepath[0] = 0;
	if( without_cache() )
		return 0;

	nonxalpha_escape(path,xpath);
	path = xpath;
	CTX_cache_path(Conn,"ftp",host,port,path,cachepath);
	return cachepath[0] != 0;
}

int FTP_CACHE_ANYUSER;
static get_ftpcache(Conn,user,host,port,path,ext,cachepath)
	Connection *Conn;
	char *user,*host,*path,*ext,*cachepath;
{	int rcode;

	cachepath[0] = 0;

	if( FTP_CACHE_ANYUSER || is_anonymous(user) )
	if( rcode = ftp_cachepath(Conn,host,port,path,cachepath) ){
		if( ext != NULL && ext[0] ){
			if( strtailchr(cachepath) == '/' && ext[0] == '/' )
				ext++;
			strcat(cachepath,ext);
		}
		return rcode;
	}
	return 0;
}

extern FILE *cache_make();
extern FILE *cache_fopen_rd();

FILE *CTX_creat_ftpcache(Conn,user,host,port,path,ext,cpath,xcpath)
	Connection *Conn;
	char *user,*host,*path,*ext,*cpath,*xcpath;
{
	if( xcpath )
		xcpath[0] = 0;
	if( get_ftpcache(Conn,user,host,port,path,ext,cpath) )
		return cache_make("FTP-CACHE",cpath,xcpath);
	else	return NULL;
}

extern char *scan_ls_l();
#define TOLERANCE	(5*60)

static FILE *openLIST(ocpath,Tdp)
	char *ocpath;
	int *Tdp;
{	FILE *pfp;
	char *dp,ppath[1024],cwd[256];

	strcpy(ppath,ocpath);
	if( dp = strrchr(ppath,'/') )
		if( dp[1] == 0 )
			dp[0] = 0;
	strcpy(cwd,"../");
	ftpc_dirext(cwd);
	chdir_cwd(ppath,cwd,0);
	if( pfp = fopen(ppath,"r") )
		*Tdp = file_mtime(fileno(pfp));
	else	*Tdp = -1;
	return pfp;
}
static getstatFromLIST(pfp,ocpath,Tn,TFp,SFp)
	FILE *pfp;
	char *ocpath;
	int *TFp,*SFp;
{	int TF,SF;
	char *dp,*file,line[1024];
	char date[1024],name[1024],sname[1024];

	if( dp = strrchr(ocpath,'/') )
		if( dp[1] == 0 )
			dp[0] = 0;
	if( file = strrchr(ocpath,'/') )
		file += 1;
	else	file = ocpath;

	TF = SF = -1;
	while( fgets(line,sizeof(line),pfp) != NULL ){
		if( strstr(line,file) == NULL )
			continue;
		if( scan_ls_l(line,NULL,NULL,NULL,NULL,&SF,date,name,sname)
			== NULL )
			continue;
		if( strcmp(name,file) != 0 )
			continue;
		TF = LsDateClock(date,Tn);
		break;
	}

	*TFp = TF;
	*SFp = SF;
	if( TF == -1 && SF == -1 )
		return 0;
	else	return 1;
}
static cache_reload(ocpath,cachefp,isdir,fsize,mtime,expire)
	char *ocpath;
	FILE *cachefp;
{	FILE *pfp;
	int reload,obsolete;
	int Tn;	/* current time */
	int Te; /* EXPIRE in seconds */
	int Td; /* modified time of DIR cache (.ls-l.) */
	int Tf; /* modified time of FILE cache (file or subdirectory) */
	int Sf; /* size of FILE cache */
	int TF; /* modified time of original FILE shown in DIR */
	int SF; /* size of original FILE shown in DIR */
	int TT; /* tolerance */
	char *status;
	char *reason;

	Tn = time(0);
	Te = expire;
	Tf = mtime;
	Sf = fsize;
	TT = TOLERANCE;
	obsolete = Tf + Te < Tn;

	if( (pfp = openLIST(ocpath,&Td)) == NULL ){
		reload = obsolete;
		status = "A";
		reason = "can't find LIST cache";
	}else
	if( getstatFromLIST(pfp,ocpath,Tn,&TF,&SF) == 0 )
	{
		reload = obsolete;
		status = "B"; reason = "LIST cache does not contain the file";
	}else
	if( Td + Te < Tn )
	{
		reload = obsolete;
		status = "C"; reason = "LIST cache is out of date";
	}else
	if( Td < Tf )
	{
		reload = obsolete;
		status = "D"; reason = "can't rely on LIST cache";
	}else
	if( !isdir && Sf != SF )
	{
		reload = 1;
		status = "E"; reason = "size changed";
	}else
	if( TF+TT < Tf )
	{
		reload = 0;
		status = "F"; reason = "cache seems new enough";
	}else
	if( TT < TF - Tf )
	{
		reload = 1;
		status = "G"; reason = "cache seems old enough";
	}else
	if( TT > Tn - Tf )
	{
		reload = 0;
		status = "H"; reason = "may be obsolete but in tolerance";
	}else
	{
		reload = 1;
		status = "I"; reason = "may be obsolete and out of tolerance";
	}

	if( pfp != NULL )
		fclose(pfp);

	sv1log("FTP-CACHE-%s %s: (%s)\n",
		status,reload?"RELOAD":"REUSE",reason);
	if( obsolete && !reload || !obsolete && reload )
		sv1log("## ignore EXPIRE[%d] %d < %d\n",obsolete,Te,Tn-Tf);
	if( pfp != NULL ){
		Verbose("## LIST= %d {%d/%d} FILE= {%d/%d}\n",Td,TF,SF,Tf,Sf);
		Verbose("## tolerance=%d : newer=%d, age=%d : expire=%d\n",
			TT,Tf-TF,Tn-Tf,Te);
	}
	return reload;
}

#define STRIPPATH(path)	(path = (path[0] == '/') ? path + 1 : path)

FILE *fopen_ftpcache0(Conn,expire,host,port,path,ext,cpath,isdirp,sizep,mtimep)
	Connection *Conn;
	char *host,*path,*ext,*cpath;
	int *isdirp,*sizep,*mtimep;
{	char ocpath[1024];
	char xcpath[1024];
	FILE *cachefp;
	int expire0,fsize,mtime;
	int isdir;

	if( sizep ) *sizep  = -1;

	if( ftp_cachepath(Conn,host,port,path,cpath) == 0 )
		return NULL;

	strcpy(ocpath,cpath);
	if( ext && ext[0] )
		strcat(cpath,ext);

	isdir = *isdirp;
	strcpy(xcpath,cpath);
	if( isdir == 0 )
		ftpc_dirext(xcpath);

	Verbose("(don't determin expire here)\n");
	expire0 = 0x7FFFFFFF; /* don't determine expire here */

	if( isdir <= 0 && (cachefp = cache_fopen_rd("FTP/HTTP",cpath,expire0,&mtime)) ){
		if( isdir == 0 ) *isdirp = -1;
	}else
	if( 0 <= isdir && (cachefp = cache_fopen_rd("FTP/HTTP",xcpath,expire,&mtime)) ){
		strcpy(cpath,xcpath);
		if( isdir == 0 ) *isdirp = 1;
	}else{
		return NULL;
	}

	fsize = file_size(fileno(cachefp));
	if( sizep ) *sizep = fsize;
	if( mtimep ) *mtimep = mtime;

	if( cache_reload(ocpath,cachefp,*isdirp,fsize,mtime,expire) ){
		fclose(cachefp);
		return NULL;
	}
	return cachefp;
}
FILE *fopen_ftpcache(Conn,expire,host,port,path,ext,cpath,isdirp)
	Connection *Conn;
	char *host,*path,*ext,*cpath;
	int *isdirp;
{	int size,mtime;
	FILE *cfp;

	*isdirp = 0;
	cfp = fopen_ftpcache0(Conn,expire,host,port,path,ext,cpath,isdirp,
		&size,&mtime);
	if( *isdirp < 0 )
		*isdirp = 0;
	return cfp;
}

httpftp_cached(Conn,tc,user,host,port,path)
	Connection *Conn;
	FILE *tc;
	char *user,*host,*path;
{	char cpath[1024];
	FILE *cachefp;
	FILE *tc0;
	int expire,isdir,fsize,mtime;
	int totalc;

	STRIPPATH(path);

	SetStartTime();

	if( !is_anonymous(user) )
		return 0;
	IsAnonymous = 1;

	expire = http_EXPIRE(Conn,host);
	cachefp = fopen_ftpcache(Conn,expire,host,port,path,"",cpath,&isdir);
	if( cachefp == NULL )
		return 0;

	tc0 = tc;
	if( !relayThru(Conn) && fileMaybeText(path) )
		tc = openHttpResponseFilter(Conn,tc0);

	if( isdir ){
		putHttpHeader1(Conn,tc,DGserv(),"text/html",NULL,0,0);
		mtime = file_mtime(fileno(cachefp));
		totalc = dir_copy(Conn,cachefp,tc,NULL,user,host,port,path,FORM_HTML,mtime);
	}else{
		fsize = file_size(fileno(cachefp));
		totalc = ident_copy(Conn,cachefp,tc,NULL,DGserv(),path,fsize,0);
	}
	fclose(cachefp);

	if( tc != tc0 ){
		fclose(tc);
		wait(0);
	}
	sv1log("FTP/HTTP from cache [%d bytes] %s\n",totalc,cpath);
	return totalc;
}

static dumpfiles(){
	int fd;
	fprintf(stderr,"#### FILES #### ");
	for( fd = 0; fd < 128; fd++ ){
		if( 0 < file_ISSOCK(fd) )
			fprintf(stderr,"S:%d,",fd);
		else
		if( file_isreg(fd) )
			fprintf(stderr,"R:%d,",fd);
		else
		if( file_is(fd) )
			fprintf(stderr,"?:%d,",fd);
	}
	fprintf(stderr,"\n");
}

static int authDBG = 0;
#define AUTHDBG	authDBG==0?0:fprintf

httpftp(Conn,fc,tc,ver,method,svsock,auth,uuser,upass,host,port,gtype,path)
	Connection *Conn;
	FILE *fc,*tc;
	char *ver,*method;
	char *auth,*uuser,*upass,*host,*path;
{	FILE *tc0,*fsc,*svdata;
	int server = -1;
	char req[1024],authinfo[1024],auser[256],apass[256],dpass[256];
	int uuser_anon,auser_anon;
	char *cuser,*ruser,*rpass;
	char xpath[1024];
	char resp[4096];
	char buff[1024];
	int totalc = 0;
	int isdir;
	int put;
	int docache;
	char cachepath[1024],xcachepath[1024];
	FILE *cachefp;
	int gotok;

	STRIPPATH(path);

	sprintf(req,"%s ftp://%s:%d/%s HTTP/%s",method,host,port,path,ver);
	sv1log("FTP/HTTP: %s\n",req);
	put = strcaseeq(method,"PUT");

	tc0 = tc;
	if( !relayThru(Conn) && fileMaybeText(path) )
		tc = openHttpResponseFilter(Conn,tc0);

	docache = get_ftpcache(Conn,uuser,host,port,path,"",cachepath);
	cachefp = NULL;
	gotok = 0;

	auser[0] = apass[0] = 0;
	sscanf(auth,"%[^:]:%[^\r\n]",auser,apass);
	uuser_anon = is_anonymous(uuser);
	auser_anon = is_anonymous(auser);
	FTPHTTP_genPass(dpass);

	/*
	 * uuser : upass  -- user & pass in request URL (or in SERVER parameter)
	 * auser : apass  -- user & pass in request HTTP Authorization header
	 *         dpass  -- ADMIN's e-mail address
	 *
	 * With AUTH=anonftp, user's e-mail address is sent as USER name (auser)
	 * if AUTH=anonftp, auser is checked to be a valid e-mail address, and
	 *  (1)	anonymous  + upass  -- use password in URL if exists (*A)
	 *  (2) anonymous  + apass  -- only if auser==anonymous
	 *  (3)	anonymous  + auser  -- use password in Authorization
	 *  (4)	anonymous  + dpass  -- use ADMIN if no password is given
	 * else
	 * if uuser is anonymous
	 *  (1)	anonuymous + upass  -- (*A)
	 *  (2)	anonuymous + apass  -- only if auser==anonymous (*B)
	 *  (3)	anonuymous + dpass
	 * else
	 *  (1)	auser      + apass  -- auser can be anonymous or anything
	 *  (2)	uuser      + upass
	 *
	 * (*A) uuser:upass in URL is given top priority because it can be
	 *      explisitly controled by user than auser:apass in Authorization
	 * (*B) to avoid leak of password for non-anonymous user which may
	 *      be sent from client when switched from non-anonymous account
	 *
	 */

	AUTHDBG(stderr,"## AUTH [%s]:[%s] URL[%s]:[%s] WAA=%d\n",
	auser,apass,uuser,upass,CTX_with_auth_anonftp(Conn));

	if( uuser_anon &&  CTX_with_auth_anonftp(Conn) /* AUTH=anonftp */ ){
		if( !auser_anon )
			cuser = auser;
		else	cuser = apass; /* if no passwd check in AUTH=anonftp */

		if( !NoAuth )
		if( CTX_checkAnonftpAuth(Conn,cuser,apass) != 0 ){
FILE*tmp;
char *mssg;
int size;
tmp = TMPFILE("FTP/anonftpAuth");
putBuiltinHTML(Conn,tmp,"FTP/anonftpAuth","file/ftpgw-anonauth.dhtml",
NULL,printItem,NULL);
fflush(tmp); size = ftell(tmp); fseek(tmp,0,0);
mssg = malloc(size+1);
fread(mssg,1,size,tmp);
mssg[size] = 0;
fclose(tmp);
totalc = putNotAuthorized(Conn,tc,req,ProxyAuth,NULL,mssg);
free(mssg);
			AUTHDBG(stderr,"## AUTH [%s]:[%s] ERROR\n",cuser,apass);
			goto EXIT;
		}
		AUTHDBG(stderr,"## AUTH [%s]:[%s] OK\n",cuser,apass);

		ruser = uuser;
		if( *upass )
			rpass = upass;
		else
		if( *auser && !auser_anon )
			rpass = auser;
		else
		if( *apass && auser_anon )
			rpass = apass;
		else	rpass = dpass;
	}else{
		if( uuser_anon ){
			ruser = uuser;
			if( *upass )
				rpass = upass;
			else
			if( auser_anon && apass[0] )
				rpass = apass;
			else	rpass = dpass;
		}else{
			if( *auser && !streq(auser,uuser) )
				ruser = auser;
			else	ruser = uuser;
			if( *apass )
				rpass = apass;
			else	rpass = upass;
		}
	}
	AUTHDBG(stderr,"## LOGIN[%s]:[%s]\n",ruser,rpass);

	sv1log("authorization user[%s] pass[%s]\n",
		ruser,is_anonymous(ruser)?rpass:"********");

	if( unescape_path(path,xpath) )
		path = xpath;

	if( svsock != -1 )
		server = dup(svsock);
	else
	if( (server = connect_to_serv(Conn, FromC,ToC,0)) < 0 ){
		sv1log("FTP/HTTP: cannot connect to the server\n");
		totalc = putHttpCantConnmsg(Conn,tc,DST_PROTO,DST_HOST,DST_PORT,
			req);
		goto EXIT;
	}
	sv1log("FTP/HTTP: server opened [%d]\n",server);

	fsc = fdopen(server,"r");
	svdata = ftp_fopen(Conn,put,server,host,ruser,rpass,path,resp,sizeof(resp),&isdir);

	if( svdata == NULL ){
		sv1log("FTP/HTTP: negotiation with the server failed\r\n");
		if( atoi(resp) == 530 ){
			putErrorHead(Conn,tc,VNO,req,host,resp);
		}else
		if( put ){
			char req[1024];
			sprintf(req,"PUT ftp://%s:%d/%s\r\n",host,port,path);
			putHttpRejectmsg(Conn,tc,"ftp",host,port,req);
		}else{
			delayUnknown(Conn,1,req);
			putHttpNotFound(Conn,tc,resp);
		}
		fprintf(tc,"<TITLE> FTP/HTTP error </TITLE>\n");
		fprintf(tc,"<P>\n");
		fprintf(tc,"<B>FTP/HTTP error</B>:<BR>\n");
		fprintf(tc,"USER:[%s]<BR>\n",ruser);
		fprintf(tc,"PASS:[%s]<BR>\n",is_anonymous(ruser)?rpass:"******");
		fprintf(tc,"Message from %s follows:<BR>\n",host);
		fprintf(tc,"<MENU><PRE>%s</PRE></MENU>\n",resp);
		putFrogVer(Conn,tc);
	}else{
	    if( put ){
		char cLeng[1024],*buff;
		int Length,rcc;

		HTTP_getRequestField(Conn,"Content-Length",cLeng,sizeof(cLeng));
		Length = atoi(cLeng);
		if( Length <= 0 ){
			putHttpHeader1(Conn,tc,DGserv(),"text/html",NULL,0,0);
			fflush(tc);
			fclose(tc);
			totalc = copyfile1(fc,svdata);
		}else{
			buff = malloc(Length);
			rcc = freadTIMEOUT(buff,1,Length,fc);
			totalc = fwriteTIMEOUT(buff,1,rcc,svdata);
			free(buff);
			putHttpHeader1(Conn,tc,DGserv(),"text/html",NULL,0,0);
		}
		sv1log("FTP/HTTP DONE: PUT %d bytes\n",totalc);
	    }else{
		int size = 0;

		if( docache )
			cachefp = cache_make("FTP/HTTP",cachepath,xcachepath);

		if( isdir ){
			putHttpHeader1(Conn,tc,DGserv(),"text/html",NULL,0,0);
			totalc = dir_copy(Conn,svdata,tc,cachefp,ruser,host,port,path,FORM_HTML,0);
		}else{
			size = FTP_datasize(resp);
			totalc = ident_copy(Conn,svdata,tc,cachefp,DGserv(),path,size,0);
		}
		gotok = isdir || !isdir && (size == totalc);
		sv1log("FTP/HTTP DONE: GOT %d / %d bytes\n",totalc,size);
	    }
	    fclose(svdata);
	}

	write(server,"QUIT\n",5);
	while( fgetsTIMEOUT(buff,sizeof(buff),fsc) != NULL)
/*
		if( strncmp(buff,"221",3) == 0 )
			break;
*/
;
	fclose(fsc);

EXIT:
	if( tc != tc0 ){
		fclose(tc);
		wait(0);
	}
	if( docache && cachefp != NULL ){
		if( isdir )
			ftpc_dirext(cachepath);
		cache_done(gotok,cachefp,cachepath,xcachepath);
	}
	return totalc;
}

#endif /* !MAIN */


file_copy(src,dst,cache,bytes,binary)
	FILE *src,*dst,*cache;
	int *binary;
{	int rbytes;
	int totalc,rcc;
	int ci,bin;
	char buff[1024*8];
	int bsize;

	if( file_isreg(fileno(src)) )
		bsize = sizeof(buff);
	else	bsize = 2048;

	if( bytes == 0 )
		rbytes = 0x7FFFFFFF;
	else	rbytes = bytes;
	totalc = 0;
	bin = 0;

	while( 0 < rbytes ){
		if( bsize < rbytes )
			rcc = bsize;
		else	rcc = rbytes;

		if( (rcc = fread(buff,1,rcc,src)) == 0 )
			break;
		if( fwrite(buff,1,rcc,dst) == 0 )
			break;

		if( ferror(dst) && cache == NULL ){
			sv1log("file_copy: client disconnected & no-cache\n");
			break;
		}

		if( cache != NULL )
			fwrite(buff,1,rcc,cache);

		if( bin == 0 )
		for( ci = 0; ci < rcc; ci++ )
			if( buff[ci] & 0x80 ){
				bin = 1;
				break;
			}

		totalc += rcc;
		rbytes -= rcc;
	}
	if( binary )
		*binary = bin;
	return totalc;
}

dir_copy(Conn,src,dst,cachefp,user,host,port,path,form,ctime)
	Connection *Conn;
	FILE *src,*dst,*cachefp;
	char *user,*host,*path;
{	int lines,totalc;
	char line[1024],dirent[1024];
	FtpEnv env;

	totalc = 0;

	if( form == FORM_GOPHER ){
		fprintf(dst," Content of FTP Directory: HOST[%s] DIR[%s]\n\n",
			host,path);
	}
	if( form == FORM_HTML ){
		env.isdir = 1;
		env.user = user;
		env.host = host;
		env.port = port;
		env.path = path;
putBuiltinHTML(Conn,dst,"FTP/header","file/ftpgw-header.dhtml",NULL,
printItem,&env);
	}

/* skip "total" line
fgetsTIMEOUT(line,sizeof(line),src);
*/
	for( lines = 0; fgetsTIMEOUT(line,sizeof(line),src) != NULL; )
	{
		if( cachefp != NULL )
			fputs(line,cachefp);

		if( lines == 0 && strncasecmp(line,"total",5) == 0 )
			continue;

		ls_form(Conn,line,dirent,host,port,path,form);
		fputs(dirent,dst);
		fflush(dst);

		if( ferror(dst) && cachefp == NULL ){
			sv1log("dir_copy: client disconnected & no-cache\n");
			break;
		}

		totalc += strlen(dirent);
		lines++;
	}

	env.dir_lines = lines;
	env.proc_secs = Time() - GetStartTime();
	env.cache_date = ctime;
	if( form == FORM_HTML ){
putBuiltinHTML(Conn,dst,"FTP/tailer","file/ftpgw-tailer.dhtml",NULL,
printItem,&env);
putFrogForDeleGate(Conn,dst,"");
	}

	return totalc;
}


/*
 *	support only UNIX type "ls -lL" output
 */
static isMSDOSDIR(line,isdir)
	char *line;
	int *isdir;
{
	if( isdigit2(&line[0]) && line[2] == '-' )
	if( isdigit2(&line[3]) && line[5] == '-' ){
		if( isdir ) *isdir = (strstr(line,"<DIR>") != NULL);
		return 1;
	}
	return 0;
}
char *scan_ls_l(lsl,mode,linkp,owner,group,sizep,date,name,sname)
	char *lsl,*mode,*owner,*group,*date,*name,*sname;
	int *linkp,*sizep;
{	char *slp,*dp,*np,*nnp;
	char modeb[128],tmp[256],links[256],field4[128];
	int len,nlink;

	if( sname )
		*sname = 0;
	if( mode == NULL )
		mode = modeb;

	if( dp = strpbrk(lsl,"\r\n") )
		*dp = 0;

	if( isMSDOSDIR(lsl,NULL) ){
		char time[32],typesize[32];

		if( linkp ) *linkp = 0;
		if( owner ) *owner = 0;
		if( group ) *group = 0;
		*name = 0;
		*sname = 0;

		sscanf(lsl,"%s %s %s %s",date,time,typesize,name);
		strcat(date," ");
		strcat(date,time);

		if( strcasecmp(typesize,"<DIR>") == 0 ){
			strcpy(mode,"d");
			if( sizep ) *sizep = 0;
		}else{
			strcpy(mode,"-");
			if( sizep ) *sizep = atoi(typesize);
		}
		return name;
	}

	/* np = wordscanX(np,mode,128); */
	np = lsl;
	sscanf(np,"%[^ \t\r\n0-9]",mode);
	np += strlen(mode);
	np = wordScan(np,tmp);

	strcpy(links,tmp);
	if( len = strlen(links) ){
		if( links[len-1] == 'L' )
			links[len-1] = 0;
	}

	if( !isdigits(links) )
	{
		if( linkp ) *linkp = 0;
		if( owner ) strcpy(owner,tmp);
		np = wordScan(np,tmp);
		if( sizep ) *sizep = atoi(tmp);
		nnp = scanLsDate(np,date);
		if( nnp == NULL ){
			strcpy(name,"?");
			return NULL;
		}
		np = nnp;
	}else{
		if( linkp ) *linkp = atoi(links);
		if( owner )
			np = wordscanX(np,owner,128);
		else	np = wordScan(np,tmp);
		np = wordScan(np,field4);

		if( isdigits(field4) && (nnp = scanLsDate(np,date)) != NULL ){
			np = nnp;
			if( group ) *group = 0;
			if( sizep ) *sizep = atoi(field4);
		}else{
			if( group ) strcpy(group,field4);
			np = wordScan(np,tmp);
			if( sizep ) *sizep = atoi(tmp);
			np = scanLsDate(np,date);

			if( !isdigits(tmp) || np == NULL ){
				strcpy(name,"?");
				return NULL;
			}
		}
	}
	while( *np == ' ' )
		np++;
	strcpy(name,np);

	if( *mode == 'l' ){
		mode[0] = '-';
		if( slp = strstr(name," -> ") ){
			*slp = 0;
			slp += 4;
			if( sname )
				strcpy(sname,slp);
			if( (dp = strrchr(slp,'/')) && dp[1]==0 )
				mode[0] = 'd';
		}
	}
	return name;
}

ls_form(Conn,line,dirent,host,port,dir,form)
	Connection *Conn;
	char *line,*dirent,*host,*dir;
{	int gtype,isdir;
	char *dp,name[1024],*dispname,dnameb[1024];
	int size;
	char path[1024];
	char xselector[1024];
	char url[1024],durl[1024];
	char *proto;
	char hostport[128];
	char image[1024],*icon,*ialt,iconbase[256];

	if( *line == '-' ){
		gtype = 0;
		strcpy(name,line);
		if( dp = strpbrk(name,"\r\n") )
			*dp = 0;
		if((dp = strrchr(name,'~')) && dp[1] == 0 )
			*dp = 0;
		if( dp = strrchr(name,' ') )
			gtype = filename2gtype(dp+1);
		else	gtype = filename2gtype(name);
	}else
	switch( *line ){
		case 'l': gtype = '1'; break; /* X-< */
		case 'd': gtype = '1'; break;
		case 's': gtype = '-'; break;
		default:
			if( !isMSDOSDIR(line,&isdir) ){
				strcpy(dirent,line);
				return;
			}
			if( isdir )
				gtype = '1';
			else	gtype = '-';
	}

	if( dp = strrchr(line,' ') ){
		char mode[128],date[128],sname[1024];
		scan_ls_l(line,mode,NULL,NULL,NULL,&size,date,name,sname);
		if( *sname ){
			if( *mode == 'd' )
				gtype = '1';
			else	gtype = '-';
		}
		if( gtype == '1' )
			strcat(name,"/");
		sprintf(dnameb,"%10d %s",size,date);
		dispname = dnameb;
	}else{
		dispname = "?";
		strcpy(name,"?");
	}

	if( DONT_REWRITE ){
		char *lastdir;
		if( strtailchr(dir) != '/' ){
			if( lastdir = strrchr(dir,'/') )
				lastdir++;
			else	lastdir = dir;
			sprintf(path,"%s/%s",lastdir,name);
		}else	strcpy(path,name);
	}else{
		if( dir[0] == 0 || name[0] == '/' )
			strcpy(path,name);
		else
		if( strtailchr(dir) != '/' )
			sprintf(path,"%s/%s",dir,name);
		else	sprintf(path,"%s%s",dir,name);
	}

	/* reduce ./ and ../ */{
		char *cdir,*pdir,*ppdir;

		while( cdir = strstr(path,"/./") )
			strcpy(cdir,cdir+2);

		while( pdir = strstr(path,"/../") ){
			if( pdir == path )
				ppdir = path;
			else
			for( ppdir = pdir-1; path < ppdir; ppdir-- )
				if( *ppdir == '/' )
					break;
			strcpy(ppdir,pdir+3);
		}
	}

	proto = "ftp";
	HostPort(hostport,proto,host,port);

	if( form == FORM_GOPHER ){
		char myhost[128];
		int myport;

		myport = ClientIF_H(Conn,myhost);
		sprintf(xselector,"%s=@=ftp:%s=%c",path,hostport,gtype);
		sprintf(dirent,"%c%s\t%s\t%s\t%d\n",
			gtype,dispname,xselector,myhost,myport);
	}else
	if( form == FORM_HTML ){
		nonxalpha_escape(path,path);

		if( DONT_REWRITE )
			strcpy(durl,path);
		else{
			if( path[0] == '/' && path[1] == '/' ) 
				sprintf(url,"%s://%s%s",proto,hostport,path);
			else	sprintf(url,"%s://%s/%s",proto,hostport,path);
			redirect_url(Conn,url,durl);
		}

		getCERNiconBase(Conn,iconbase);
		if( gtype == '1' )
			icon = filename2icon("/", &ialt);
		else	icon = filename2icon(path,&ialt);

		sprintf(image,"ALT=\"[%s]\" ALIGN=TOP SRC=\"%s%s\"",
			ialt,iconbase,icon);

		sprintf(dirent,"%s <IMG %s> <A HREF=\"%s\"><B>%s</B></A>\n",
			dispname,image,durl,name);
	}
}
/*
maybe, HREF=file is enough except in case when the directory is refered
without trailing '/'.   such access should be redirected by `302 Moved'...
 */

ls2html_main(ac,av)
	char *av[];
{	FILE *ls;
	char *dir,command[256],hostname[256];
	Connection ConnBuf, *Conn = &ConnBuf;
	char myif[256],myhost[256];
	int myport;
	int ai;
	char baseurl[256];

	dir = "/";
	for( ai = 1; ai < ac; ai++ ){
		if( av[ai][0] != '-' )
		if( strchr(av[ai],'=') == NULL ){
			dir = av[ai];
			break;
		}
	}
	DONT_REWRITE = 1;

	sprintf(command,"ls -lL %s",dir);

	ConnInit(Conn);
	if( myport = myhostport(myhost,sizeof(myhost)) )
		sprintf(myif,"%s:%d",myhost,myport);
	else	strcpy(myif,"-.-");

	sprintf(baseurl,"//%s",myif);
	set_BASEURL(Conn,baseurl);

	SetStartTime();
	if( isatty(0) )
		ls = popen(command,"r");
	else	ls = stdin;

	gethostname(hostname,sizeof(hostname));
	dir_copy(Conn,ls,stdout,NULL,"ftp",hostname,21,dir,FORM_HTML,0);

	if( ls != stdin )
		pclose(ls);
}
