/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	filetype.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950707	extracted from ftpgw.c
//////////////////////////////////////////////////////////////////////#*/
#include "ystring.h"

typedef struct {
	char	*suffix;
	char	 gtype;
	char	*ialt;
	char	*icon;
	char	*ctype;
} Filetype;

static Filetype *filetypes[128];
static int filetypex;

static char *dflt_filetypes[] = {
	".txt    :0 :TXT :text       :text/plain",
	".c      :0 :TXT :text       :text/plain",
	".h      :0 :TXT :text       :text/plain",
	".doc    :0 :TXT :text       :application/octet-stream",
	".html   :0 :HTM :text       :text/html",
	".dhtml  :0 :HTM :text       :text/html",
	".htm    :0 :HTM :text       :text/html",
	".ps     :0 :PS  :document   :application/postscript",
	".xbm    :I :XBM :image      :image/x-xbitmap",
	".gif    :g :GIF :image      :image/gif", 
	".png    :I :PNG :image      :image/png",
	".jpg    :I :JPG :image      :image/jpeg",
	".mpg    :I :MPG :movie      :video/mpeg",
	".mov    :I :MOV :movie      :video/quicktime",
	".au     :9 :AUD :sound      :audio/basic",
	".tar    :9 :TAR :tar        :application/octet-stream",
	".uu     :6 :UUE :uu         :application/octet-stream",
	".gz     :9 :ZIP :gzip       :application/octet-stream",
	".Z      :9 :CMP :compressed :application/octet-stream",
	".hqx    :4 :HQX :binhex     :application/mac-binhex40",
	".bat    :0 :BAT :text       :text/plain",
	".exe    :9 :EXE :binary     :application/octet-stream",
	".dll    :9 :DLL :binary     :application/octet-stream",
	".pac    :0 :PAC :text       :application/x-ns-proxy-autoconfig",
	"README  :0 :TXT :text       :text/plain",
	"INDEX   :0 :TXT :text       :text/plain",
	"HELP    :0 :TXT :text       :text/plain",
	"/       :1 :DIR :directory  :text/html",
	0
};

scan_FILETYPE(_,filetype)
	char *_;
	char *filetype;
{	char suffix[64],gtype[64],alt[64],icon[64],ctype[64],str[64];
	int nitem;
	Filetype *ft;

	nitem = sscanf(filetype,"%[^:]:%[^:]:%[^:]:%[^:]:%[^:]",
		suffix,gtype,alt,icon,ctype);
	if( 5 <= nitem ){
		ft = (Filetype*)calloc(1,sizeof(Filetype));
		filetypes[filetypex++] = ft;
		wordScan(suffix,str); ft->suffix = strdup(str);
		wordScan(gtype,str);  ft->gtype  = str[0];
		wordScan(alt,str);    ft->ialt   = strdup(str);
		wordScan(icon,str);   ft->icon   = strdup(str);
		wordScan(ctype,str);  ft->ctype  = strdup(str);
	}else{
		printf("??FILETYPE=\"%s\"??\n",filetype);
	}
	return 0;
}

static initdone;
static init_types()
{	int fx;
	char *filetype;

	if( initdone++ != 0 )
		return;

	for( fx = 0; filetype = dflt_filetypes[fx]; fx++ )
		scan_FILETYPE(0L,filetype);
}
static suffix(path,sfx)
	char *path,*sfx;
{	char *sp;
	int len;

	if( sp = strcasestr(path,sfx) ){
		len = strlen(sfx);
		if( sp[len] == 0 ) return 1;
		if( sp[len] == '~' && sp[len+1] == 0 ) return 1;
	}
	return 0;
}
char *filename2ctype(path)
	char *path;
{	int ci;
	Filetype *ft;

	init_types();
	for( ci = 0; ft = filetypes[ci]; ci++ ){
		if( suffix(path,ft->suffix) )
			return ft->ctype;
	}
	return 0;
}
filename2gtype(name)
	char *name;
{	int ci;
	Filetype *ft;

	init_types();
	for( ci = 0; ft = filetypes[ci]; ci++ ){
		if( suffix(name,ft->suffix) )
			return ft->gtype;
	}
	return '9';
}
char *filename2icon(path,ialt)
	char *path,**ialt;
{	static char icon[128];
	int ci;
	Filetype *ft;

	init_types();
	for( ci = 0; ft = filetypes[ci]; ci++ ){
		if( suffix(path,ft->suffix) ){
			if( ialt ) *ialt = ft->ialt;
			strcpy(icon,ft->icon);
			goto EXIT;
		}
	}
	if( path[0] == 0
	 || path[strlen(path)-1] == '/'
	 || strcmp(path,".") == 0
	 || strcmp(path,"..") == 0
	){
		if( ialt ) *ialt = "DIR";
		strcpy(icon,"directory");
	}else{
		if( ialt ) *ialt = "UNK";
		strcpy(icon,"unknown");
	}
EXIT:
	strcat(icon,".gif");
	return icon;
}

fileMaybeText(path)
	char *path;
{	char *ctype;

	if( ctype = filename2ctype(path,0L) )
		if( strncasecmp(ctype,"text/",5) != 0 )
			return 0;
	return 1;
}
