/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ddi.c (DeleGate to DeleGate interface)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950218	extracted from conf.c and service.c
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "ystring.h"
char *malloc();
#define PEEKSIZE 0x2000

DDI_PollIn(Conn,fc,timeout)
	Connection *Conn;
	FILE *fc;
{	int nready;

	if( DDI_readyCbuf(Conn) )
		nready = 1;
	else	nready = fPollIn(fc,timeout);
	return nready;
}

DDI_clearCbuf(Conn)
	Connection *Conn;
{
if( FromCpeak != FromCfill )
sv1log("#### CLEAR CBUF: %d %d\n",FromCpeak,FromCfill);

	if( FromCbuff != NULL ){
		free(FromCbuff);
		FromCbuff = NULL;
	}
	FromCpeak = 0;
	FromCfill = 0;
	FromCread = 0;
}

DDI_pushCbuf(Conn,req,len)
	Connection *Conn;
	char *req;
{
	FromCfill = len;
	if( FromCbuff != NULL ){
		extern char *realloc();
		FromCbuff = realloc(FromCbuff,len+1);
	}else	FromCbuff = malloc(len+1);
	bcopy(req,FromCbuff,len);
	FromCbuff[len] = 0;
	FromCpeak = 0;
}
char *DDI_fgetsFromCbuf(Conn,str,size,fp)
	Connection *Conn;
	char *str;
	FILE *fp;
{	char ch;
	int dx;

	if( size == 0 )
		return NULL;
	if( size == 1 ){
		str[0] = 0;
		return str;
	}

	dx = 0;
	if( FromCbuff && FromCpeak < FromCfill ){
		while( FromCpeak < FromCfill ){
			if( size-1 <= dx ){
sv1log("#### DDI_fgetsFromCbuf: over flow! %d / %d\n",dx,size);
				AbortLog();
				break;
			}
			ch = str[dx++] = FromCbuff[FromCpeak++];
			if( ch == '\n' )
				break;
		}
		str[dx] = 0;
		if( FromCpeak == FromCfill ){
			/* don't DDI_proceedFromC(Conn) for Solaris... */
		}
		return str;
	}
	return NULL;
}
DDI_readyCbuf(Conn)
	Connection *Conn;
{
	return FromCbuff && FromCpeak < FromCfill;
}

DDI_flushCbuf(Conn,bbuff,bsize,fc)
	Connection *Conn;
	char *bbuff;
	FILE *fc;
{	int bn;

	bn = 0;
	while( 0 < DDI_readyCbuf(Conn) ){
		if( DDI_fgetsFromCbuf(Conn,bbuff+bn,bsize-bn,fc) == NULL )
			break;
		bn += strlen(bbuff+bn);
	}
	return bn;
}

extern char *fgetsTIMEOUT();

int PEEK_CLIENT_REQUEST = 0;

DDI_proceedFromC(Conn,fp)
	Connection *Conn;
	FILE *fp;
{	char buff[PEEKSIZE];
	int len,rrc,rcc;
	int rcode = 0;

	if( 0 < FromCread ){
		len = FromCpeak;
		rrc = 0;
		while( 0 < len && 0 < ready_cc(fp) ){
			if( getc(fp) == EOF )
				break;
			len--;
			rrc++;
		}
		rcc = reads(fileno(fp),buff,len);

		sv1log("-- discard %d+%d = %d /%d/%d Bytes of peeked request\n",
			rrc,rcc,FromCpeak,FromCfill,FromCread);

		if( rrc+rcc != FromCpeak ){
			sv1log("#### discard failed: %d + %d / %d\n",
				rrc,rcc,FromCpeak);
			rcode = -1;
		}
		DDI_clearCbuf(Conn);
	}
	return rcode;
}

DDI_peekcFromC(Conn,fp)
	Connection *Conn;
	FILE *fp;
{	int ch;

	if( FromCbuff && FromCpeak < FromCfill )
		return  FromCbuff[FromCpeak];

	if( PEEK_CLIENT_REQUEST )
		DDI_proceedFromC(Conn,fp);

	ch = getc(fp);
	if( ch != EOF ){
		char buff[1];
		buff[0] = ch;
		DDI_pushCbuf(Conn,buff,1);
	}
	return ch;
}
char *DDI_fgetsFromC(Conn,req,size,fp)
	Connection *Conn;
	char *req;
	FILE *fp;
{	char *rcode;
	int len;
	char buff[PEEKSIZE+1];
	int cc;

	if( size <= 0 ){
		sv1log("#### Negative size for DDI_fgetsFromC(%x,%d)\n",
			req,size);
		AbortLog();
		abort();
	}

	rcode = DDI_fgetsFromCbuf(Conn,req,size,fp);
	if( rcode != NULL ){
		if( strchr(req,'\n') != NULL )
			return rcode;
		else{
			len = strlen(req);
			return DDI_fgetsFromC(Conn,req+len,size-len,fp);
		}
	}

	cc = 0;
	if( ready_cc(fp) <= 0 )
	if( PEEK_CLIENT_REQUEST ){
		DDI_proceedFromC(Conn,fp);
		buff[0] = 0; /* a charm against Solaris2.X CC -O bug? */
		cc = recvPeekTIMEOUT(fileno(fp),buff,sizeof(buff)-1);

		if( 0 < cc ){
			FromCread = cc;
			Verbose("++ peek %d Bytes of request.\n",cc);
		}
	}
/*
else
if( 0 < PollIn(fileno(fp),2000) ){
	setNonblockingIO(fileno(fp),1);
	cc = readTIMEOUT(fileno(fp),buff,sizeof(buff)-1);
	setNonblockingIO(fileno(fp),0);
}
*/
/* switching NonBlocking seems halmful... e.g. http://www.opentext.com */

	if( 0 < cc ){
		buff[cc] = 0;
		DDI_pushCbuf(Conn,buff,cc);
		return DDI_fgetsFromC(Conn,req,size,fp);
	}

	rcode = fgetsTIMEOUT(req,size,fp);
	if( rcode == NULL )
		return NULL;
	else	return rcode;
}

char *CCV_TOCL = "tocl";
char *CCV_TOSV = "tosv";
extern int CodeConv_x;
CCV_clear(){ CodeConv_x = 0; }


ConnInit(Conn)
	Connection *Conn;
{
	bzero((char*)Conn,sizeof(Connection));
	ClientSock = -1;
	ToS = ToSX = FromS = FromSX = -1;
	RPORTsock = -1;

	if( strcmp(iSERVER_PROTO,"tunnel1") == 0 )
		Conn->from_myself = 1;
}


ConnCopy(Conn,OrigConn)
	Connection *Conn,*OrigConn;
{
	*Conn = *OrigConn;
	FromCbuff = NULL;
	headerX = 0;
	inputsX = 0;
	D_REQUEST = 0;
	LockedByClient = 0;
	clear_DGreq(Conn);
}

/*
 *	environment per client's connection
 */
clear_DGconn(Conn)
	Connection *Conn;
{
	CLIF_HOSTPORT[0] = 0;
	CLIF_HOST[0]   = 0;
	CLIF_PORT      = 0;

	D_SERVER[0]    = 0;
	D_SELECTOR[0]  = 0;
	D_USER[0]      = 0;
	D_FROM[0]      = 0;
	D_PATH[0]      = 0;

	clear_DGreq(Conn);
}
/*
 *	environment per request
 */
clear_DGreq(Conn)
	Connection *Conn;
{
	DDI_clearCbuf(Conn);
	if( headerX ) clear_DGheader(Conn);
	if( inputsX ) clear_DGinputs(Conn);
	CCV_clear();
	reset_MOUNTconds();
	GEN_VHOST[0]   = 0;

	MODIFIERS[0]   = 0;
	D_GTYPE[0]     = 0;
	D_HOPS         = 0;
	IAM_GATEWAY    = 0;
}
clear_DGclnt(Conn)
	Connection *Conn;
{
	ClientSock = -1;
	clear_DGreq(Conn);
}
/*
 *	constant through keep-alive
 */
restoreConn(dst,src)
	Connection *dst,*src;
{
	dst->sv_dflt        = src->sv_dflt;
	dst->sv             = src->sv;

	dst->cl.p_wantKeepAlive = src->cl.p_wantKeepAlive;
	dst->cl.p_willKeepAlive = src->cl.p_willKeepAlive;
	dst->cl.p_whyclosed[0] = '-';
	dst->cl_nocache     = src->cl_nocache;
	dst->cl_reqbuf      = NULL;
	dst->cl_setccx      = 0;

	dst->ca_dontread    = src->ca_dontread;
	dst->ca_dontwrite   = src->ca_dontwrite;
	dst->ca_curoff      = 0;
	dst->ca_mtime       = 0;

	dst->co_setup       = 0;
	dst->co_nonet       = src->co_nonet;
	dst->co_nointernal  = src->co_nointernal;
	dst->fi_builtin     = 0;

	dst->xf_filters     = src->xf_filters;

	dst->sv.p_viaCc     = 0;
	dst->sv.p_viaSocks  = 0;
	dst->sv.p_viaVSAP   = 0;
	dst->sv.p_connType  = 0;

	dst->oc_proxy[0]    = 0;
	dst->oc_norewrite   = src->oc_norewrite; /* DONT_REWRITE */
	dst->co_internal    = 0;
	dst->mo_options     = 0;

	dst->cl_noauth      = 0;
	dst->cl_auth.i_user[0] = 0;
	dst->no_dstcheck_proto = 0;
	dst->from_myself    = 0;

	if( strcmp(iSERVER_PROTO,"tunnel1") == 0 )
		dst->from_myself = 1;

	CCXclear(dst->cl.p_ccxbuf);
	CCXclear(dst->sv.p_ccxbuf);

	strcpy(dst->cl_baseurl,src->cl_baseurl);
}

#define PrintBuf(buf,fmt,a,b,c,d,e,f,g) { \
	sprintf(line,fmt,a,b,c,d,e,f,g); \
	Strncpy(buf,line,sizeof(buf)); \
	cbuf = buf; \
}

char *add_DGheader(Conn,head,fmt,a,b,c,d,e,f,g)
	Connection *Conn;
	char *head;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char *cbuf,line[0x4000];
	MemFile MemF;

	if( head == D_SERVER ){ PrintBuf(D_SERVER,fmt,a,b,c,d,e,f,g); }else
	if( head == D_FROM   ){ PrintBuf(D_FROM,  fmt,a,b,c,d,e,f,g); }else
	if( head == D_USER   ){ PrintBuf(D_USER,  fmt,a,b,c,d,e,f,g); }else
	if( head == D_PATH   ){ PrintBuf(D_PATH,  fmt,a,b,c,d,e,f,g); }else
	if( head == D_EXPIRE ){ PrintBuf(D_EXPIRE,fmt,a,b,c,d,e,f,g); }else
	{
		str_sopen(MemF,"add_DGheader",line,sizeof(line),0,"w");
		str_sprintf(MemF,"%s ",head);
		str_sprintf(MemF,fmt,a,b,c,d,e,f,g);
		str_sprintf(MemF,"\r\n");
		cbuf = strdup(line);
		if( headerX < DG_MAXHEAD )
			headerB[headerX++] = cbuf;
		else	sv1log("#### generalist header overflow: %s",cbuf);
	}
	return cbuf;
}
clear_DGheader(Conn)
	Connection *Conn;
{	int hi;

	if( headerX ){
		for( hi = 0; hi < headerX; hi++ ){
			free(headerB[hi]);
			headerB[hi] = 0;
		}
		headerX = 0;
	}
}
clear_DGinputs(Conn)
	Connection *Conn;
{	int hi;

	if( inputsX ){
		for( hi = 0; hi < inputsX; hi++ )
			free(inputsB[hi]);
		inputsX = 0;
	}
}

char *fgets_DGclient(Conn,str,size,fp)
	Connection *Conn;
	char *str;
	FILE *fp;
{	char *rcode;

	if( rcode = fgets(str,size,fp) )
		inputsB[inputsX++] = strdup(str);
	return rcode;
}
add_DGinputs(Conn,fmt,a,b,c,d,e,f,g)
	Connection *Conn;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char line[4096];
	MemFile MemF;

	str_sopen(MemF,"add_DGinputs",line,sizeof(line),0,"w");
	str_sprintf(MemF,fmt,a,b,c,d,e,f,g);
	Verbose("**** add_input: %s",line);
	inputsB[inputsX++] = strdup(line);
}


/*
 *	Transfer the local SPECIALIST's environment to the remote GENERALIST
 *	to act as a SPECIALIST for the local one.
 */
add_localheader(Conn,proxy)
	Connection *Conn;
{	char codeconv[128];

	if( proxy )
		add_DGheader(Conn,"LOCAL-PROXY","%d",1);

	if( !proxy ){
		char myhp[1024];

		ClientIF_HP(Conn,myhp);
		add_DGheader(Conn,"LOCAL-DELEGATE","%s",myhp);
	}
	if( DELEGATE_FLAGS[0] )
		add_DGheader(Conn,"LOCAL-FLAGS",   "%s",DELEGATE_FLAGS);

	/* why is this necessary? Gopher-Specialist DeleGate? */
	if( cur_codeconvCL(codeconv) )
		add_DGheader(Conn,"LOCAL-CHARCODE", "%s",codeconv);
}
del_DGlocalheader(Conn)
	Connection *Conn;
{
	clear_DGheader(Conn);
}
CTX_set_clientgtype(Conn,gtype)
	Connection *Conn;
{
	D_GTYPE[0] = gtype;
}
CTX_get_clientgtype(Conn)
	Connection *Conn;
{
	return D_GTYPE[0];
}

extern char *MY_HOSTPORT();
setProtoOfClient(Conn,proto)
	Connection *Conn;
	char *proto;
{
	strcpy(CLIENTS_PROTO,proto);
}
setProxyOfClient(Conn,proxy_client,url)
	Connection *Conn;
	char *url;
{
	if( proxy_client ){
		scan_URI_scheme(url,CLIENTS_PROTO,sizeof(CLIENTS_PROTO));
		strcpy(CLIENTS_PROXY,MY_HOSTPORT());
	}else{
		ClientIF_HP(Conn,CLIENTS_PROXY);
	}
}
char *isSetProxyOfClient(Conn,cl_proto)
	Connection *Conn;
	char *cl_proto;
{
	if( CLIENTS_PROXY[0] ){
		strcpy(cl_proto,CLIENTS_PROTO);
		return CLIENTS_PROXY;
	}else	return 0;
}

initConnected(Conn,svsock,relay_input)
	Connection *Conn;
{
	if( relay_input ){
		DG_relayInput(Conn,svsock);
	}
	set_keepalive(svsock,1);
	FromS = ToS = svsock;
}

OpenServer(what,proto,host,port)
	char *what,*proto,*host;
{	char *server;
	int svsock;

	if( server = strchr(host,'@') )
		server = server + 1;
	else	server = host;
	svsock = client_open("ConnectToServer",proto,server,port);
	/*
	sv1log("connected to %s://%s:%d\n",DFLT_PROTO,server,DFLT_PORT);
	*/
	return svsock;
}

extern int CONNERR_CANTRESOLV;
extern int CONNERR_TIMEOUT;
extern int CONNERR_REFUSED;
extern int CONNERR_UNREACH;

ConnectToServer(Conn,relay_input)
	Connection *Conn;
{	int svsock;

	CONNERR_CANTRESOLV = 0;
	CONNERR_TIMEOUT = 0;
	CONNERR_REFUSED = 0;
	CONNERR_UNREACH = 0;

	/* log for debug when REAL differs from DFLT ... */
	if( strcmp(DFLT_PROTO,REAL_PROTO)
	 || DFLT_PORT != REAL_PORT
	 || hostcmp(DFLT_HOST,REAL_HOST) != 0 )
	sv1log("ConnectToServer: DFLT=%s://%s:%d REAL=%s://%s:%d\n",
		DFLT_PROTO,DFLT_HOST,DFLT_PORT, REAL_PROTO,REAL_HOST,REAL_PORT);

	svsock = OpenServer("ConnectToServer",DST_PROTO,DST_HOST,DST_PORT);

	if( 0 <= svsock ){
		initConnected(Conn,svsock,relay_input);
		return svsock;
	}

	if( CONNERR_CANTRESOLV ) ConnError |= CO_CANTRESOLV;
	if( CONNERR_TIMEOUT    ) ConnError |= CO_TIMEOUT;
	if( CONNERR_REFUSED    ) ConnError |= CO_REFUSED;
	if( CONNERR_UNREACH    ) ConnError |= CO_UNREACH;
	return -1;
}
DG_relayInput(Conn,fd)
	Connection *Conn;
{	int hi;

	if( inputsX ){
		for( hi = 0; hi < inputsX; hi++ )
			write(fd,inputsB[hi],strlen(inputsB[hi]));
	}
}

char *CTX_add_PATH(Conn,me,hostport,teleport)
	Connection *Conn;
	char *me,*hostport,*teleport;
{	char path[4096],*pp;

	strcpy(path,me);
	pp = path+strlen(path);

	if( D_PATH[0] == 0 ){
		*pp++ = '!';
		strcpy(pp,hostport);
		pp += strlen(pp);
	}

	if( teleport[0] ){
		*pp++ = '[';
		strcpy(pp,teleport);
		pp += strlen(pp);
		*pp++ = ']';
	}

	*pp++ = '!';
	if( D_PATH[0] ) /* D_PATH given from client DeleGate */
		strcpy(pp,D_PATH);
	else	sprintf(pp,"%s;%d",D_USER,time(0));

	strcpy(D_PATH,path);
	return D_PATH;
}
char *CTX_get_PATH(Conn)
	Connection *Conn;
{
	return D_PATH;
}

static findPath1(path1,hostport)
	char *path1,*hostport;
{
	if( strcmp(path1,hostport) == 0 )
		return 1;
	return 0;
}
CTX_findInPath(Conn,host,port)
	Connection *Conn;
	char *host;
{	char *path,*pp;
	char hostport[256];

	path = CTX_get_PATH(Conn);
	sprintf(hostport,"%s:%d",host,port);
	return scan_List(path,'!',0,findPath1,hostport);
}

static match1(path1,user,hlid)
	char *path1,*user;
{	char host[1024];
	int port;

	if( sscanf(path1,"%[^:]:%d",host,&port) == 2 )
	if( matchPath1(hlid,user,host,port) )
		return 1;
	return 0;
}
CTX_matchPATH1(Conn,hlid,path,user)
	Connection *Conn;
	char *path,*user;
{
	if( path == NULL )
		path = D_PATH;
	return scan_List(path,'!',0,match1,user,hlid);
}
static matchs(path1,hlid)
	char *path1;
{	char host[1024];
	int port;

	if( sscanf(path1,"%[^:]:%d",host,&port) == 2 )
	if( matchPath1(hlid,"-",host,port) == 0 )
		return 1;
	return 0;
}
CTX_matchPATHs(Conn,hlid,path)
	Connection *Conn;
	char *path;
{
	if( path == NULL )
		path = D_PATH;
	return scan_List(path,'!',0,matchs,hlid) == 0;
}

setFROM(Conn,username,hostaddr,port)
	Connection *Conn;
	char *username,*hostaddr;
{
	sprintf(D_FROM,"%s@[%s] (port=%d; DeleGate%s)",
		username,hostaddr,port,DELEGATE_ver());
}
getFROM(Conn,username,hostaddr,ver)
	Connection *Conn;
	char *username,*hostaddr,*ver;
{	int port;

	username[0] = hostaddr[0] = 0;
	sscanf(D_FROM,"%[^@]@[%[^]]] (port=%d; DeleGate%s)",
		username,hostaddr,&port,ver);
	return port;
}

matchFROM(Conn,hlid)
	Connection *Conn;
{	char user[256],host[256],ver[256];
	int port;

	if( port = getFROM(Conn,user,host,ver) )
		return matchPath1(hlid,user,host,port);
	return 0;
}

CTX_VA_getOriginatorAddr(Conn,Vaddr)
	Connection *Conn;
	VAddr *Vaddr;
{	char tmp[1024],ohost[256],*dp;
	int oport;

	strcpy(tmp,D_PATH);

	bzero(Vaddr,sizeof(VAddr));
	if( dp = strrchr(tmp,'!') ){
		*dp = 0;
		if( dp = strrchr(tmp,'!') ){
			if( sscanf(dp+1,"%[^:]:%d",ohost,&oport) == 2 ){
				wordScan(ohost,Vaddr->a_name);
				Vaddr->a_port = oport;
				return oport;
			}
		}
	}
	return 0;
}

scan_header(Conn,fromC,name,value)
	Connection *Conn;
	char *name;
	char *value;
{
	if( streq(name,"MEDIATOR") ){
		D_HOPS++;
		add_DGheader(Conn,name,"%s",value);
	}else
	if( streq(name,"FTPHOPS")){D_FTPHOPS = atoi(value); }else
	if( streq(name,"FROM")   ){add_DGheader(Conn,D_FROM,"%s",value); }else
	if( streq(name,"PATH")   ){add_DGheader(Conn,D_PATH,"%s",value); }else
	if( streq(name,"EXPIRE") ){add_DGheader(Conn,D_EXPIRE,"%s",value); }else
	if( streq(name,"LOCAL-GTYPE") ){
		sv1log("LOCAL-GTYPE: %s\n",value);
		CTX_set_clientgtype(Conn,*value);
	}else
	if( streq(name,"USER") ){
		char user[256];
		wordScan(value,user);
		CLNT_USER = strdup(user);
		add_DGheader(Conn,D_USER,"%s",user);
	}else
	if( streq(name,"CALLER") ){
		char user[256];
		sscanf(value,"CALLER %s %s %d",user, CLNT_HOST, &CLNT_PORT);
		CLNT_USER = strdup(user);
		add_DGheader(Conn,name,"%s",value);
	}else
	if( streq(name,"HOSTS") ){
		scan_HOSTS(Conn,value);
	}else
	{
		add_DGheader(Conn,name,"%s",value);
	}
}

setREQUEST(Conn,req)
	Connection *Conn;
	char *req;
{	char *dp;

	if( D_REQUEST )
		free(D_REQUEST);
	D_REQUEST = strdup(req);
	if( dp = strpbrk(D_REQUEST,"\r\n") )
		*dp = 0;
}


int REQUEST_SERNO;
int SERVREQ_SERNO;
incRequestSerno(Conn)
	Connection *Conn;
{
	return REQUEST_SERNO = ++RequestSerno;
}
incServReqSerno(Conn)
	Connection *Conn;
{
	return SERVREQ_SERNO = ++ServReqSerno;
}


char *CTX_clif_hostport(Conn)
	Connection *Conn;
{
	return CLIF_HOSTPORT;
}
char *CTX_get_modifires(Conn)
	Connection *Conn;
{
	return MODIFIERS;
}
char *CTX_set_modifires(Conn,modifires)
	Connection *Conn;
	char *modifires;
{
	strcpy(MODIFIERS,modifires);
}
char *CTX_get_baseurl(Conn)
	Connection *Conn;
{
	if( Conn->cl_baseurl[0] )
		return Conn->cl_baseurl;
	else	return 0;
}
set_BASEURL(Conn,url)
	Connection *Conn;
	char *url;
{	char proto[128],site[128],path[1024],host[128],sport[128],hp[128];
	int port;

	strcpy(Conn->cl_baseurl,url);
	Verbose("BASEURL=%s\n",url);
	if( isFullURL(url) ){
		path[0] = '/';
		decomp_absurl(url,proto,site,path+1,sizeof(path)-1);
		decomp_URL_site(site,host,sport);
		if( *sport )
			port = atoi(sport);
		else	port = serviceport(proto);

		Conn->my_vbase.u_proto = strdup(proto);
		Conn->my_vbase.u_host = strdup(host);
		Conn->my_vbase.u_port = port;
		Conn->my_vbase.u_path = strdup(path);
		HostPort(hp,proto,host,port);
		Conn->my_vbase.u_hostport = strdup(hp);

		sv1log("BASEURL= %s :// %s : %d %s\n",
			Conn->my_vbase.u_proto,Conn->my_vbase.u_host,
			Conn->my_vbase.u_port,Conn->my_vbase.u_path);
	}
}

/*
 * in current implementation, only FTOCL is supported to be
 * "mount-point-local" or "request-local" filter
 */
static mount_filters(Conn,opt)
	Connection *Conn;
	char *opt;
{
	if( strncasecmp(opt,"FTOCL=",6) == 0 )
			scan_FTOCL(opt+6);
	else
	if( strncasecmp(opt,"FTOSV=",6) == 0 )
			scan_FTOSV(opt+6);
	else
	return 0;

	sv1log("#### MountOption %s\n",opt);
	return 1;
}

static opt1(opt,Conn)
	char *opt;
	Connection *Conn;
{	int leng;

	if( strncasecmp(opt,"CHARCODE=",9) == 0 ){
		if( Conn->cl_setccx && CCXactive(CCX_TOCL) ){
			/* CCX is set by client */
		}else{
			leng = CCXcreate("*",opt+9,CCX_TOCL);
			sv1log("#### MountOption CHARCODE=%s [%d]\n",opt+9,leng);
		}
	}else
	if( strncasecmp(opt,"FTOSV=-cc-",10) == 0 ){
		if( CCXactive(CCX_TOSV) == 0 ){
			leng = CCXcreate("*",opt+10,CCX_TOSV);
			sv1log("#### MountOption FTOSV=%s [%d]\n",opt+10,leng);
		}
	}else
	if( mount_filters(Conn,opt) ){
	}else
	if( strcasecmp(opt,"AUTH=none") == 0 ){
		NoAuth = 1;
		sv1log("#### NoAuth\n");
	}else
	if( strncasecmp(opt,"MASTER=",7) == 0 ){
		MO_MasterPort = scan_hostport("http",opt+7,MO_MasterHost);
	} else
	if( strncasecmp(opt,"PROXY=",6) == 0 ){
		MO_ProxyPort = scan_hostport("http",opt+6,MO_ProxyHost);
	}
	else
	if( strncasecmp(opt,"GENVHOST=",9) == 0 )
		strcpy(GEN_VHOST,opt+9);
	else
	if( strncasecmp(opt,"CACHE=NO",8) == 0 )
		DontUseCache = DontReadCache = DontWriteCache = 1;
	else
	if( strncasecmp(opt,"EXPIRE=",7) == 0 ){
		strcpy(D_EXPIRE,opt+7);
	}
	else
	if( strncasecmp(opt,"BASEURL=",8) == 0 ){
		strcpy(Conn->cl_baseurl,opt+8);
	}
	return 0;
}
eval_mountOptions(Conn,opts)
	Connection *Conn;
	char *opts;
{
	scan_commaList(opts,0,opt1,Conn);
}
/* TODO...
 * evaluated mountOptions must be reset on the change of MOUNT point... 
 */

static Port curServ;

putServ(Conn,tsfd,fsfd)
	Connection *Conn;
{
	if( ServKeepAlive )
	if( IsConnected(fsfd,NULL) )
	if( IsConnected(tsfd,NULL) )
	if( 0 < PollIn(fsfd,1) ){
		sv1log("#HT11 putServ EOF or pending data from the server\n");
	}else
	{
		strcpy(curServ.p_host,DST_HOST);
		curServ.p_port = DST_PORT;
		curServ.p_wfd = tsfd;
		curServ.p_rfd = fsfd;
		curServ.p_viaProxy = toProxy;
		curServ.p_viaMaster = toMaster;
		strcpy(curServ.p_viaMasterVer,MediatorVer);
		curServ.p_connTime = Time();
		curServ.p_connType = ConnType;
sv1log("#HT11 putServ(%d/%d) %s:%d\n",
curServ.p_wfd,curServ.p_rfd,curServ.p_host,curServ.p_port);
		return 1;
	}
	return 0;
}
delServ(Conn,tsfd,fsfd)
	Connection *Conn;
{
sv1log("##HT11 delServ(%d/%d): %s:%d (%d/%d)\n",
		tsfd,fsfd,
		curServ.p_host,curServ.p_port,curServ.p_wfd,curServ.p_rfd);

	curServ.p_host[0] = 0;
	if( tsfd == curServ.p_wfd )
		curServ.p_wfd = -1;
	if( fsfd == curServ.p_rfd )
		curServ.p_rfd = -1;
}
getServ(Conn)
	Connection *Conn;
{	double age;

	if( curServ.p_host[0] == 0 )
		return 0;

	age = Time() - curServ.p_connTime;

	if( IsAlive(curServ.p_rfd)
	/* and service_permitted() */
	/* and (client dependent) filter is the common one ... */
	){
		if( hostcmp(curServ.p_host,DST_HOST) == 0
		 && curServ.p_port == DST_PORT ){
			if( 0 < PollIn(curServ.p_rfd,1) ){
				sv1log("#HT11 getServ EOF or pending data from the server\n");
			}else{
			incServReqSerno(Conn);

daemonlog("E","#HT11 getServ %4.1fs*%d SERVER REUSE (%d/%d) [%s:%d] %s\n",
age,ServReqSerno,curServ.p_wfd,curServ.p_rfd,
curServ.p_host,curServ.p_port,DST_HOST);

			toProxy = curServ.p_viaProxy;
			toMaster = curServ.p_viaMaster;
			strcpy(MediatorVer,curServ.p_viaMasterVer);
			FromS = curServ.p_rfd;
			ToS = curServ.p_wfd;
			ServConnTime = Time();
			ConnDelay = 0;
			ConnType = curServ.p_connType;
			}

		}else{
daemonlog("E","#HT11 getServ %4.1fs*%d SERVER SWITCH[%s:%d]->[%s:%d]\n",
age,ServReqSerno,
curServ.p_host,curServ.p_port,DST_HOST,DST_PORT);
		}
	}else{
daemonlog("E","#HT11 getServ %4.1fs*%d SERVER TIMEOUT[%s:%d] %s:%d\n",
age,ServReqSerno,
curServ.p_host,curServ.p_port,DST_HOST,DST_PORT);
	}

	if( 0 <= FromS ){
		return ++curServ.p_reqserno;
	}else{
		curServ.p_host[0] = 0;
		close(curServ.p_wfd);
		close(curServ.p_rfd);
		curServ.p_rfd = -1;
		curServ.p_wfd = -1;
		curServ.p_reqserno = 0;
		return 0;
	}
}
