/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	commands.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	981120	extracted from delegated.c (5.7.6)
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>

/* for P_LOGFILE */
#include "param.h"

extern int help_main();
extern int ccx_main();
extern int sched_main();
extern int resolvy_main();
extern int dget_main();
extern int urlfind_main();
extern int ls2html_main();
extern int thruwayd_main();
extern int teleport_main();
extern int system_main();
extern int htget_main();
extern int connect_main();
extern int icp_client();
extern int lpr_main();
extern int lpq_main();
extern int ls_main();
extern int md5_main();
extern int ENMIME_main();
extern int DEMIME_main();
extern int sendmail_main();
extern int alias_main();
extern int hmserver();
extern int hmrelay();
extern int hmget();
extern int alwais(); 
extern int durl_main();
extern int gopher_filter();
extern int cafe_main();
extern int shio_main();
extern int tar_main();
extern int sed_main();
extern int uudecode_main();
extern int dping_main();

extern int cgi_delegate();
extern int poprelay_main();
extern int teleportd();
extern int service_cuseeme();
extern int service_icp();
extern int service_dns();

typedef int (*IFUNC)();
typedef struct {
	int	 f_type;
	int	 f_withAdmin;
	int	 f_withLog;
	char	*f_proto;
	char	*f_name;
	IFUNC	 f_func;
	char	*f_desc;
} SubFunc;

#define MS	0	/* standalone function */
#define MN	1	/* function which uses network */
#define MV	2	/* server */

static SubFunc subfuncs[] = {
{MS,0,0,"",	"help",	   help_main,	"show the list of functions"},
{MV,0,0,"",	"cgi",     cgi_delegate,"DeleGate as a cgi program"},
{MS,0,0,"",	"ccx",	   ccx_main,	"character code converter"},
{MS,0,0,"",	"sched",   sched_main,	"scheduler compatible with `crond'"},
{MS,0,0,"",	"star",    tar_main,	"simple tar"},
{MS,0,0,"",	"ssed",    sed_main,	"simple sed"},
{MS,0,0,"",	"deuu",    uudecode_main,"simple uudecode"},
{MS,0,0,"",	"dping",   dping_main,  "application level ping"},
{MS,0,0,"",	"dget",	   dget_main,	"download by URL"},
{MN,0,0,"",	"poprelay",poprelay_main,"load from POP and relay to"},
{MS,0,0,"",	"urlfind", urlfind_main,"network wide find"},
{MS,0,0,"",	"thruwayd",thruwayd_main,"a circuit level proxy"},
{MN,0,0,"tcprelay","connect",connect_main,"connect to remote port"},
{MN,0,0,"",	"resolvy", resolvy_main,"host name resolver"},
{MN,0,0,"icp",	"icp",	   icp_client,	"ICP client"},
{MN,0,0,"http",	"htget",   htget_main,	"get by URL into HTML/HTTP format."},
{MS,0,0,"",	"system",  system_main,	"system commands"},
{MS,0,1,"",	"findu",   cafe_main,	"find + du"},
{MS,0,1,"",	"expire",  cafe_main,	"expire (alias of -Ffindu)"},
{MS,0,0,"",	"shio",    shio_main,	"shell I/O"},
{MS,0,0,"",	"lpr",	   lpr_main,	"send to LPR"},
{MS,0,0,"",	"lpq",	   lpq_main,	"show status of LPR"},
{MS,0,0,"",	"ls",	   ls_main,	"unix like ls"},
{MS,0,0,"",	"md5",     md5_main,	"MD5 digest generator"},
{MS,0,0,"",	"enMime",  ENMIME_main,	"mime encoder"},
{MS,0,0,"",	"deMime",  DEMIME_main,	"mime decoder"},
{MN,0,0,"",	"sendmail",sendmail_main,"SMTP poster"},
{MS,0,0,"",	"alias",   alias_main,	"expand aliases of mail address"},
{MS,1,0,"http",	"hmserver",hmserver,	"(obsolete?)"},
{MS,0,0,"",	"hmrelay", hmrelay,	"(obsolete?)"},
{MS,0,0,"",	"hmget",   hmget,	"(obsolete?)"},
{MV,0,0,"",	"teleportd",teleportd,	"(obsolete?) Teleport server"},
{MS,0,0,"",	"teleport",teleport_main,"(obsolete?) connect to remote port"},
{MS,0,0,"",	"alwais",  alwais,	"(incomplete) just for test"},
{MS,0,0,"",	"ls2html", ls2html_main,"(obsolete) directory list to html"},
{MS,0,0,"",	"durl",	   durl_main,	"(obsolete) just for debug"},
{MS,0,0,"",	"gopher_filter",gopher_filter,	"(obsolete) just for debug"},
0
};
static help_main(ac,av)
	char *av[];
{	int fi;
	char *fname;

	printf("FUNCTIONS:\r\n");
	for( fi = 0; fname = subfuncs[fi].f_name; fi++ )
		printf("-F%-10s %s\r\n",fname,subfuncs[fi].f_desc);
}
static replace_log(ac,avp,nav,nab)
	char **avp[],*nav[],*nab;
{	FILE *lfp,*openLogFile();
	int ai,nac;
	char **av;

	if( DELEGATE_getEnv(P_LOGFILE) == 0 )
		return ac;
	if( (lfp = openLogFile(time(NULL))) == NULL )
		return ac;

	av = *avp;
	nac = 0;
	for( ai = 0; ai < ac; ai++ )
		nav[nac++] = av[ai];
	/* LOGFILE parameter from CRON-expire will be ignored with
	 * prefix "-ign" like -ign LOGFILE=path.
	 */

	nav[nac++] = "-log";
	sprintf(nab,"-%d",fileno(lfp));
	nav[nac++] = nab;
	nav[nac] = NULL;
	*avp = nav;
	return nac;
}
DELEGATE_subfunc(Conn,ac,av,func,Fopt,type)
	void *Conn;
	char *av[],*func;
{	int fi;
	char *fname,*sp;
	IFUNC ifunc;
	int ctype;
	char *nav[64];
	char nab[1024];
	char **avx;
	int acx;

	for( fi = 0; fname = subfuncs[fi].f_name; fi++ ){
		if( !strcaseeq(func,fname) )
			continue;

		ctype = subfuncs[fi].f_type;
		if( ctype == MV ){
			if( type != MV )
				return 1;
		}else
		if( ctype == MN ){
			if( type != MN )
				return 1;
			if( subfuncs[fi].f_proto[0] )
			DELEGATE_ScanGlobal(Conn,subfuncs[fi].f_proto);
		}

		ifunc = subfuncs[fi].f_func;

		if( subfuncs[fi].f_withLog ){
			/* special case of "expire" */
			ac = replace_log(ac,&av,nav,nab);
		}else
		if( ctype == MV ){
			/* already did arg_scan() */
			/* don't need config for any client */
		}else{
			ac = DELEGATE_scan_args(ac,av);
			DELEGATE_config(Conn,-1);
		}

		if( subfuncs[fi].f_withAdmin )
		if( subfuncs[fi].f_proto[0] )
			checkADMIN(Conn,subfuncs[fi].f_proto);

		if( Fopt ){
			acx = ac - 1;
			avx = &av[1];
		}else{
			acx = ac;
			avx = av;
		}

		if( getenv("DELEGATE_DEBUG") ){
			int ai;
			for(ai=0;ai<acx;ai++)
				fprintf(stderr,"##[%d] %s\n",ai,avx[ai]);
		}

		(*ifunc)(acx,avx,Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	if( Fopt ){
		printf("DeleGate: unknown function -F\"%s\"\r\n",func);
		help_main(ac,av);
		Finish(-1);
	}
	return 0;
}
teleportd(ac,av,Conn,svsock,svport)
	char *av[];
	void *Conn;
{
	service_teleport(Conn,svsock,svport);
}

htget_main(ac,av)
	char *av[];
{
	if( ac < 2 ){
		fprintf(stderr,"Usage: %s URL\r\n",av[0]);
		return;
	}
	URLget(av[1],1,stdout);
}
system_main(ac,av)
	char *av[];
{	char *nav[256],nab[0x10000];
	int nac,ai;

	if( File_is(av[1]) /* should search in PATH ... */ ){
		Execvp("system",av[1],&av[1]);
	}else{
		nac = decomp_args(nav,256,av[1],nab);
		for( ai = 2; ai < ac; ai++ )
			nav[nac++] = av[ai];
		nav[nac] = 0;
		Execvp("system",nav[0],nav);
	}
}
/*
	if( strstr(func,"ipno") ){
		int i,n;
		if( 2 < ac )
			n = atoi(av[2]);
		else	n = 0;
		for(i = 0; i < n; i++)
			ipno("/usr/tmp/ipno",av[1]);
		printf("%d\n",ipno("/usr/tmp/ipno",av[1]));
	}
*/
