/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	admin.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

	- control DeleGate server from remote client via HTTP
	- dynamic MOUNT from a remote client via HTTP
	- public DeleGate tree (share log and consistency info. ?)

History:
	941009	extracted from http.c
	990716	extracted from httpd.c
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "delegate.h"
#include "http.h"
#define FPRINTF		leng += Fprintf

#define A_IDENT			0x00F
#define A_EVALED_IDENT		0x001
#define A_WITH_IDENTD		0x002	/* with identd, thus authenticated */
#define A_OK_IDENTAUTHOR	0x004	/* authorized */
#define A_PASS			0xFF0
#define A_EVALED_PASS		0x010
#define A_WITH_PASSAUTH		0x020	/* with password auth. */
#define A_OK_PASSAUTHEN		0x040	/* authenticated */
#define A_OK_PASSAUTHOR		0x080	/* authorized */
#define A_REJ_PASSAUTHEN	0x100	/* not authenticated */
#define A_REJ_PASSAUTHOR	0x200	/* not authenticated */

extern char *getv();
extern FILE *TMPFILE();
extern int DHTML_printConn();
extern int START_TIME;
extern char *gethostaddr();

static struct {
	FILE	*m_Fp;
	int	 m_FpPid;
	char	*m_lastset;
} Mtab;
#define MtabFp		Mtab.m_Fp
#define MtabFpPid	Mtab.m_FpPid
#define lastset		Mtab.m_lastset

static FILE *MtabFile(user,create)
	char *user;
{	char path[1024];
	FILE *fp;

	Verbose("MtabFile(%s,%d) init=[%d] Fp=%x\n",
		user,create,MtabFpPid,MtabFp);

	if( MtabFpPid == getpid() )
		goto EXIT;

	if( MtabFp != NULL )
		fclose(MtabFp);

	MtabFileName(user,path);
	MtabFp = dirfopen("MTAB",path,"r+");

	if( MtabFp == NULL && create )
		MtabFp = dirfopen("MTAB",path,"w+");

	if( MtabFp != NULL ){
		MtabFpPid = getpid();
		if( create )
			setCloseOnExec(fileno(MtabFp));
	}
EXIT:
	if( MtabFp != NULL ){
		fp = fdopen(dup(fileno(MtabFp)),"r+");
		if( fp == NULL ){
			sv1log("#### ERROR! MtabFile cannot fdopen(%d/%X)\n",
				fileno(MtabFp),MtabFp);
			return NULL;
		}
		fseek(fp,0,0);
		return fp;
	}
	return NULL;
}

DHTML_printMount(Conn,fp,fmt,name,param)
	Connection *Conn;
	FILE *fp;
	char *fmt,*name,*param;
{	FILE *mfp;
	char line[1024],vpat[256],rpat[1024],opts[256];
	char vurl[256],rurl[1024],uurl[256],*dp;

	mfp = MtabFile("anybody",0);
	if( mfp == NULL )
		return;

	while( fgets(line,sizeof(line),mfp) != NULL ){
		opts[0] = 0;
		sscanf(line,"%s %s %[^\r\n]",vpat,rpat,opts);

		if( streq(param,"mtab") ){
			strcpy(vurl,vpat);
			if( dp = strrchr(vurl,'*') ) if( dp[1] == 0 ) *dp = 0;
			strcpy(rurl,rpat);
			if( dp = strrchr(rurl,'*') ) if( dp[1] == 0 ) *dp = 0;
			sprintf(uurl,"/-/admin/unmount?%s",vpat);

fprintf(fp,
"<A HREF=\"%s\">U</A> <A HREF=\"%s\">%-24s</A> <A HREF=\"%s\">%-40s</A> %s\r\n",
uurl,vurl,vpat,rurl,rpat,opts);
		}
	}

	fclose(mfp);
}
static putMount(Conn,vno,tc,fromp)
	Connection *Conn;
	FILE *tc;
	char *fromp;
{
	return putBuiltinPage(Conn,vno,tc,"Mount","admin/mount.dhtml",
		NULL,DHTML_printConn,fromp);
}
static doMount(Conn,tc,spec,owner)
	Connection *Conn;
	FILE *tc;
	char *spec,*owner;
{	char *argv[256],*action,*fromp,*tol,*user,*comment,*val;
	FILE *mfp;
	char froms[1024],tos[1024],msg[1024],line[1024],froma[1024];
	int argc;

	mfp = MtabFile("anybody",1);
	if( mfp == NULL )
		return;

	argc = form2v(spec,256,argv);
	action  = getv(argv,"action");
	fromp   = getv(argv,"vurl-path");
	tol     = getv(argv,"rurl-login");
	user    = getv(argv,"user");
	comment = getv(argv,"comment");
	sv1log("MOUNT: [%s] from=[%s] to=[%s] src=[%s]\n",
		action?action:"", fromp?fromp:"",tol?tol:"",user?user:"");

	if( fromp[0] == '/' )
		froms[0] = 0;
	else	strcpy(froms,"/");
	if( val = getv(argv,"vurl-path") ) strcat(froms,val);
	if( strtailchr(froms) != '*' )
		if( val = getv(argv,"vurl-tail") ) strcat(froms,val);

	if( tol == NULL || tol[0] == 0 ){
		sprintf(msg,"Missing right hand part.\n");
		goto error;
	}

	tos[0] = 0;
	if( val = getv(argv,"rurl-proto") ) strcat(tos,val);
	if( val = getv(argv,"rurl-login") ) strcat(tos,val);
	if( val = getv(argv,"rurl-tail") )  strcat(tos,val);

	while( fgets(line,sizeof(line),mfp) != NULL ){
		wordScan(line,froma);
		if( strcmp(froms,froma) == 0 ){
			sprintf(msg,"Duplicate MOUNT for '%s'\n",froms);
			goto error;
		}
	}

	lock_exclusiveNB(fileno(mfp));
	fprintf(mfp,"%s\t%s\towner=%s\n",froms,tos,owner);
	fflush(mfp);
	fseek(mfp,0,0);
	sort_file(mfp,mfp,1);
	lock_unlock(fileno(mfp));
	return putMovedTo(Conn,tc,"/-/admin/mount");
error:
	return 1;
}
static unMount(Conn,vurl)
	Connection *Conn;
	char *vurl;
{	FILE *mfp,*tmp;
	char line[1024],vpat[256],*dp;

	mfp = MtabFile("anybody",0);
	if( mfp == NULL )
		return;

	tmp = TMPFILE("UNMOUNT");
	while( fgets(line,sizeof(line),mfp) != NULL ){
		wordScan(line,vpat);
		if( strcmp(vurl,vpat) != 0 )
			fputs(line,tmp);
	}
	fflush(tmp);
	fseek(tmp,0,0);
	fseek(mfp,0,0);

	lock_exclusiveNB(fileno(mfp));
	copyfile1(tmp,mfp);
	lock_unlock(fileno(mfp));

	fclose(tmp);
	Ftruncate(mfp,0,1);
}
static mountControl(Conn,vno,method,fc,tc,who)
	Connection *Conn;
	char *method;
	FILE *fc,*tc;
	char *who;
{	char *action,*user,*fromp,*tol,*comment,*val,froms[256],tos[256],*bp;
	char line[1024],froma[1024];
	FILE *mfp = NULL;
	char msg[1024];
	int leng;
	FILE *tmp;
	char *argv[256];

	if( strncmp(method,"POST",4) != 0 ) /* and not GET /action'?'args... */
	{
		leng = putMount(Conn,vno,tc,"");
		return leng;
	}

	HTTP_form2v(Conn,fc,256,argv);
	action  = getv(argv,"action");
	fromp   = getv(argv,"vurl-path");
	tol     = getv(argv,"rurl-login");
	user    = getv(argv,"user");
	comment = getv(argv,"comment");

	sv1log("MOUNT: [%s] from=[%s] to=[%s] src=[%s]\n",
		action?action:"", fromp?fromp:"",tol?tol:"",user?user:"");

	if( action == 0 ){
		sprintf(msg,"Missing action specification.\n");
		goto error;
	}

	if( fromp == 0 || fromp[0] == 0 ){
		sprintf(msg,"Missing left hand part.\n");
		goto error;
	}

	mfp = MtabFile("anybody",1);
	if( mfp == NULL ){
		sprintf(msg,"Cannot open MTAB file\n");
		goto error;
	}

	if( streq(action,"mount") ){
		if( fromp[0] == '/' )
			froms[0] = 0;
		else	strcpy(froms,"/");
		if( val = getv(argv,"vurl-path") ) strcat(froms,val);
		if( strtailchr(froms) != '*' )
			if( val = getv(argv,"vurl-tail") ) strcat(froms,val);

		if( tol == NULL || tol[0] == 0 ){
			sprintf(msg,"Missing right hand part.\n");
			goto error;
		}
		tos[0] = 0;
		if( val = getv(argv,"rurl-proto") ) strcat(tos,val);
		if( val = getv(argv,"rurl-login") ) strcat(tos,val);
		if( val = getv(argv,"rurl-tail") )  strcat(tos,val);

		/*
		if( file_size(fileno(mfp)) == 0 ){
			fprintf(mfp,"/-*\t=\t.delegate\n");
			fflush(mfp);
			fseek(mfp,0,0);
		}
		*/

		while( fgets(line,sizeof(line),mfp) != NULL ){
			wordScan(line,froma);
			if( strcmp(froms,froma) == 0 ){
				sprintf(msg,"Duplicate MOUNT for '%s'\n",froms);
				goto error;
			}
		}

		lock_exclusiveNB(fileno(mfp));
		fprintf(mfp,"%s\t%s\towner=%s\n",froms,tos,who);
		fflush(mfp);
		fseek(mfp,0,0);
		sort_file(mfp,mfp,1);
		lock_unlock(fileno(mfp));

		lastset = froms;
	}else
	if( streq(action,"unmount") ){
		tmp = TMPFILE("UNMOUNT");
		while( fgets(line,sizeof(line),mfp) != NULL ){
			int ai;
			char *from1;
			int match = 0;

			wordScan(line,froma);
			for( ai = 0; from1 = argv[ai]; ai++ ){
				if( strncmp(from1,"vurl-path=",10) == 0 )
					if( strcmp(from1+10,froma) == 0 ){
						match = 1;
						break;
					}
			}
			if( !match )
				fputs(line,tmp);
		}
		fflush(tmp);
		fseek(tmp,0,0);
		fseek(mfp,0,0);

		lock_exclusiveNB(fileno(mfp));
		copyfile1(tmp,mfp);
		lock_unlock(fileno(mfp));

		fclose(tmp);
		Ftruncate(mfp,0,1);
	}else
	if( streq(action,"jump") ){
		char myhp[256],url[1024];

		ClientIF_HP(Conn,myhp);
		sprintf(url,"http://%s%s",myhp,fromp);
		return putMovedTo(Conn,tc,url);
	}
	fclose(mfp);

	lastset = 0;
/*
	leng = putMount(Conn,vno,tc,fromp);
*/
	leng = putMovedTo(Conn,tc,"/-/admin/mount");
	return leng;

error:
	if( mfp != NULL )
		fclose(mfp);
	fprintf(tc,"%s",msg);
	return 1;
}
dynamic_config(Conn)
	Connection *Conn;
{	FILE *fp;
	char line[1024];

	fp = MtabFile("anybody",0);
	if( fp == NULL )
		return;

	/* if( "/-*" is not mounted )
		scan_MOUNT(Conn,"/-* ="); */

	while( fgets(line,sizeof(line),fp) )
		scan_MOUNT(Conn,line);
	fclose(fp);
	init_mtab();
}


extern char *VA_getOriginatorIdent();
static identd_auth(Conn,ident,who,command)
	Connection *Conn;
	AuthInfo *ident;
	char *who,*command;
{
	if( who == 0 && (AuthStat & A_EVALED_IDENT) )
		return AuthStat;
	AuthStat = (AuthStat & ~A_IDENT) | A_EVALED_IDENT;

	if( VA_getOriginatorIdent(Conn,ident) == 0 )
		return AuthStat;

	AuthStat |= A_WITH_IDENTD;

	sprintf(who,"%s@%s",ident->i_user,ident->i_addr.a_name);
	if( CTX_auth_admin(Conn,command,"IDENT",who) )
		AuthStat |= A_OK_IDENTAUTHOR;
	return AuthStat;
}
static passwd_auth(Conn,ident,who,command)
	Connection *Conn;
	AuthInfo *ident;
	char *who,*command;
{	AuthInfo xident;

	if( who == 0 && (AuthStat & A_EVALED_PASS) )
		return AuthStat;
	AuthStat = (AuthStat & ~A_PASS) | A_EVALED_PASS;

	if( !HTTP_getAuthorization(Conn,0,&xident,1) )
		return AuthStat;

	AuthStat |= A_WITH_PASSAUTH;
	if( Authenticate(Conn,xident.i_addr.a_name,xident.i_user,xident.i_pass,
	 "/") < 0 ){
		AuthStat |= A_REJ_PASSAUTHEN;
		return AuthStat;
	}

	AuthStat |= A_OK_PASSAUTHEN;
	*ident = xident;

	sprintf(who,"%s@%s",ident->i_user,ident->i_addr.a_name);
	if( CTX_auth_admin(Conn,command,"FTP",who) )
		AuthStat |= A_OK_PASSAUTHOR;
	else	AuthStat |= A_REJ_PASSAUTHOR;
	return AuthStat;
}

DHTML_printAuth(Conn,fp,fmt,name,arg,value)
        Connection *Conn;
        FILE *fp;
        char *fmt,*name,*arg;
	void *value;
{	AuthInfo ident;

	if( streq(arg,"admin_enabled") ){
		return CTX_with_auth_admin(Conn);
	}else
	if( streq(arg,"fauth") ){
		if( HTTP_getAuthorization(Conn,0,&ident,0) )
			fputs(ident.i_user,fp);
	}else
	if( streq(arg,"with_pass") )  return AuthStat & A_WITH_PASSAUTH; else
	if( streq(arg,"withauth") )   return AuthStat & A_WITH_PASSAUTH; else
	if( streq(arg,"withident") )  return AuthStat & A_WITH_IDENTD; else
	if( streq(arg,"iauthorized") )return AuthStat & A_OK_IDENTAUTHOR; else
	if( streq(arg,"authorized_pass") )
		return AuthStat & A_OK_PASSAUTHOR; else
	if( streq(arg,"authorized") )
		 return AuthStat & (A_OK_IDENTAUTHOR|A_OK_PASSAUTHOR); else
	if( streq(arg,"bad_pass") )   return AuthStat & A_REJ_PASSAUTHEN; else
	if( streq(arg,"rej_pass") )   return AuthStat & A_REJ_PASSAUTHOR; else
	{
		/* unknown arg */
	} 
	return 0;
}

putBuiltinPage(Conn,vno,tc,what,upath,desc,func,arg)
	Connection *Conn;
	FILE *tc;
	char *what,*upath,*desc;
	int (*func)();
	char *arg;
{	FILE *tmp;
	int leng,cleng;

	tmp = TMPFILE(what);
	putBuiltinHTML(Conn,tmp,what,upath,NULL,func,NULL);
	fflush(tmp); cleng = ftell(tmp); fseek(tmp,0,0);
	leng = HTTP_putHeader(Conn,tc,vno,"text/html",cleng,-1);
	if( RespWithBody ) copyfile1(tmp,tc);
	fclose(tmp);
	return leng + cleng;
}
static putText(Conn,vno,tc,txt)
	Connection *Conn;
	FILE *tc,*txt;
{	int leng,cleng;

	fflush(txt); cleng = ftell(txt); fseek(txt,0,0);
	leng = HTTP_putHeader(Conn,tc,vno,"text/plain",cleng,-1);
	if( RespWithBody ) copyfile1(txt,tc);
	fclose(txt);
	fflush(tc);
	return leng + cleng;
}

DHTML_putControl(Conn,req,fc,tc,vno,command)
	Connection *Conn;
	char *req;
	FILE *fc,*tc;
	char *command;
{	int leng = 0;
	char url[1024];
	char from[1024];
	AuthInfo ident;
	char mssg[1024];
	char *dp;
	char who[256];
	FILE *tmp;
	int cleng;

	if( streq(command,"reauth") ){
		leng = putNotAuthorized(Conn,tc,req,ProxyAuth,NULL,
	"You are clearing authorization thus are never authorized.\r\n");
		return leng;
	}

	if( HTTP_getRequestField(Conn,"From",from,sizeof(from)) != 0 )
		sv1log("#### putControl -- From: %s\n",from);

	who[0] = 0;
	bzero(&ident,sizeof(AuthInfo));
	identd_auth(Conn,&ident,who,command);
	passwd_auth(Conn,&ident,who,command);

	if( *command == 0 ){
		return putBuiltinPage(Conn,vno,tc,"Admin",
			"admin/server.dhtml",NULL,DHTML_printConn,NULL);
	}

	if( !(AuthStat & (A_OK_IDENTAUTHOR | A_OK_PASSAUTHOR)) ){
		if( AuthStat & (A_WITH_IDENTD|A_OK_PASSAUTHEN) ){
			sprintf(mssg,"Authenticated as <I>&lt;%s@%s&gt;</I>.\r\n",
				ident.i_user,ident.i_addr.a_name);
			sprintf(mssg+strlen(mssg),
				"You are not authorized to do `%s'.<BR>\r\n",command);
		}else{
			sprintf(mssg,"Not-Authenticated.\r\n");
		}
		leng += putNotAuthorized(Conn,tc,req,ProxyAuth,NULL,mssg);
		return leng;
	}

	if( streq(command,"mount") ){
		leng = mountControl(Conn,vno,req,fc,tc,who);
		return leng;
	}
	if( strncmp(command,"mount?",6) == 0 ){
		leng = doMount(Conn,tc,command+6,who);
		return leng;
	}
	if( strncmp(command,"unmount?",8) == 0 ){
		unMount(Conn,command+8);
		leng = putMount(Conn,vno,tc,"");
		return leng;
	}

	if( streq(command,"authenticate") ){
		leng = putBuiltinPage(Conn,vno,tc,"Admin",
			"admin/youareauth.dhtml",NULL,DHTML_printConn,NULL);
		return leng;
	}else
	if( streq(command,"stop") ){
		tmp = TMPFILE("Admin.stop");
		stop_server(tmp);
		return putText(Conn,vno,tc,tmp);
	}else
	if( streq(command,"restart") ){
		tmp = TMPFILE("Admin.restart");
		restart_server(tmp);
		return putText(Conn,vno,tc,tmp);
	}else
	if( streq(command,"getlog") ){
		tmp = TMPFILE("Admin.getlog");
		get_serverinitlog(tmp);
		return putText(Conn,vno,tc,tmp);
	}else
	if( streq(command,"showconf") ){
		tmp = TMPFILE("Admin.showconf");
		DELEGATE_dumpEnv(tmp);
		return putText(Conn,vno,tc,tmp);
	}
/*
if( streq(command,"replace") ){
leng += HTTP_putHeader(Conn,tc,vno,"text/html",0,-1);
FPRINTF(tc,"<TITLE> Replaced </TITLE>\n");
FPRINTF(tc,"Authorization: %s\n",dauth);
return leng;
}
*/

	sprintf(mssg,"Not yet supported: %s\n",command);
	cleng = strlen(mssg);
	leng = HTTP_putHeader(Conn,tc,vno,"text/html",cleng,-1);
	if( RespWithBody ) fputs(mssg,tc);
	return leng;
}

DHTML_putDeleGatePage(Conn,req,tc,vno)
	Connection *Conn;
	char *req;
	FILE *tc;
{
	return putBuiltinPage(Conn,vno,tc,"DGinfo","welcome.dhtml",
		NULL,DHTML_printConn,NULL);
}

post_PUBLIC(Conn,public,port)
	Connection *Conn;
	char *public,*port;
{	char serv[256],myhp[256];
	char line[1024],date[128],now[128],cvenv[128];
	char stat[1024];
	int sv;
	FILE *ts,*fs;
	int ready;

	if( public == NULL || public[0] == 0 )
		public = PUBLIC_CENTER;

	scan_SERVER(Conn,public);
	sv = connect_to_serv(Conn,FromC,ToC,0);

	if( sv != -1 ){
	    if( strchr(port,':') )
		strcpy(myhp,port);
	    else{
		gethostName(sv,myhp,"%H");
		strcat(myhp,":");
		strcat(myhp,port);
	    }

	    ts = fdopen(sv,"w");
	    fs = fdopen(sv,"r");

	    if( streq(DFLT_PROTO,"http") ){
		ProcTitle(Conn,"PUBLIC=%s",public);
		fprintf(ts,"POST /-/ HTTP/1.0\r\n");
		HTTP_putDeleGateHeader(Conn,ts,NULL);
		fprintf(ts,"Public-DeleGate: %s\r\n",myhp);
		fprintf(ts,"User-Agent: DeleGate/%s\r\n",DELEGATE_ver());
		fprintf(ts,"Connection: keep-alive\r\n");
		fprintf(ts,"\r\n");
		fflush(ts);
		sv1log("post_PUBLIC: [%d] %s://%s/\n",sv,DFLT_PROTO,myhp);
		StrftimeLocal(date,sizeof(date),"%m/%d-%H:%M",START_TIME);

		if( fgets(line,sizeof(line),fs) == NULL )
			sv1log("[PUBLIC-DeleGate] retuned EOF\n");
		else	sv1log("[PUBLIC-DeleGate] %s",line);

		fs = fdopen(sv,"r");
		for(;;){
			/*
			strfLoadStat(stat,sizeof(stat),"RPM=%L (%l)",time(NULL));
			*/
			stat[0] = 0;
			sprintf(stat+strlen(stat),"Version=%s",DELEGATE_ver());
			sprintf(stat+strlen(stat),"; Uptime=%s",date);
			StrftimeLocal(now,sizeof(now),"%m/%d-%H:%M",time(0));
			sprintf(stat+strlen(stat),"; LastUp=%s",now);
			if( cur_codeconvCL(cvenv) )
				sprintf(stat+strlen(stat),"; Charcode=%s",cvenv);
			sv1log("%s\n",stat);
			fprintf(ts,"%s\r\n",stat);
			fflush(ts);
			ready = fPollIn(fs,10*60*1000);

			if( ready < 0 )
				break;
			if( ready == 0 )
				continue;
			if( fgets(line,sizeof(line),fs) == NULL )
				break;
		}
		return 0;
	    }
	}
	sv1log("post_PUBLIC[ERROR]: %s %d\n",DFLT_PROTO,sv);
	return 1;
}
keep_PUBLIC(Conn,clsock,arg)
	Connection *Conn;
	char *arg;
{	char public[1025],*dp;
	char host[1024];
	char stat[1024];
	char path[1024];
	FILE *fc,*tc;
	FILE *fp;
	char peer[1024],*addr;
	char vstat[64];

	fc = fdopen(clsock,"r");
	tc = fdopen(clsock,"w");
	fprintf(tc,"START.\n");
	fflush(tc);

	if( *arg == ' ' )
		arg++;
	strcpy(public,arg);
	if( dp = strpbrk(public,"\r\n") )
		*dp = 0;

	getpeerNAME(clsock,peer);
	addr = gethostaddr(peer);

	sv1log("[PUBLIC-DeleGate] %s << %s [%s]\n",public,peer,addr);
	sprintf(path,"%s/%s",PUBLIC_DIR,public);
	strsubst(path,"${TMPDIR}",DELEGATE_TMPDIR);
	strsubst(path,"${ACTDIR}",DELEGATE_ACTDIR);
	strsubstDirEnv(path,DELEGATE_DGROOT,DELEGATE_VARDIR);
	fp = dirfopen("PUBLIC",path,"w");

	if( fp != NULL ){
		while( fgets(stat,sizeof(stat),fc) != NULL ){
			sv1log("[PUBLIC-DeleGate] %s %s",public,stat);
			fseek(fp,0,0);
			fprintf(fp,"Host=%s/%s; ",peer,addr);
			fputs(stat,fp);
			fflush(fp);
			Ftruncate(fp,0,1);
			lineScan(stat,vstat);
			ProcTitle(Conn,"PUBLIC-%s (%s)",public,vstat);
		}
		sv1log("[PUBLIC-DeleGate] %s done.\n",public);
		unlink(path);
		Finish(0);
	}
	Finish(1);
}
list_PUBLIC(tc)
	FILE *tc;
{	FILE *tmp,*sp;
	char desc[1024];
	int rcc;
	char hostport[256],url[256];
	int leng = 0;
	char *dp;
	int lastmod,now;

	if( chdir(PUBLIC_DIR) != 0 )
		return 0;

	tmp = TMPFILE("list_PUBLIC");
	dir2ls(PUBLIC_DIR,NULL,NULL,"%N",tmp);
	fflush(tmp);
	fseek(tmp,0,0);
	now = time(0);

	while( fgets(hostport,sizeof(hostport),tmp) != NULL ){
		if( dp = strpbrk(hostport,"\r\n") )
			*dp = 0;
		if( hostport[0] == '.' )
			continue;

		sv1log("[%s]\n",hostport);
		if( sp = fopen(hostport,"r") ){
			lastmod = file_mtime(fileno(sp));
			rcc = fread(desc,1,sizeof(desc),sp);
			desc[rcc] = 0;
			fclose(sp);
			if( 10*60 < now - lastmod )
				continue;
		}else	continue;

		if( dp = strpbrk(hostport,"\r\n") )
			*dp = 0;

		sprintf(url,"http://%s/-/",hostport);
FPRINTF(tc,"<A HREF=\"%s\"><B>%s</B></A>\n{ %s }<BR>\n",url,url,desc);
	}

	fclose(tmp);
	return leng;
}

static HTTP_toMyself(Conn,me,req)
	Connection *Conn;
	char *me,*req;
{	char *url;
	HttpRequest reqx;
	char Host[256];
	char svhost[256],myhost[256];
	int svport,myport;

	decomp_http_request(req,&reqx);
	url = reqx.hq_url;

	getFieldValue2(req,"Host",Host,sizeof(Host));
	svport = scan_hostport("http",Host,svhost);
	myport = scan_hostport("http",me,myhost);

	if( strncmp(url,"/-/",3) == 0 ){
		if( Host[0] == 0
		 || hostcmp(svhost,myhost)==0 && svport == myport )
			return 1;
	}
	return 0;
}
daemonControl(Conn,fromC,tc,timeout)
	Connection *Conn;
	FILE *tc;
{	int rcc;
	char req[1024],me[1024],myurl[1024];
	int httpReq;

	if( streq(iSERVER_PROTO,"tunnel1") ){
		Conn->from_myself = 1;
		return 0;
	}

	if( iSERVER_PROTO[0] == 0
	 || streq(iSERVER_PROTO,"http")
	 || streq(iSERVER_PROTO,"https")
	 || streq(iSERVER_PROTO,"tcprelay")
	)
		return 0;

	httpReq = 0;
	if( 0 < PollIn(fromC,timeout) ){
		rcc = RecvPeek(fromC,req,sizeof(req)-1);
		if( 8 < rcc ){
			req[rcc] = 0;
			if( HTTP_isMethod(req) ){
				httpReq = 1;
			}
		}
	}
	if( httpReq == 0 )
		return 0;

	if( !source_permitted(Conn) ){
		sv1log("## daemonControl(%s): Forbidden\n",DFLT_PROTO);
		fprintf(tc,"HTTP/1.0 403 Forbidden\r\n");
		fprintf(tc,"Content-Type: text/plain\r\n");
		fprintf(tc,"\r\n");
		fprintf(tc,"*** No access right ***\r\n");
		return 1;
	}

	ClientIF_HP(Conn,me);
	if( !HTTP_toMyself(Conn,me,req) ){
		sv1log("## daemonControl(%s): non-control URL\n",DFLT_PROTO);
		fprintf(tc,"HTTP/1.0 500 Protocol Mismatch\r\n");
		fprintf(tc,"Content-Type: text/html\r\n");
		fprintf(tc,"\r\n");
		fprintf(tc,"<PRE>\r\n");
		fprintf(tc,"*** Protocol Mismatch ***\r\n");
		fprintf(tc,"You are accessing this DeleGate server <B>%s</B>\r\n",me);
		fprintf(tc,"from a client software of <B>HTTP</B> protocol.\r\n");
		fprintf(tc,"But this DeleGate is for clients of ");
		fprintf(tc,"<B>%s</B> protocol.\r\n",iSERVER_PROTO);
		fprintf(tc,"If you intend to contol this DeleGate server, ");
		fprintf(tc,"see <A HREF=http://%s/-/>here</A>.\r\n",me);
		fprintf(tc,"</PRE>\r\n");
		return 1;
	}

	sv1log("## daemonControl(%s)\n",DFLT_PROTO);
	sprintf(myurl,"http://%s",me);
	set_BASEURL(Conn,myurl);
	strcpy(DFLT_PROTO,"http");
	return 0;
}
