/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997-1999 Yutaka Sato
Copyright (c) 1997-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	rescache.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970430	created
//////////////////////////////////////////////////////////////////////#*/

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include "dns.h"

extern char *getTMPDIR();
char *RES_HC_DIR = "resolvy";
int   RES_HC_EXPIRE = 600; /* maximum validity */
int   RES_CACHE_DISABLE = 0;
int   RES_HC_EXPIRE_REFRESH = 15; /* minimum (forced) refresh interval */
static int cache_cantopen;

static FILE *hosts_cache(byname,nameaddr,mode,cpath)
	char *nameaddr,*mode,*cpath;
{	unsigned int hidx;
	char cdirs[1024],cdirg[1024],cdir1[1024];
	FILE *fp;
	char *tmpdir;
	char resid[64];
	char conf[2048];
	char idfile[1024];
	FILE *cfp;

	if( cache_cantopen && time(0) < cache_cantopen+RES_HC_EXPIRE )
		return NULL;
	cache_cantopen = 0;
	RES_confid(resid);

	if( (tmpdir = getTMPDIR()) == 0 )
		tmpdir = "/tmp";

	hidx = FQDN_hash(nameaddr);
	if( isFullpath(RES_HC_DIR) )
		strcpy(cdirs,RES_HC_DIR);
	else	sprintf(cdirs,"%s/%s",tmpdir,RES_HC_DIR);
	sprintf(cdirg,"%s/%s",cdirs,resid);
	sprintf(cdir1,"%s/%s",cdirg,byname?"byname":"byaddr");
	sprintf(cpath,"%s/%02x",cdir1,hidx%32);
	if( *mode == 'r' )
		debug(DBG_ANY,"lookup cache: %s\n",cpath);
	else	debug(DBG_ANY,"create cache: %s\n",cpath);

	fp = fopen(cpath,mode);

	if( fp == NULL && *mode != 'r' ){
		mkdirShared(tmpdir,0);
		mkdirShared(cdirs,0);
		if( mkdirShared(cdirg,0) == 0 ){
			RES_getconf(conf);
			sprintf(idfile,"%s/config",cdirg);
			cfp = fopen(idfile,"w");
			if( cfp == NULL ){
				debug(DBG_FORCE,"CACHE can't open: %s (%d)\n",
					idfile,errno);
				return NULL;
			}
			fprintf(cfp,"created by uid=%d pid=%d time=%d\n",
				getuid(),getpid(),time(0));
			fprintf(cfp,"configuration:\n");
			fputs(conf,cfp);
			fclose(cfp);
			chmodIfShared(idfile,0644);
		}
		mkdirShared(cdir1,0);

		if( (fp = fopen(cpath,mode)) == NULL ){
			cache_cantopen = time(0);
			debug(DBG_FORCE,"CACHE cannot create: %s\n",cpath);
		}
	}
	if( fp != NULL && *mode != 'r' )
		chmodIfShared(cpath,0666);

	return fp;
}

gethostbynameaddr_cache(dir,name,rv,rb,byname,cname,noexpire)
	char *dir,*name;
	char *rv[],*rb,*cname;
{
	if( RES_CACHE_DISABLE )
		return 0;
	return gethostbynameaddr_cacheX(dir,name,rv,rb,byname,cname,noexpire);
}

gethostbynameaddr_cacheX(dir,name,rv,rb,byname,cname,noexpire)
	char *dir,*name;
	char *rv[],*rb,*cname;
{	char cpath[1024];
	FILE *cache,*ncache;
	char line[1024],*lp;
	int ac;
	int ac1,ai,aj;
	char *arb;
	int now,ctime,lines,expired;
	int lastmatch,prevmatch;

	/* if( isFullpath(dir) ) maybe this is obsolete restriction which
	   is introduced when RES_HC_DIR could not be TMPDIR relative... */
	/* *dir == 0 when called from puthost_cache() ... */
	if( *dir != 0 )
	if( strcmp(RES_HC_DIR,dir) != 0 )
		RES_HC_DIR = strdup(dir);

	cache = hosts_cache(byname,name,"r",cpath);
	if( cache == NULL )
		return 0;

	now = time(0);
	expired = 0;
	ac = 0;
	arb = rb;
	lastmatch = 0;

	for( lines = 0; fgets(line,sizeof(line),cache) != NULL; lines++ ){
		ctime = atoi(line);
		if( !noexpire )
		if( RES_HC_EXPIRE < now - ctime ){
			expired++;
			continue;
		}
		for( lp = line; *lp; lp++ ){
			if( *lp == ' ' ){
				lp++;
				break;
			}
		}
	SCAN1:
		ac1 = RES_matchLine("cache",byname,name,lp,&rv[ac],rb,cname);
		rb = rv[ac += ac1];
		if( ac1 ){
			prevmatch = lastmatch;
			lastmatch = ctime;
			if( prevmatch && prevmatch < lastmatch ){
				/* ignore older caches */
				ac = 0;
				rb = arb;
				if( cname ) cname[0] = 0;
				goto SCAN1;
			}
		}
	}
	fclose(cache);

	if( !noexpire )
	if( ac == 0 )
	if( lines/2 < expired )
	if( cache = hosts_cache(byname,name,"r",cpath) ){
		char newpath[1024];

		sprintf(newpath,"%s-%d",cpath,getpid());
		if( ncache = fopen(newpath,"w") ){
			fseek(cache,0,0);
			while( fgets(line,sizeof(line),cache) != NULL ){
				ctime = atoi(line);
				if( now - ctime <= RES_HC_EXPIRE )
					break;
			}
			while( fgets(line,sizeof(line),cache) != NULL )
				fputs(line,ncache);
			fclose(ncache);
			fclose(cache);
			if( unlink(cpath) != 0 )
				debug(DBG_FORCE,"CACHE cant del.? %s\n",cpath);
			if( rename(newpath,cpath) == 0 ){
				debug(DBG_ANY,"CACHE truncated %s\n",cpath);
				chmodIfShared(cpath,0666);
			}
			if( unlink(newpath) == 0 )
				debug(DBG_FORCE,"CACHE salvaged %s\n",newpath);
		}
		else	fclose(cache);
	}
	return ac;
}

puthost_cache(nameaddr,rv,byname,cname)
	char *nameaddr,*rv[],*cname;
{	int ai;
	char *n1;
	unsigned char *a1;
	char cpath[1024];
	FILE *cache;
	int now;
	int expire;

	int cac;
	char *crv[64],crb[1024];

	expire = RES_HC_EXPIRE;
	if( RES_CACHE_DISABLE && RES_HC_EXPIRE_REFRESH < RES_HC_EXPIRE )
		RES_HC_EXPIRE = RES_HC_EXPIRE_REFRESH;
	cac = gethostbynameaddr_cacheX("",nameaddr,crv,crb,byname,cname,0);
	RES_HC_EXPIRE = expire;
	if( 0 < cac ){
		if( !RES_CACHE_DISABLE )
		debug(DBG_FORCE,"CACHE UPDATE COLLISION %s(%d)\n",nameaddr,cac);
		return;
	}

	cache = hosts_cache(byname,nameaddr,"a",cpath);
	if( cache == NULL )
		return;

	now = time(0);
	if( byname ){
	    if( rv[0] == NULL ){
		fprintf(cache,"%d ",now);
		a1 = (unsigned char *)UNKNOWN_HOSTADDR;
		fprintf(cache,"%d.%d.%d.%d\t",a1[0],a1[1],a1[2],a1[3]);
		fprintf(cache,"%s\n",nameaddr);
		fflush(cache);
	    }else
	    for( ai = 0; a1 = (unsigned char *)rv[ai]; ai++ ){
		fprintf(cache,"%d ",now);
		fprintf(cache,"%d.%d.%d.%d\t",a1[0],a1[1],a1[2],a1[3]);
		if( cname && cname[0] && strcmp(cname,nameaddr) != 0 )
			fprintf(cache,"%s ",cname);
		fprintf(cache,"%s\n",nameaddr);
		fflush(cache);
	    }
	}else{
	    if( rv[0] == NULL ){
		fprintf(cache,"%d ",now);
		fprintf(cache,"%s\t%s\n",nameaddr,UNKNOWN_HOSTNAME);
		fflush(cache);
	    }else{
		fprintf(cache,"%d ",now);
		fprintf(cache,"%s\t",nameaddr);
		for( ai = 0; n1 = rv[ai]; ai++ )
			fprintf(cache,"%s%s",0<ai?" ":"",n1);
		fprintf(cache,"\n");
		fflush(cache);
	    }
	}
	fflush(cache);
	fclose(cache);
}

rem_unknown(rv,unknown,leng)
	char *rv[],*unknown;
{	int ai,ac;
	char *n1;
	char last[512];

	ac = 0;
	last[0] = 0;
	for( ai = 0; n1 = rv[ai]; ai++ ){
		if( 0 < leng ){
			if( strncmp(n1,unknown,leng) == 0 )
				continue;
		}else{
			if( strcmp(n1,unknown) == 0 )
				continue;
		}
		rv[ac++] = n1;
	}
	rv[ac] = 0;
	return ac;
}
