/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1999 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ins.c (INET socket)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	991112	extracted from inets.c, nbio.c
//////////////////////////////////////////////////////////////////////#*/
#include <errno.h>
#include <stdio.h>
#include "vsocket.h"

typedef struct sockaddr_in SIN;
typedef struct sockaddr SA;

sock_isconnected(sock){
	int len;
	VSAddr sin;

	len = sizeof(sin);
	if( getpeername(sock,(SAP)&sin,&len) == 0 )
	if( len == sizeof(SIN) )
	{
		if( VSA_port(&sin) != 0 )
			return 1;
	}
	return 0;
}

VSA_addrisANY(sap)
	VSAddr *sap;
{	SIN *sip;

	sip = (SIN*)sap;
	return sip->sin_addr.s_addr == INADDR_ANY;
}
VSA_addr(sap)
	VSAddr *sap;
{	SIN *sip;

	sip = (SIN*)sap;
	return ntohl(sip->sin_addr.s_addr);
}
char *VSA_ntoa(sap)
	VSAddr *sap;
{	SIN *sip;
	char *addr;

	sip = (SIN*)sap;
	addr = inet_ntoa(sip->sin_addr);
	return addr;
}
char *VSA_htoa(hp)
	struct hostent *hp;
{	SIN sin;

	sin.sin_family = hp->h_addrtype;
	bcopy(hp->h_addr,&sin.sin_addr,hp->h_length);
	return VSA_ntoa(&sin);
}
char *VSA_ltoa(addr,len,type)
	unsigned char *addr;
{	SIN sin;

	sin.sin_family = type;
	bcopy(addr,&sin.sin_addr,len);
	return VSA_ntoa(&sin);
}
VSA_port(sap)
	VSAddr *sap;
{	SIN *sip;

	sip = (SIN*)sap;
	return ntohs(sip->sin_port);
}
char *VSA_xtoap(sa,buf,siz)
	SA *sa;
	char *buf;
{
	sprintf(buf,"%s:%d",VSA_ntoa(sa),VSA_port(sa));
	return buf;
}
VSA_strisaddr(addr)
	char *addr;
{
	if( inet_addr(addr) != -1 )
		return 1;
	return 0;
}
VSA_isaddr(sap)
	SA *sap;
{	SIN *sip;

	sip = (SIN*)sap;
	if( sip->sin_family == AF_INET )
		return sip->sin_addr.s_addr != -1;
	return 0;
}
VSA_stosa(sap,atype,socks)
	SA *sap;
	unsigned char *socks;
{	SIN *sip;

	sip = (SIN*)sap;
	bzero(sip,sizeof(SIN));
	sip->sin_family = atype;
	bcopy(socks,&sip->sin_addr,4);
	bcopy(socks+4,&sip->sin_port,2);
	return sizeof(SIN);
}
VSA_btosa(sap,atype,baddr,port)
	SA *sap;
	unsigned char *baddr;
{	SIN *sip;

	sip = (SIN*)sap;
	bzero(sip,sizeof(SIN));
	sip->sin_family = atype;
	bcopy(baddr,&sip->sin_addr,4);
	sip->sin_port = htons(port);
	return sizeof(SIN);
}
VSA_setport(sap,port)
	SA *sap;
{	SIN *sip;

	sip = (SIN*)sap;
	sip->sin_port = htons(port);
}
VSA_atosa(sa,port,addr)
	SA *sa;
	char *addr;
{	SIN *sip;

	sip = (SIN*)sa;
	bzero(sip,sizeof(SIN));
	sip->sin_family = AF_INET;
	if( addr == NULL ){
		syslog_ERROR("#### ERROR VSA_atosa(addr=NULL)\n");
		sip->sin_addr.s_addr = -1;
	}else	sip->sin_addr.s_addr = inet_addrV4(addr); 
	sip->sin_port = htons(port);
	return sizeof(SIN);
}
VSA_htosa(sap,port,hp,hi)
	SA *sap;
	struct hostent *hp;
{	SIN *sip;
	char *baddr;

	sip = (SIN*)sap;
	bzero(sip,sizeof(SIN));
	sip->sin_family = hp->h_addrtype;
	baddr = hp->h_addr_list[hi];
	bcopy(baddr,&sip->sin_addr,hp->h_length);
	sip->sin_port = htons(port);
	return sizeof(SIN);
}
VSA_size(sap)
	VSAddr *sap;
{	SIN *sip;

	return sizeof(SIN);
}
VSA_decomp(sap,baddr,btype,bport)
	SA *sap;
	char **baddr;
	int *btype;
	char **bport;
{	SIN *sip;

	sip = (SIN*)sap;
	if(btype) *btype = sip->sin_family;
	if(baddr) *baddr = (char*)&sip->sin_addr;
	if(bport) *bport = (char*)&sip->sin_port;
	return 4;
}
VSA_prftp(sap,mport)
	SA *sap;
	char *mport;
{	SIN *sip;
	unsigned char *sa,*sp; 

	sip = (SIN*)sap;
	sa = (unsigned char*)&sip->sin_addr.s_addr;
	sp = (unsigned char*)&sip->sin_port;
	sprintf(mport,"%d,%d,%d,%d,%d,%d",sa[0],sa[1],sa[2],sa[3],sp[0],sp[1]);
}
VSA_ftptosa(sap,port)
	void *sap;
	char *port;
{	SIN *sip;
	unsigned char *sa,*sp;
	int ia[4],ip[2];

	sip = (SIN*)sap;
	bzero(sip,sizeof(SIN));
	sip->sin_family = AF_INET;
	sscanf(port,"%d,%d,%d,%d,%d,%d",&ia[0],&ia[1],&ia[2],&ia[3],
		&ip[0],&ip[1]);
	sa = (unsigned char*)&sip->sin_addr;
	sp = (unsigned char*)&sip->sin_port;
	sa[0] = ia[0]; sa[1] = ia[1]; sa[2] = ia[2]; sa[3] = ia[3];
	sp[0] = ip[0]; sp[1] = ip[1];
}
VSA_dnstosa(sap,port,revaddr)
	void *sap;
	char *revaddr;
{	SIN *sip;
	int ip[4];
	char *bp;

	sip = (SIN*)sap;
	if( sscanf(revaddr,"%d.%d.%d.%d",&ip[0],&ip[1],&ip[2],&ip[3]) != 4 )
		return 0;
	bp = (char*)&sip->sin_addr;
	bp[0] = ip[3];
	bp[1] = ip[2];
	bp[2] = ip[1];
	bp[3] = ip[0];
	sip->sin_family = AF_INET;
	sip->sin_port = port;
	return sizeof(SIN);
}

inet_itoaV4(iaddr,saddr)
	char *saddr;
{	SIN sin;

	sin.sin_addr.s_addr = htonl(iaddr);
	strcpy(saddr,inet_ntoa(sin.sin_addr));
}
VSA_zero(sap)
	VSAddr *sap;
{
	bzero(sap,sizeof(SIN));
}
VSA_copy(dst,src)
	SIN *dst,*src;
{
	bcopy(src,dst,sizeof(SIN));
}
VSA_comp(sa1,sa2)
	SIN *sa1,*sa2;
{
	if( sa1->sin_family != sa2->sin_family )
		return 1;
	if( sa1->sin_port != sa2->sin_port )
		return 2;
	if( sa1->sin_addr.s_addr != sa2->sin_addr.s_addr )
		return 3;
	return 0;
}


inetNtoa(addr,saddr)
	char *saddr;
{	SIN sin;

	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = addr;
	strcpy(saddr,inet_ntoa(sin.sin_addr));
}

SocketPair(d,type,protocol,sv)
	int sv[2];
{	SIN ina;
	int asock,len;
	SAP sa;
	int salen;
	int rcode = 0;

	sv[0] = sv[1] = -1;
	if( d != AF_INET )
		return -1;

	asock = socket(d,type,protocol);
	if( asock < 0 )
		return -1;

	sa = (SAP)&ina;
	salen = sizeof(ina);
	ina.sin_family = AF_INET;
	ina.sin_addr.s_addr = INADDR_ANY;
	ina.sin_port = 0;

	rcode |= bind(asock,sa,salen);
	rcode |= listen(asock,2);

	len = salen;
	getsockname(asock,sa,&len);
	if( d == AF_INET )
		ina.sin_addr.s_addr = inet_addrV4("127.0.0.1");

	sv[1] = socket(d,type,protocol);
	rcode |= connect(sv[1],sa,salen);

	len = salen;
	sv[0] = accept(asock,sa,&len);
	close(asock);

	return rcode;
}
char *_inet_ntoaV4I(ia)
	INETADDRV4 ia;
{	struct in_addr in;

	in.s_addr = ia;
	return inet_ntoa(in);
}
INETADDRV4 _inet_addrV4(cp)
	char *cp;
{
	return inet_addr(cp);
}
isinetAddr(saddr)
	char *saddr;
{
	if( inet_addrV4(saddr) != -1 )
		return 4;
	return 0;
}
