/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	timer.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950518	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "vsignal.h"

typedef struct {
	char	*what;
	int	intvl;
	void	(*func)();
	void	(*osig)();
	int	time;
} Timer;
static Timer timeStack[16];
static int timeSp;

int DBG_TIMER = 0;
#define dprintf	(DBG_TIMER==0)?0:fprintf

static void sigALRM(a)
{	Timer *tp;

	if( 0 < timeSp ){
		tp = &timeStack[timeSp-1];
dprintf(stderr,"!!sigALRM: %s\n",tp->what);
		if( tp->func != NULL )
			(*tp->func)(a);
	}
}

dumpTimer()
{	int pid,sp;

	pid = getpid();
	for( sp = 0; sp < timeSp; sp++ )
		dprintf(stderr,"[%d][%d] %s\n",pid,sp,timeStack[sp].what);
}

pushTimer(what,func,intvl)
	char *what;
	void (*func)();
{	Timer *tp;
	int sp;
	int oa;

	if( !WithSIGALRM )
		return timeSp;

	sp = timeSp++;
	tp = &timeStack[sp];
	tp->what = what;
	tp->func = func;
	tp->intvl = intvl;
	tp->osig = Vsignal(SIGALRM,sigALRM);
	if( oa = alarm(intvl) )
		tp->time = time(0) + oa;
	else	tp->time = 0;
dprintf(stderr,"++pushTimer: %s[%d] (%d)(%d)\n",tp->what,timeSp,intvl,oa);
	return sp;
}
popTimer(sp)
{	Timer *tp;
	int oa;

	if( !WithSIGALRM )
		return;

	timeSp = sp;
	tp = &timeStack[sp];
	Vsignal(SIGALRM,tp->osig);
	if( oa = tp->time ){
dprintf(stderr,"--popTimer: %s[%d] --> %d\n",tp->what,timeSp,oa-time(0));
		alarm(oa - time(0));
	}else{
dprintf(stderr,"--popTimer: %s[%d] --> reset\n",tp->what,timeSp);
		alarm(0);
	}
}
setTimer(sp,intvl)
{	Timer *tp;

	tp = &timeStack[sp];
	if( sp+1 == timeSp ){
dprintf(stderr,"==setTimer: %s[%d] == current (%d)\n",tp->what,sp,intvl);
		alarm(intvl);
	}else{
dprintf(stderr,"==setTimer: %s[%d] (%d)\n",tp->what,sp,intvl);
		if( intvl != 0 )
			tp->time = time(0) + intvl;
		else	tp->time = 0;
	}
}

/*
Sleep(sec)
{	int timer;

	timer = pushTimer("sleep",NULL,sec);
	sigpause(0);
	popTimer(timer);
}
*/

static int func_start;
static jmp_buf func_env;
static onTimeout(sig)
{
	syslog_ERROR("## callFuncTimeout: SIGALRM after %ds\n",
		time(NULL)-func_start);
	longjmp(func_env,-1);
}
void *callFuncTimeout(sec,xcode,func,a1,a2,a3)
	void *(*func)();
	void *xcode;
	char *a1,*a2,*a3;
{	void *rcode;
	int timer;
	void *osig;

	func_start = time(NULL);
	timer = pushTimer("FuncTimeout",onTimeout,sec);
	if( setjmp(func_env) == 0 )
		rcode = (*func)(a1,a2,a3);
	else	rcode = xcode;
	popTimer(timer);
	return rcode;
}

msleep(msec){
	int sec,usec;

	if( msec < 1000 ){
		Usleep(msec*1024);
		return;
	}

	if( sec = msec / 1000 )
		sleep(sec);

	if( usec = (msec % 1000)*1000 )
		Usleep(usec);
}
