/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1998-1999 Yutaka Sato
Copyright (c) 1998-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	socks5.c (SocksV5 server and client)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
	Authentication is not supported yet.
History:
	980211	created
//////////////////////////////////////////////////////////////////////#*/
#include <errno.h>
#include <stdio.h>
#include "ystring.h"
#include "vsocket.h"

static recv_mssg(sock,buf,siz)
	unsigned char *buf;
{	int rcc,rcc1,alen;

	rcc = recv(sock,buf,10,0);
	if( rcc < 10 ) return rcc;
	if( buf[0] != 5 ) return rcc; /* VER */
	alen = 0;
	switch( buf[3] ){ /* ATYP */
		case 3: alen = 1+buf[4] - 4; break;
		case 4: alen = 16 - 4; break;
	}
	if( alen )
		rcc1 = recv(sock,&buf[rcc],alen,0);
	else	rcc1 = 0;
	return rcc + rcc1;
}

static char *socks_host = NULL;
static int   socks_port = 1080;

typedef struct {
	int	s_ssock;	/* socket connected by TCP to sockd */
	VSAddr	s_rme;		/* remote UDP port on the sockd */
	int	s_msock;	/* local UDP socket for reception */
	VSAddr	s_me;		/* local UDP port */
} SocksServ;
static SocksServ socksServ[32];
static int socksServN;

static int fixed_udp_address = 0;

#define ltob(l,b) {(b)[0]=l>>24;(b)[1]=l>>16;(b)[2]=l>>8;(b)[3]=l;}
#define stob(s,b) {(b)[0]=s>>8; (b)[1]=s;}

#define btol(b)   (((b)[0]<<24)|((b)[1]<<16)|((b)[2]<<8)|(b)[3])
#define btos(b)   (((b)[0]<<8) | (b)[1])

SOCKS_udpclose(msock)
{	int si,sj;

	for( si = 0; si < socksServN; si++ )
	if( socksServ[si].s_msock == msock ){
		for( sj = si; sj < socksServN; sj++ )
			socksServ[sj] = socksServ[sj+1];
		socksServN--;
		break;
	}
}

/*
 * declare the socket is a local UDP socket to be used for
 * UDP communication throught the socks server
 */
SOCKS_udpassoc(msock,me,rme)
	VSAddr *me,*rme;
{	int sock;
	unsigned char req[128],resp[128];
	unsigned char *baddr,*bport;
	int bleng,btype;
	int rcc,ri;
	int rcode;
	VSAddr sab;
	int salen;
	int si;
	SocksServ *ssp;
	int qc;

	if( socks_host == NULL ){
		syslog_ERROR("SocksV5_udpassoc: NO socks.\n");
		return -1;
	}
	for( si = 0; si < socksServN; si++ ){
		if( VSA_comp(&socksServ[si].s_me,me) == 0 ){
			syslog_DEBUG("SocksV5_udpassoc[%d]: already done\n",si);
			ssp = &socksServ[si];
			goto EXIT;
		}
	}

	ssp = &socksServ[socksServN];
	ssp->s_msock = msock;
	ssp->s_me = *me;

	sock = socket(AF_INET,SOCK_STREAM,0);
	setCloseOnExec(sock);

	ssp->s_ssock = sock;
	salen = VSA_atosa(&sab,socks_port,socks_host);
	syslog_DEBUG("SocksV5_connect [%x]%s:%d ...\n",
		VSA_addr(&sab),socks_host,socks_port);
	rcode = connect(sock,(SAP)&sab,salen);

	req[0] = 5; /* VERSION */
	req[1] = 1; /* leng */
	req[2] = 0; /* NO AUTH */
	send(sock,req,3,0);
	rcc = recv(sock,resp,2,0);
	if( rcc < 2 || resp[1] != 0 ){
		syslog_ERROR("SocksV5_udpassoc: AUTH error (V%d %d)\n",
			resp[0],resp[1]);
		close(sock);
		return -1;
	}

	if( fixed_udp_address && VSA_addr(me) == 0 ){
		VSAddr xme;
		int port;
		int addrlen = sizeof(VSAddr);
		getsockname(sock,(SAP)&xme,&addrlen);
		port = VSA_port(me);
		*me = xme;
		VSA_setport(me,port);
	}

	bleng = VSA_decomp(me,&baddr,&btype,&bport);
	qc = 0;
	req[qc++] = 5; /* VERSION */
	req[qc++] = 3; /* CMD = UDP ASSOCIATE */
	req[qc++] = 0; /* reserved */
	req[qc++] = 1; /* ATYP = IP V4 address type */
	bcopy(baddr,&req[qc],bleng); /* DST.ADDR */
	qc += bleng;
	bcopy(bport,&req[qc],2); /* DST.PORT */
	qc += 2;
	send(sock,req,qc,0);

	rcc = recv_mssg(sock,resp,sizeof(resp));
	if( rcc < 10 || resp[1] != 0 ){
		syslog_ERROR("SocksV5_udpassoc: UDP ASSOC error(V%d %d)\n",
			resp[0],resp[1]);
		close(sock);
		return -1;
	}

	VSA_stosa(&ssp->s_rme,AF_INET,&resp[4]);
	syslog_ERROR("SocksV5_udpassoc[%d]: OK (%x:%d/%x:%d)\n",
		socksServN,
		VSA_addr(&ssp->s_rme),VSA_port(&ssp->s_rme),
		VSA_addr(me),VSA_port(me));
	socksServN++;

EXIT:
	if( rme ){
		*rme = ssp->s_rme;
	}
	return 0;
}

SOCKS_Sendto(sock,msg,len,flags,to,tolen)
	char *msg;
	VSAddr *to;
{	char buf[8*1024];
	int wcc;
	unsigned char *baddr,*bport;
	int bleng,btype;
	VSAddr me,rme;
	int salen;
	int si;
	int qc;

	for( si = 0; si < socksServN; si++ )
		if( socksServ[si].s_msock == sock ){
			rme = socksServ[si].s_rme;
			break;
		}
	if( socksServN <= si ){
		int len = sizeof(me);
		getsockname(sock,(SAP)&me,&len);
		if( SOCKS_udpassoc(sock,&me,&rme) < 0 )
			return -1;
	}

	bleng = VSA_decomp(to,&baddr,&btype,&bport);

	qc = 0;
	buf[qc++] = 0; /* reserved */
	buf[qc++] = 0; /* reserved */
	buf[qc++] = 0; /* FRAGment number */
	buf[qc++] = 1; /* ATYP = IP V4 address type */
	bcopy(baddr,&buf[qc],bleng); /* DST.ADDR */
	qc += bleng;
	bcopy(bport,&buf[qc],2); /* DST.PORT */
	qc += 2;
	bcopy(msg,&buf[qc],len);

	salen = VSA_size(&rme);
	wcc = sendto(sock,buf,qc+len,flags,(SAP)&rme,salen);

	syslog_DEBUG("SocksV5_sendto[%d](%x:%d/%x:%d) = %d\n",si,
		VSA_addr(to),VSA_port(to), VSA_addr(&rme),VSA_port(&rme),wcc);

	return wcc - qc;
}
SOCKS_Recvfrom(sock,msg,len,flags,from,fromlen)
	unsigned char *msg;
	VSAddr *from;
	int *fromlen;
{	int rcc;
	VSAddr sab;
	int addrlen;

	addrlen = sizeof(VSAddr);
	rcc = recvfrom(sock,msg,len,flags,(SAP)&sab,&addrlen);
	if( rcc <= 0 )
		return rcc;
	if( msg[0] != 0 || msg[1] != 0 )
		return rcc;

	*fromlen = VSA_stosa(from,AF_INET,&msg[4]);
	syslog_DEBUG("SocksV5_recvfrom(%x:%d/%x:%d) = %d\n",
		VSA_addr(from),VSA_port(from),
		VSA_addr(&sab),VSA_port(&sab),rcc);

	bcopy(10+msg,msg,rcc-10);
	return rcc - 10;
}


static VSAddr to_socksV[8];
static int to_socksN;

SOCKS_addserv(dhost,dport,shost,sport)
	char *dhost;
	char *shost;
{	VSAddr *to;

	socks_host = strdup(shost);
	socks_port = sport;
	if( strcmp(dhost,"*") == 0 )
		dhost = "255.255.255.255"; /* use it for wild card */
	else{
		if( !VSA_strisaddr(dhost) ){
			syslog_ERROR("SocksV5_addrserv(%s) host ERROR\n",dhost);
			return; 
		}
	}
	to = &to_socksV[to_socksN];
	VSA_atosa(to,dport,dhost);
	syslog_DEBUG("SocksV5_addrserv[%d](%x/%s:%d,%s:%d)\n",
		to_socksN,VSA_addr(to),dhost,dport,shost,sport);
	to_socksN++;
}
SOCKS_via_socks(dist)
	VSAddr *dist;
{	int ni;
	VSAddr *can1;

	for( ni = 0; ni < to_socksN; ni++ ){
		can1 = &to_socksV[ni];
		if( VSA_addr(can1) == -1 )
			return 1; /* "host=*" (255.255.255.255) */
		if( VSA_comp(can1,dist) == 0 )
			return 1;
	}
	return 0;
}
SOCKS_sendto(sock,buf,len,flags,to,tolen)
	char *buf;
	SAP to;
{
	if( socks_host && SOCKS_via_socks(to) )
		return SOCKS_Sendto(sock,buf,len,flags,to,tolen);
	else	return       sendto(sock,buf,len,flags,to,tolen);
}
SOCKS_recvfrom(sock,buf,len,flags,from,fromlen)
	char *buf;
	SAP from;
	int *fromlen;
{
	if( socks_host )
		return SOCKS_Recvfrom(sock,buf,len,flags,from,fromlen);
	else	return       recvfrom(sock,buf,len,flags,from,fromlen);
}


SOCKS_startV5(sock,command,host,port,user,rhost,rport)
	char *host,*user,*rhost;
	int *rport;
{	unsigned char qbuf[256],rbuf[256];
	int qcc,rcc,wcc;
	int ulen,plen;
	int nlen;
	char *pass;
	char *hp;
	VSAddr sab;
	unsigned char *baddr;
	int bleng,btype;

pass = NULL;
errno = 0;

	qbuf[0] = 5;
	qbuf[1] = 1;
	if( pass != NULL )
		qbuf[2] = 2; /* USERNAME/PASSWORD */
	else	qbuf[2] = 0; /* NO AUTH */

	wcc = send(sock,qbuf,3,0);
	rcc = recv(sock,rbuf,2,0);

	if( 1 < rcc && rbuf[1] == 4 )
		return 4;

	if( rcc < 2 || rbuf[1] != 0 ){
		syslog_ERROR("SocksV5_start: AUTH error (V%d %d)\n",
			rbuf[0],rbuf[1]);
		return -1;
	}

	if( pass != NULL ){
		ulen = strlen(user);
		plen = strlen(pass);
		qcc = 0;
		qbuf[qcc++] = 1;
		qbuf[qcc++] = ulen; strcpy(qbuf+qcc,user); qcc += ulen;
		qbuf[qcc++] = plen; strcpy(qbuf+qcc,pass); qcc += plen;
		send(sock,qbuf,qcc,0);
		rcc = recv(sock,rbuf,2,0);
		syslog_ERROR("SocksV5_start: %d VER[%d] STATUS[%d]\n",
			rcc,rbuf[0],rbuf[1]);
	}

	qcc = 0;
	qbuf[qcc++] = 5; /* VERSION */
	qbuf[qcc++] = command; /* CMD = CONNECT:1,BIND:2 */
	qbuf[qcc++] = 0; /* reserved */
	if( VSA_strisaddr(host) ){
		VSA_atosa(&sab,0,host);
		bleng = VSA_decomp(&sab,&baddr,&btype,NULL);
		qbuf[qcc++] = 1; /* ATYP = IP V4 address type */
		bcopy(baddr,&qbuf[qcc],bleng); /* DST.ADDR */
		qcc += bleng;
	}else{
		qbuf[qcc++] = 3; /* ATYP = host name */
		nlen = strlen(host);
		qbuf[qcc++] = nlen;
		strcpy(&qbuf[qcc],host);
		qcc += nlen;
	}
	stob(port,&qbuf[qcc]); qcc += 2; /* DST.PORT */
	wcc = send(sock,qbuf,qcc,0);
	return SOCKS_recvResponseV5(sock,command,rhost,rport);
}

SOCKS_recvResponseV5(sock,command,rhost,rport)
	char *rhost;
	int *rport;
{	int rcc;
	int addr,port;
	unsigned char rbuf[256];
	int ratyp;

	rbuf[0] = rbuf[1] = 0;
	rcc = recv_mssg(sock,rbuf,sizeof(rbuf));
	if( rcc < 10 || rbuf[1] != 0 ){
		syslog_ERROR("SocksV5_resp: cmd=%d error=%x rcc=%d\n",
			command,rbuf[1],rcc);
		return -1;
	}

	ratyp = rbuf[3];
	if( ratyp == 1 ){
		addr = btol(&rbuf[4]);
		port = btos(&rbuf[8]);
		if( rhost ) sprintf(rhost,"%d.%d.%d.%d",
				rbuf[4],rbuf[5],rbuf[6],rbuf[7]);
		if( rport ) *rport = port;
	}else{
		addr = -1;
		port = 0;
		if( rhost ) sprintf(rhost,"255.255.255.255");
		if( rport ) *rport = port;
	}

	syslog_ERROR("[SocksV5-clnt] start: OK CMD=%d ATYP=%d %x:%d\n",
		command,ratyp,addr,port);
	return 0;
}

#define Q_VER		qbuf[0]
#define Q_NMETHODS	qbuf[1]
#define Q_METHODS	&qbuf[2]
#define Q_CMD		qbuf[1]
#define Q_RSV		qbuf[2]
#define Q_ATYP		qbuf[3]
#define Q_HOST		&qbuf[4]

#define S_CNTL	0
#define S_CLNT	1
#define S_SERV	2

static udp_relay_socks(ctx,cntlsock,clsock,clname)
	void *ctx;
	char *clname;
{	char clhost[512];
	int clport;
	unsigned char rbuf[8*1024],*data;
	int svsock;
	int rcc,wcc;
	char local[512];
	int sockV[3],sockR[3],sentN[3],xi;
	VSAddr clnt,from,to;
	unsigned char *baddr,*bport;
	int btype,bleng,clntleng;
	int len,fromlen,tolen;
	int nready;
	char froms[128];
	int qc;

	clhost[0] = 0;
	clport = 0;
	sscanf(clname,"%[^:]:%d",clhost,&clport);
	VSA_atosa(&clnt,clport,clhost);

	strcpy(local,"*:*");
	svsock = VSocket(ctx,"BIND/SocksV5",-1,local,"*:*","protocol=udp");
	sockV[S_CNTL] = cntlsock;
	sockV[S_CLNT] = clsock;
	sockV[S_SERV] = svsock;

	for( xi = 0; xi < 3; xi++ )
		sentN[xi] = 0;

	data = &rbuf[10];
	len = sizeof(rbuf) - 10;

	for(;;){
	    nready = PollIns(0,3,sockV,sockR);
	    if( nready <= 0 ){
		syslog_ERROR("UDP/SocksV5 POLL ERROR (%d)\n",errno);
		break;
	    }
	    if( 0 < sockR[S_CNTL] ){
		syslog_ERROR("UDP/SocksV5 GOT CONTROL\n");
		break;
	    }
	    if( 0 < sockR[S_CLNT] ){
		fromlen = sizeof(VSAddr);
		rcc = recvfrom(clsock,rbuf,sizeof(rbuf),0,(SAP)&from,&fromlen);
	sprintf(froms,"%x:%d",VSA_addr(&from),VSA_port(&from));

		if( VSA_addr(&clnt) == 0 ){
			if( clport = VSA_port(&clnt) )
			if( VSA_port(&from) != clport )
			    syslog_ERROR("## BAD PORT ? %d != %d\n",
				VSA_port(&from),clport);
			clnt = from;
			syslog_ERROR("UDP/SocksV5 C-S client set %s\n",froms);
		}else
		if( VSA_comp(&clnt,&from) != 0 ){
			syslog_ERROR("## BAD CLIENT: %s %s\n",froms,clname);
			continue;
		}
		tolen = VSA_stosa(&to,AF_INET,&rbuf[4]);
		syslog_ERROR("UDP/SocksV5 C-S %d ATYP[%d] %x:%d\n",
			rcc,rbuf[3],VSA_addr(&to),VSA_port(&to));
		wcc = sendto(svsock,data,rcc-10,0,(SAP)&to,tolen);
		sentN[S_CLNT] += wcc;
	    }
	    if( 0 < sockR[S_SERV] ){
		fromlen = sizeof(VSAddr);
		rcc = recvfrom(svsock,data,len,0,(SAP)&from,&fromlen);
		bleng = VSA_decomp(&from,&baddr,&btype,&bport);
		syslog_ERROR("UDP/SocksV5 S-C %d %x:%d\n",rcc,
			VSA_addr(&from),VSA_port(&from));
		qc = 0;
		rbuf[qc++] = 0;
		rbuf[qc++] = 0;
		rbuf[qc++] = 0; /* FRAGment not suppported */
		rbuf[qc++] = 1; /* IPv4 */
		bcopy(baddr,&rbuf[qc],bleng);
		qc += bleng;
		bcopy(bport,&rbuf[qc],2);
		qc += 2;
		clntleng = VSA_size(&clnt);
		wcc = sendto(clsock,rbuf,qc+rcc,0,(SAP)&clnt,clntleng);
		sentN[S_SERV] += rcc;
	    }
	}
	syslog_ERROR("UDP/SocksV5 C-S:%d S-C:%d\n",
		sentN[S_CLNT],sentN[S_SERV]);
}

static send_resp(tc,rep,bound)
	FILE *tc;
	unsigned char *bound;
{	unsigned char rbuf[256];
	char bhost[256],*bp;
	unsigned char *baddr;
	int btype,bleng;
	int port;
	int rcc,hlen;
	VSAddr sab;

	rbuf[0] = 5;
	rbuf[1] = rep;
	rbuf[2] = 0; /* RSV */
	rcc = 3;

	strcpy(bhost,bound);
	if( bp = strrchr(bhost,':') ){
		*bp++ = 0;
		port = atoi(bp);
	}else	port = -1;
	if( VSA_strisaddr(bhost) ){
		VSA_atosa(&sab,port,bhost);
		bleng = VSA_decomp(&sab,&baddr,&btype,NULL);
		rbuf[rcc++] = 1; /* IPv4 */
		bcopy(baddr,&rbuf[rcc],bleng);
		rcc += bleng;
	}else{
		rbuf[rcc++] = 3; /* DOMAINNAME */
		rbuf[rcc++] = hlen = strlen(bhost);
		bcopy(bhost,&rbuf[rcc],hlen);
	}
	stob(port,&rbuf[rcc]);
	rcc += 2;
	fwrite(rbuf,1,rcc,tc);
	fflush(tc);
}
SOCKS_serverV5(ctx,fromcl,tocl,timeout_ms)
	void *ctx;
{	FILE *fc,*tc;
	unsigned char qbuf[512],rbuf[512],*qh,host[512],bhost[512];
	int aleng,port,rep;
	int svsock,bsock;
	char remote[512],local[512],*bound;

	fc = fdopen(fromcl,"r");
	tc = fdopen(tocl,"w");
	Q_VER = getc(fc);
	Q_NMETHODS = getc(fc);
	qbuf[2] = qbuf[3] = 0;
	fread(Q_METHODS,1,Q_NMETHODS,fc);
	syslog_ERROR("[SocksV5-serv] VER[%x] NMETHODS[%d] [%x][%x]\n",
		Q_VER,Q_NMETHODS,qbuf[2],qbuf[3]);

	rbuf[0] = 5;
	rbuf[1] = 0; /* NO AUTHENTICATION REQUIRED */
	fwrite(rbuf,1,2,tc);
	fflush(tc);

	rep = 0;
	svsock = -1;
	bound = "";
	Q_VER = getc(fc);
	Q_CMD = getc(fc);
	Q_RSV = getc(fc);
	Q_ATYP = getc(fc);
	switch( Q_ATYP ){
		case 1: aleng = 4; break; /* IPv4 */
		case 3: aleng = getc(fc); break; /* DOMAIN NAME */
		case 4: aleng = 16; break; /* IPv6 */ break;
	}
	fread(Q_HOST,1,aleng,fc);
	qh = Q_HOST;
	switch( Q_ATYP ){
		case 1: sprintf(host,"%d.%d.%d.%d",qh[0],qh[1],qh[2],qh[3]);
			break;
		case 3: Strncpy(host,qh,aleng+1); break;
		case 4: host[0] = 0; rep = 0x08; break;
	}
	port = (getc(fc) << 8) | getc(fc);
	syslog_ERROR("[SocksV5-serv] VER[%x] CMD[%x] ATYP[%x] %s:%d\n",
		Q_VER,Q_CMD,Q_ATYP,host,port);

	strcpy(local,"*:*");
	sprintf(remote,"%s:%d",host,port);

	switch( Q_CMD ){
	    case 1: /* CONNECT */

/* MUST CHECK access right to remote */

		svsock = VSocket(ctx,"CNCT/SocksV5",-1,local,remote,"");
		if( svsock < 0 ){ rep = 0x01; goto ERREXIT; }
		send_resp(tc,rep,bound=local);
		tcp_relay2(timeout_ms,fromcl,svsock,svsock,tocl);
		close(svsock);
		break;

	    case 2: /* BIND */
		if( GetViaSocks(ctx,host,port) ){
			syslog_ERROR("#### MUST DO bindViaSocks... %s:%d\n",
				host,port);
		}
		bsock = VSocket(ctx,"BIND/SocksV5",-1,local,remote,"listen=1");
		if( bsock < 0 ){ rep = 0x01; goto ERREXIT; }
		send_resp(tc,rep,bound=local);

/* MUST POLL {fromcl,bsock} */

		svsock = VSocket(ctx,"ACPT/SocksV5",bsock,local,remote,"");
		close(bsock);
		if( svsock < 0 ){ rep = 0x01; goto ERREXIT; }

		send_resp(tc,rep,bound=remote);
		tcp_relay2(timeout_ms,fromcl,svsock,svsock,tocl);
		close(svsock);
		break;

	    case 3: /* UDP ASSOCIATE */
		bsock = VSocket(ctx,"BIND/SocksV5",-1,local,remote,"protocol=udp");
		if( bsock < 0 ){ rep = 0x01; goto ERREXIT; }
		send_resp(tc,rep,bound=local);
		udp_relay_socks(ctx,fromcl,bsock,remote);
		close(bsock);
		break;

	    default:
		syslog_ERROR("## Command not supported: %x\n",Q_CMD);
		rep = 0x07;
		goto ERREXIT;
	}
	return 0;

ERREXIT:
	send_resp(tc,rep,bound);
	return -1;
}
