/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:   program/C; charset=US-ASCII
Program:        hostaddr.c
Author:         Yutaka Sato <ysato@etl.go.jp>
Description:
History:
        970728	extracted from inets.c and windows.c
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "vsocket.h"

unsigned short ntohS(si) unsigned short si; {	return ntohs(si); }
unsigned short htonS(si) unsigned short si; {	return htons(si); }
INETADDRV4 ntohL(li) INETADDRV4 li; {	return ntohl(li); }
INETADDRV4 htonL(li) INETADDRV4 li; {	return htonl(li); }

/*########################################
 *	INHERENT RESOLVER UTILIZATION
 */

#ifdef gethostbyname
#undef gethostbyname
#endif
struct hostent *RES_gethostbyname();
struct hostent *
EX_GETHOSTBYNAME(name)
	char *name;
{	struct hostent *ht;

	/*porting_dbg("gethostbyname(%s) ...",name);*/
	ht = gethostbyname(name);
	/*porting_dbg("gethostbyname(%s) = %x",name,ht);*/
	return ht;
}
struct hostent *
_GETHOSTBYNAME(name)
	char *name;
{	struct hostent *ht;

	return RES_gethostbyname(name);
}

#ifdef gethostbyaddr
#undef gethostbyaddr
#endif
struct hostent *RES_gethostbyaddr();
struct hostent *
EX_GETHOSTBYADDR(addr,len,type)
	char *addr;
{	struct hostent *ht;
	char *aaddr;

	aaddr = inet_ntoa(*(struct in_addr*)addr);
	/*porting_dbg("gethostbyaddr(%s) ...",aaddr);*/
	ht = gethostbyaddr(addr,len,type);
	/*porting_dbg("gethostbyaddr(%s) = %x",aaddr,ht);*/
	return ht;
}
struct hostent *
_GETHOSTBYADDR(addr,len,type)
	char *addr;
{
	return RES_gethostbyaddr(addr,len,type);
}
