/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	forkspawn.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	990205	extracted from misc.c
//////////////////////////////////////////////////////////////////////#*/
#include <errno.h>
#include <stdio.h>
#include "vsignal.h"
#include "log.h"

extern char *sigsym();
int doTracePid;
int (*doTraceLog)();
#define TraceLog	doTraceLog==0? 0 : (*doTraceLog)

int MyPID;
Getpid(){
	if( MyPID == 0 )
		MyPID = getpid();
	return MyPID;
}
Fork(what)
	char *what;
{	register int pid;

	endhostent();
	MyPID = 0;
	pid = fork();
	if( pid == 0 ){
		MyPID = getpid();
		syslog_ERROR("-- Fork(%s): %d -> %d\n",what,getppid(),MyPID);
	}
	else{
		if( lTRVERB() )
		if( doTracePid == getpid() )
			TraceLog("+ Fork(%s) = %d\n",what,pid);
	}
	return pid;
}
extern int SPAWN_P_NOWAIT;
Spawnvp(what,path,av)
	char *what,*path,*av[];
{	int pid;

	MyPID = 0;
	pid = spawnvp(SPAWN_P_NOWAIT,path,av);
	return pid;
}

Exit(code,fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char msg[2048];

	if( code != 0 ){
		sprintf(msg,"Exit (%d) ",code);
		sprintf(msg+strlen(msg),fmt,a,b,c,d,e,f,g);
		syslog_ERROR("%s",msg);
	}
	Finish(code);
}

static usualsig(sig)
{
	if( sig == SIGALRM ) return 1;
	if( sig == SIGPIPE ) return 1;
	if( sig == SIGTERM ) return 1;
	return 0;
}
WaitX(mode)
{	int status[4];
	int pid,xpid,sig,xcode,st;

	for(;;){
		pid = wait3(status,mode,NULL);
		if( !lTRACE() )
			break;
		if( pid <= 0 )
			break;
		st = status[0];

		if( 0 <= (xcode = getWaitExitCode(status)) ){
			xpid = waitpid(pid,status,0);
			if( lTRVERB() )
			TraceLog("- Wait [%04X] pid=%d EXITED(%d) %d\n",
				st,pid,xcode,xpid);
			return pid;
		}
		if( 0 < (sig = getWaitExitSig(status)) ){
			xpid = waitpid(pid,status,0);
			TraceLog("- Wait [%04X] pid=%d SIGNALED(%d=%s)%s %d\n",
				st,pid,sig,sigsym(sig),
				getWaitExitCore(status)?" COREDUMP":"",xpid);
			return pid;
		}
		if( 0 < (sig = getWaitStopSig(status)) ){
			if( lTRVERB() || !usualsig(sig) )
			TraceLog("- Wait [%04X] pid=%d STOPSIG(%d=%s)\n",
				st,pid,sig,sigsym(sig));
			if( sig == SIGTRAP ){
				if( lNOEXEC() )
					ptraceKill(pid);
				else	ptraceContinue(pid,0);
			}else	ptraceContinue(pid,sig);
			continue;
		}
		TraceLog("- Wait [%04X] pid=%d wait unknown\n",st,pid);
	}
	return pid;
}
extern int WAIT_WNOHANG;
NoHangWait()
{
	return WaitX(WAIT_WNOHANG);
}

extern char *getusernames();
Execvp(where,path,av)
	char *where,*path,*av[];
{	int rcode;
	char pwd[1024];
	char names[1024];
	char *nav[2];

	BeforeExec();
	endhostent();
	if( av[0] == NULL ){
		nav[0] = nav[1] = NULL;
		av = nav;
	}
	rcode = execvp(path,av);

	fprintf(stderr,"%s: Could not execute COMMAND: %s\n",where,path);
	fprintf(stderr," with the OWNER uid/gid: %s\n",getusernames(names));
	fprintf(stderr," at the DIR: %s\n",getcwd(pwd,sizeof(pwd)));
	fprintf(stderr,"You should check that you can execute the COMMAND\n");
	fprintf(stderr," at the DIR with the access right of the OWNER.\n");
	perror("proc_title_init");
	Exit(-1,"%s(%s) failed(%d) errno=%d\n",where,path,rcode,errno);
}
Kill(pid,sig)
{
	syslog_ERROR("Kill(%d,%d)\n",pid,sig);
	if( pid == 0 || pid == 1 || pid == -1 ){
		syslog_ERROR("Error: tried to Kill %d X-<\n",pid);
		return -1;
	}
	return kill(pid,sig);
}
Killpg(pgrp,sig)
{
	syslog_ERROR("Killpg(%d,%d)\n",pgrp,sig);
	if( pgrp == 0 || pgrp == 1 ){
		syslog_ERROR("Error: tried to Killpg %d X-<\n",pgrp);
		return -1;
	}
	return killpg(pgrp,sig);
}
