/*///////////////////////////////////////////////////////////////////////
Copyright (c) 1993-1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1993-1998 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ccx.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	981119	extracted from ccxmain.c
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
extern void *CCXnew();
extern char *CCXident();

ccx_main(ac,av)
	char *av[];
{	void *ccx;
	int rcc,len;
	/* to test boundary condition; char in[8]; */
	char in[1024];
	char out[4096];
	char *incode;
	char *outcode;
	char *arg,*infile;
	int ai;
	FILE *ifp,*ofp;
	int nready;
	int ident = 0;
	int dump = 0;
	int load = 0;

	incode = "*";
	outcode = "j";
	infile = NULL;
	ifp = stdin;
	ofp = stdout;

	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];
		if( *arg == '-' ){
			if( strcmp(arg,"--ident") == 0 )
				ident = 1;
			else
			if( strcmp(arg,"--dump") == 0 )
				dump = 1;
			else
			if( strcmp(arg,"--load") == 0 )
				load = 1;
			else
			if( strncmp(arg,"--",2) == 0 )
				incode = arg+2;
			else
			outcode = arg+1;
		}else{
			infile = arg;
		}
	}

	if( infile ){
		ifp = fopen(infile,"r");
		if( ifp == NULL ){
			fprintf(stderr,"cannot open: %s\n",infile);
			exit(1);
		}
	}

	if( dump ){
		dumpCharMapping(outcode);
		exit(0);
	}
	if( load ){
		loadCharMapping(outcode,ifp);
		exit(0);
	}

	ccx = CCXnew(incode,outcode);
	if( ccx == NULL ){
		fprintf(stderr,"unknown output code: %s\n",outcode);
		exit(-1);
	}

	if( *outcode == 'u' )
		UCSinit();

	in[0] = out[0] = 0;
	for(;;){
		nready = PollIn(fileno(ifp),10);
		if( nready <= 0 )
			fflush(ofp);
		rcc = read(fileno(ifp),in,sizeof(in));
		if( rcc <= 0 )
			break;
		len = CCXexec(ccx,in,rcc,out,sizeof(out));
		if( !ident )
		fwrite(out,1,len,ofp);
	}
	len = CCXexec(ccx,"",0,out,sizeof(out));
	if( ident )
		printf("%s\n",CCXident(ccx));
	else
	fwrite(out,1,len,ofp);

	exit(0);
}
