#ifndef _VSOCKET_H
#define _VSOCKET_H

typedef unsigned /* long -- bad for DEC-ALPHA */ INETADDRV4;
extern INETADDRV4 _inet_addrV4();
#define inet_addrV4(a)	_inet_addrV4(a)
#define inet_ntoaV4I(i)	_inet_ntoaV4I(i)

#ifdef _MSC_VER
#include <winsock.h>
#include "ysocket.h"
#define SELF_AF_UNIX
#define SELF_RESOLV_H

#ifndef EISCONN
#define EISCONN		WSAEISCONN
#define EINPROGRESS	WSAEINPROGRESS
#define ECONNREFUSED	WSAECONNREFUSED
#define ENETUNREACH	WSAENETUNREACH
#define EHOSTUNREACH	WSAEHOSTUNREACH
#define ETIMEDOUT	WSAETIMEDOUT
#endif

#else

#include <sys/types.h>
#include <netdb.h>
#include "ysocket.h"

#ifdef __EMX__
#define TCPIPV4
#ifndef MAXSOCKETS
#define MAXSOCKETS 2048
#endif
#define SELECT_WIDTH(fd)	(fd+3)
#endif


#if defined(__CYGWIN__) || defined(__MINGW32__)
#define SO_SNDBUF	0x1001
#define SO_RCVBUF	0x1002
#define SO_TYPE		0x1008
#define SELF_AF_UNIX
#define SELF_RESOLV_H
#else
#ifndef IPPROTO_TCP
#include <sys/param.h>
#endif
#endif

#include <sys/time.h>
#include <sys/uio.h>
#include <sys/socket.h>

#ifdef NeXT
#include <netinet/in_systm.h>
#endif

#include <netinet/in.h>
#include <arpa/inet.h>

#if !(defined(__CYGWIN__) || defined(__MINGW32__))
#include <netinet/tcp.h>
#include <sys/un.h>
#include <arpa/nameser.h>
#include <resolv.h>
#endif

extern char *inet_ntoa();
extern int getsockname(),getpeername();
#endif /* _MSC_VER */

#ifdef SELF_AF_UNIX
struct sockaddr_un {
	short	sun_family;	/* AF_UNIX */
	char	sun_path[108];	/* path name */
};
#endif

extern struct hostent *EX_GETHOSTBYNAME(); /* system's standard resolver */
extern struct hostent *EX_GETHOSTBYADDR(); /* system's standard resolver */
extern struct hostent *_GETHOSTBYNAME(); /* resolvy */
extern struct hostent *_GETHOSTBYADDR(); /* resolvy */

#ifdef SELF_RESOLV_H
#ifndef _RESOLV_H_
#define	_RESOLV_H_

#define MAXDNAME 		128
#define	MAXNS			3
#define	MAXDFLSRCH		3
#define	MAXDNSRCH		6
#define	LOCALDOMAINPARTS	2
#define	RES_TIMEOUT		5
#define	MAXRESOLVSORT		10
#define	RES_MAXNDOTS		15

typedef struct sockaddr_in _SIN;

struct state {
	long	options;
	int	nscount;
	_SIN	nsaddr_list[MAXNS];
	char   *dnsrch[MAXDNSRCH+1];
	char	defdname[MAXDNAME];
};

#define RES_INIT	0x00000001
#define RES_DEBUG	0x00000002
#define RES_RECURSE	0x00000040
#define RES_DEFNAMES	0x00000080
#define RES_DNSRCH	0x00000200

#endif /* !_RESOLV_H */
#endif /* _SELF_RESOLV_H */
#endif /* _VSOCKET_H */


#define PS_IN     001
#define PS_PRI    002
#define PS_OUT    004
#define PS_ERR    010
#define PS_HUP    020
#define PS_NVAL   040
#define PS_ERRORS 070

#ifndef SELECT_WIDTH
#define SELECT_WIDTH(fd)	(fd+1)
#endif


#include <errno.h>
#ifndef EISCONN
#define EISCONN		-101
#endif
#ifndef EINPROGRESS
#define EINPROGRESS	-102
#endif
#ifndef ECONNREFUSED
#define ECONNREFUSED	-103
#endif
#ifndef ENETUNREACH
#define ENETUNREACH	-104
#endif
#ifndef EHOSTUNREACH
#define EHOSTUNREACH	-105
#endif
#ifndef ETIMEDOUT
#define ETIMEDOUT	-106
#endif


typedef union {
struct sockaddr	_sa;
	char	_sab[32];
} VSAddr;
typedef struct sockaddr *SAP;
extern char *VSA_ntoa();
