extern int LOG_type;

#define LOGLEVEL	(LOG_type&0xF)

#define L_SYNC		0x0000010
#define L_FG		0x0000020
#define L_TTY		0x0000040
#define L_SILENT	0x0000100
#define	L_TERSE		0x0000200
#define L_VERB		0x0000400
#define L_EXEC		0x0000800
#define L_FORK		0x0001000
#define L_STICK		0x0002000
#define L_LOCK		0x0004000
#define L_ARGDUMP	0x0010000

#define L_TRACE		0x0100000
#define L_NOEXEC	0x0200000
#define L_TRVERB	0x0400000
#define L_TRTERSE	0x0800000
#define L_SIGCHLD	0x1000000

#define lSYNC()	  	(LOG_type & L_SYNC)
#define lFG()	  	(LOG_type & L_FG)
#define lTTY()	  	(LOG_type & L_TTY)
#define lSILENT()	(LOG_type & L_SILENT)
#define lTERSE()  	(LOG_type & L_TERSE)
#define lVERB()	  	(LOG_type & L_VERB)
#define lEXEC()   	(LOG_type & L_EXEC)
#define lFORK()	  	(LOG_type & L_FORK)
#define lSTICK()  	(LOG_type & L_STICK)
#define lLOCK()	  	(LOG_type & L_LOCK)
#define lARGDUMP()	(LOG_type & L_ARGDUMP)

#define lTRACE()	(LOG_type & L_TRACE)
#define lNOEXEC()	(LOG_type & L_NOEXEC)
#define lTRVERB()	(LOG_type & L_TRVERB)
#define lTRTERSE()	(LOG_type & L_TRTERSE)
#define lSIGCHLD()	(LOG_type & L_SIGCHLD)

#define LW_CREATE	1
#define LW_EXMATCH	2

typedef struct _Logfile {
	char	*l_proto;
	char	*l_filters;	/* depend on l_proto */
	char	*l_pform;	/* template of path */
	char	*l_path;
	char	*l_lform;	/* format of log data */
	char	*l_mode;	/* mode of fopen */
	FILE	*l_fp;
	int	 l_dolock;	/* do lock */
	int	 l_lockfd;	/* extra lock file */
	char	*l_lkpath;
	int	 l_until;
	char	*l_buff;
	int	 l_size;
	int	 l_leng;
	int	 l_abandon;
	int	 l_notty;
} Logfile;

extern char LP_NOTTY[]; /* don't merge to tty even with -v option */
extern char LF_PROTOLOG[];
extern char LF_ERRORLOG[];
extern char LF_TRACELOG[];
extern char LF_LOGFILE[];
extern char *(*LOG_stdlogfile)();
extern int   (*LOG_substfile)();

#ifndef Verbose
extern int LOG_VERBOSE;
#define	Verbose	LOG_VERBOSE==0 ? 0 : sv1vlog
#endif
