names=checkbox_group
visibility=public
kind=defined

--- checkbox_group(name = "", *values) -> String

タイプが checkbox である input 要素のグループを生成します。

生成される input 要素の name 属性はすべて同じになり、
それぞれの input 要素の後ろにはラベルが続きます。

@param name name 属性の値を指定します。

@param values value 属性のリストを指定します。
              それぞれの引数が、単純な文字列の場合、value 属性の値とラベルに同じものが使用されます。
              それぞれの引数が、二要素または三要素の配列の場合、最終要素が true であれば、
              checked 属性をセットします。先頭の要素は value 属性の値になります。

例:
  checkbox_group("name", "foo", "bar", "baz")
    # <INPUT TYPE="checkbox" NAME="name" VALUE="foo">foo
    # <INPUT TYPE="checkbox" NAME="name" VALUE="bar">bar
    # <INPUT TYPE="checkbox" NAME="name" VALUE="baz">baz

  checkbox_group("name", ["foo"], ["bar", true], "baz")
    # <INPUT TYPE="checkbox" NAME="name" VALUE="foo">foo
    # <INPUT TYPE="checkbox" CHECKED NAME="name" VALUE="bar">bar
    # <INPUT TYPE="checkbox" NAME="name" VALUE="baz">baz

  checkbox_group("name", ["1", "Foo"], ["2", "Bar", true], "Baz")
    # <INPUT TYPE="checkbox" NAME="name" VALUE="1">Foo
    # <INPUT TYPE="checkbox" SELECTED NAME="name" VALUE="2">Bar
    # <INPUT TYPE="checkbox" NAME="name" VALUE="Baz">Baz

--- checkbox_group(attributes) -> String

タイプが checkbox である input 要素のグループを生成します。

生成される input 要素の name 属性はすべて同じになり、
それぞれの input 要素の後ろにはラベルが続きます。

@param attributes 属性をハッシュで指定します。

例:
  checkbox_group({ "NAME" => "name",
                   "VALUES" => ["foo", "bar", "baz"] })

  checkbox_group({ "NAME" => "name",
                   "VALUES" => [["foo"], ["bar", true], "baz"] })

  checkbox_group({ "NAME" => "name",
                   "VALUES" => [["1", "Foo"], ["2", "Bar", true], "Baz"] })

