= Queue

Queueはスレッド間のFIFO(first in first out)の通信路です。ス
レッドが空のqueueを読み出そうとすると停止します。queueになんら
かの情報が書き込まれると実行は再開されます。

: ((<SizedQueue>))
  最大サイズが指定できる Queue のサブクラスです。

== 例


  require 'thread'

  q = Queue.new
  
  th1 = Thread.start do
    while resource = q.pop
      puts resource
    end
  end
  
  [:resource1, :resource2, :resource3, nil].each{|r|
    q.push(r)
  }
  
  th1.join

実行すると以下のように出力します。

  $ ruby que.rb
  resource1
  resource2
  resource3

== スーパークラス:

* ((<Object>))

== クラスメソッド:

--- Queue.new
    新しいqueueオブジェクトを生成します。

== メソッド:

--- clear
    queue を空にします。返り値は不定です。

--- empty?
    queueが空の時、真を返します。

--- length
--- size
    queueの長さを返します。

--- num_waiting
    queue を待っているスレッドの数を返します。

--- pop(non_block = false)
--- shift(non_block = false)
--- deq(non_block = false)
    queueからひとつ値を取り出します。queueが空の時、呼出元のスレッ
    ドは停止します。((|non_block|)) に true を与えると、
    queueが空の時に例外 ((<ThreadError>)) が発生します。

--- push(value)
--- self << value
--- enq(value)
    queue の値を追加します。待っているスレッドがいれば実行を再開
    させます。返り値は不定です。
