= File::Stat

ファイルの情報を格納したオブジェクトのクラス。

== スーパークラス:

* ((<Object>))

== インクルードしているモジュール:

* ((<Comparable>))

== クラスメソッド:

--- File::Stat.new(path)

    ((|path|)) に関する (({File::Stat})) オブジェクトを生成して返します。
    ((<File/File.stat>)) と同じです。

== メソッド:

--- self <=> other

    ファイルの最終更新時刻を比較します。(({self})) が ((|other|)) よりも
    新しければ正の数を、等しければ 0 を古ければ負の数を返します。

--- ftype
    ファイルのタイプを表す文字列を返します。文字列は以下のうちの
    いずれかです。

      "file"
      "directory"
      "characterSpecial"
      "blockSpecial"
      "fifo"
      "link"
      "socket"

      "unknown"

    ((-あらい 2002-01-06: 今のところ "unknown" を返すことはないはず。
    もしそのようなことがあれば、バグ報告をした方が良いと思われる。
    Solaris の Door とかは unknown になる？-))

以下の属性メソッドは、システムによってサポートされていない場合 0 が返ります。
((<ruby 1.7 feature>)): 1.7 では nil が返ります。

--- dev
    デバイス番号(ファイルシステム)
--- dev_major  ((<ruby 1.9 feature>))
    dev の major 番号部
--- dev_minor  ((<ruby 1.9 feature>))
    dev の minor 番号部
--- ino
    i-node 番号
--- mode
    ファイルモード
--- nlink
    ハードリンクの数
--- uid
    オーナーのユーザID
--- gid
    オーナーのグループID
--- rdev
    デバイスタイプ(スペシャルファイルのみ)
--- rdev_major  ((<ruby 1.7 feature>))
    rdev の major 番号部
--- rdev_minor  ((<ruby 1.7 feature>))
    rdev の minor 番号部
--- size
    ファイルサイズ(バイト単位)
--- blksize
    望ましいI/Oのブロックサイズ
--- blocks
    割り当てられているブロック数
--- atime
    最終アクセス時刻
--- mtime
    最終更新時刻
--- ctime
    最終i-node変更時刻

以下の判定メソッドは、((<FileTest>)) の同名のモジュール関数と同じですが、
ファイル名を引数に取るかわりに (({Stat})) 自身について判定します。

--- directory?
    ディレクトリの時に真
--- readable?
    読み込み可能な時に真
--- readable_real?
    実ユーザ/実グループによって読み込み可能な時に真
--- writable?
    書き込み可能な時に真
--- writable_real?
    実ユーザ/実グループによって書き込み可能な時に真
--- executable?
    実効ユーザ/グループIDで実行できる時に真
--- executable_real?
    実ユーザ/グループIDで実行できる時に真
--- file?
    通常ファイルの時に真
--- zero?
    サイズが0である時に真
--- size?
    サイズ(0の時には偽)
--- owned?
    自分のものである時に真
--- grpowned?
    グループIDが実行グループIDと等しい時に真

--- pipe?
    名前つきパイプ(FIFO)の時に真
--- symlink?
    シンボリックリンクである時に真
--- socket?
    ソケットの時に真

--- blockdev?
    ブロックスペシャルファイルの時に真
--- chardev?
    キャラクタスペシャルファイルの時に真

--- setuid?
    setuidされている時に真
--- setgid?
    setgidされている時に真
--- sticky?
    stickyビットが立っている時に真
