= e2mmap.rb -- Exception2MessageMapper

例外クラスに特定のエラーメッセージ用フォーマットを関連づけます。

== Usage

1. クラス定義の中で、Exception2MessageMapperをextendすれば、
def_e2messageメソッドやdef_exceptionメソッドが使えます。
これらで例外クラスとメッセージを関連づけることができます。

   class Foo
     extend Exception2MessageMapper
     def_e2message ExistingExceptionClass, "message..."
     def_exception :NewExceptionClass, "message...", StandardError
     ...
   end

   foo = Foo.new
   foo.Fail ....

2. 何度も使いたい例外クラスは、クラスの代わりにモジュールで定義して、
それをincludeして使います。

   module ErrorMod
     extend Exception2MessageMapper
     def_e2meggage ExistingExceptionClass, "message..."
     def_exception :NewExceptionClass, "message...", StandardError
     ...
   end
   class Foo
     include ErrorMod
     ...
   end

   foo = Foo.new
   foo.Fail ....

3. 例外を設定したクラスのインスタンス以外から例外を呼ぶこともできます。

   module ErrorMod
     extend Exception2MessageMapper
     def_e2message ExistingExceptionClass, "message..."
     def_exception :NewExceptionClass, "message...", StandardError
     ...
   end
   class Foo
     extend Exception2MessageMapper
     include ErrorMod
     ...
   end

   Foo.Fail NewExceptionClass, arg...
   Foo.Fail ExistingExceptionClass, arg...


== Methods

# --- E2MM.extend_object(cl)
# ??

--- def_e2message(exception, message_form)

すでに存在する例外クラスexceptionに、
エラーメッセージ用フォーマット message_form を関連づけます。
message_formの形式は sprintf() のformat文字列と同じです。

このフォーマットはRaise(またはその別名のFail)で使われます。

--- def_exception(exception_name, message_form, superclass)

exception_nameという名前の例外クラスを作ります(exception_name
はシンボルで与えられます)。
このクラスは、superclassが設定されていればそのクラスの
サブクラスに、設定されていない場合はStandardErrorのサブ
クラスになります。

そして、そのクラスにmessage_formで指定されたフォーマットを
関連づけます。
これはRaise(またはその別名のFail)で使われます。


--- Raise(error, [args [,args2...]])

errorクラスのエラーを発生させます。

errorの後に続く引数 args群は、例外クラスに関連づけられたエラー
メッセージ用フォーマットと合わせて、エラーメッセージの一部に
なります。例えば、

  class Foo
    extend Exception2MessageMapper
    def_exception :NewExceptionClass, "message...%d, %d and %d"

    def foo
      Raise NewExceptionClass, 1, 2, 3
    end
  end

という定義があれば、

  Foo.new().foo()

というメソッドで、

  in `Raise': message...1, 2 and 3 (Foo::NewExceptionClass)  

というエラーが発生します。

また、

  Foo.Raise Foo::NewExceptionClass, 1, 3, 5

というメソッドでも、

  in `Raise': message...1, 3 and 5 (Foo::NewExceptionClass)  

という例外が発生します。


--- Fail(error, [args [,args2...]])

Raise の別名です。
 

