= Rinda::Template

((<Rinda>))

タプルのマッチングのためのクラスです。ユーザがこのクラスを直接使うことはありません。

== 例

 require 'rinda/rinda'
 
 template = Rinda::Template.new(['abc', nil, nil])
 template.match(['abc', 2, 5])   # => true
 template.match(['hoge', 2, 5])  # => false

 template = Rinda::Template.new([String, Integer, nil])
 template.match(['abc', 2, 5])   # => true
 template.match(['abcd', 2, 5])  # => true
 
 template = Rinda::Template.new([/^abc/, Integer, nil])
 template.match([/^abc/, Integer, nil])  # => true
 template.match(['abc', 2, 5])           # => true
 template.match(['def', 2, 5])           # => false
 
 template = Rinda::Template.new({'name' => String, 'age' => Integer})
 template.match({'name' => 'seki', 'age' => 0x20})   # => true
 template.match({'name' => :seki,  'age' => 0x20})   # => false

== スーパークラス

((<Rinda::Tuple>))

== メソッド

--- ===(tuple)
--- match(tuple)
    (({self})) と ((|tuple|)) のサイズが同じで、(({self})) の各要素が ((|tuple|)) に
    マッチする
    場合は真を返します。マッチングの検査には (({==})) と (({===})) を用います。
    (({nil})) はワイルドカードです。
