= Process

UNIX のプロセスを管理するモジュール。

(({Process})) がプロセスを表現するクラスではなく、プロセスに対する操作
をまとめたモジュールであることに注意してください。

== モジュールメソッド:

--- Process.abort([message])

    ((<ruby 1.7 feature>))

    関数 ((<組み込み関数/abort>)) と同じです。

--- Process.daemon(nochdir=nil,noclose=nil)

    ((<ruby 1.9 feature>))

    プロセスから制御端末を切り離し、
    バックグラウンドにまわってデーモンとして動作させます。

    カレントディレクトリを / に移動します。
    ただし ((|nochdir|)) に真を指定したときにはこの動作は抑制され、
    カレントディレクトリは移動しません。

    標準入力・標準出力・標準エラー出力を /dev/null にリダイレクトします。
    ただし ((|noclose|)) に真を指定したときにはこの動作は抑制され、
    リダイレクトは行なわれません。

    0を返します。

--- Process.detach(pid)

    ((<ruby 1.8 feature>))

    子プロセス ((|pid|)) の終了を監視するスレッドを生成して返します。
    生成したスレッドは子プロセスが終了した後に (({nil})) で終了します。
    (指定した子プロセスが存在しなければ即座に nil で終了します)。

        pid = fork {
          # child
          sleep 3
        }

        th = Process.detach(pid)
        p th.value

        # => nil

--- Process.exit([status])

    ((<ruby 1.7 feature>))

    関数 ((<組み込み関数/exit>)) と同じです。

--- Process.exit!([status])

    関数 ((<組み込み関数/exit!>)) と同じです。

--- Process.fork
--- Process.fork { ... }

    関数 ((<組み込み関数/fork>)) と同じです。

--- Process.getrlimit(resource)                         ((<ruby 1.9 feature>))
--- Process.setrlimit(resource, cur_limit, max_limit)   ((<ruby 1.9 feature>))
--- Process.setrlimit(resource, cur_limit)              ((<ruby 1.9 feature>))

    ((|resource|)) で示すプロセスリソースの制限値の取得、設定を行います。

    Process.setrlimit において ((|max_limit|)) が省略された場合には ((|cur_limit|)) が指定されたものとして扱います。

    ((|resource|)) に指定する値は環境によりますが、
    以下のいずれかです(システムによっては
    これら以外にも指定できる値があります。詳細は、
    ((<setrlimit(2)|manual page>)) を参照してください)。

    * ((<Process::RLIMIT_CORE|Process/RLIMIT_CORE>)) core ファイルのサイズ (バイト) (SUSv3)
    * ((<Process::RLIMIT_CPU|Process/RLIMIT_CPU>)) プロセスの CPU 時間 (秒) (SUSv3)
    * ((<Process::RLIMIT_DATA|Process/RLIMIT_DATA>)) プロセスのデータ領域のサイズ (バイト) (SUSv3)
    * ((<Process::RLIMIT_FSIZE|Process/RLIMIT_FSIZE>)) プロセスが生成するファイルのサイズ (バイト) (SUSv3)
    * ((<Process::RLIMIT_NOFILE|Process/RLIMIT_NOFILE>)) プロセスがオープンできるファイルの数 (SUSv3)
    * ((<Process::RLIMIT_STACK|Process/RLIMIT_STACK>)) プロセスのスタック領域のサイズ (バイト) (SUSv3)
    * ((<Process::RLIMIT_AS|Process/RLIMIT_AS>)) プロセスの仮想メモリサイズ (バイト) (SUSv3, NetBSD, FreeBSD, OpenBSD but 4.4BSD-Lite))
    * ((<Process::RLIMIT_MEMLOCK|Process/RLIMIT_CORE>)) mlock(2) でロックできるトータルのサイズ (バイト) (4.4BSD, GNU/Linux)
    * ((<Process::RLIMIT_NPROC|Process/RLIMIT_NPROC>)) そのユーザのプロセスの最大数 (4.4BSD, GNU/Linux)
    * ((<Process::RLIMIT_RSS|Process/RLIMIT_RSS>)) 使用できる実メモリの最大サイズ (バイト) (4.2BSD, GNU/Linux)
    * ((<Process::RLIMIT_SBSIZE|Process/RLIMIT_SBSIZE>)) ソケットバッファのサイズ (バイト) (NetBSD, FreeBSD)

    (({getrlimit})) は、2値の配列 [((|cur_limit|)), ((|max_limit|))] 
    を返します。
    (({setrlimit})) は、引数に指定した値を設定し、(({nil})) を返します。

    リソースの制限値の取得、設定に失敗した場合、例外 ((<Errno::EXXX>)) 
    が発生します。

--- Process.spawn(cmd, [, arg, ...])    ((<ruby 1.9 feature>))

    関数 ((<組み込み関数/spawn>)) と同じです。

== モジュール属性:

これらは、((<Ruby用語集/モジュール関数>))です。

--- Process.egid

    カレントプロセスの実効グループ ID を返します。

--- Process.egid=gid

    カレントプロセスの実効グループ ID を設定します。((|gid|)) を返します。

--- Process.euid

    カレントプロセスの実効ユーザ ID を返します。

--- Process.euid=uid

    カレントプロセスの実効ユーザ ID を設定します。((|uid|)) を返します。

--- Process.gid

    カレントプロセスの実グループ ID を返します。

--- Process.gid=gid

    カレントプロセスの実グループ ID を設定します。((|gid|)) を返します。

--- Process.groups

    補助グループ ID の配列を返します(実効グループ ID を含むかも知れません)。

    返される配列の最大要素数は 32 固定です(たぶんbug)。

--- Process.groups=gid_ary

    補助グループを設定します。右辺の配列の要素はグループ ID かグループ
    名を指定します。Process.groups の結果を返します。

    設定する補助グループ ID の数が ((<Process/Process.maxgroups>)) の
    数を越えている場合、例外 ((<ArgumentError>)) が発生します。

--- Process.maxgroups
--- Process.maxgroups=num

    設定できる補助グループ ID の数を指定します。実際に返される補助グルー
    プ ID の数よりも少ない値を設定していると、
    ((<Process/Process.groups>)) で例外が発生します。

--- Process.pid

    カレントプロセスのプロセス ID を返します。変数 ((<組み込み変数/$$>)) 
    の値と同じです。

--- Process.ppid

    親プロセスのプロセス ID を返します。UN*X では実際の親プロセスが終
    了した後は (({ppid})) は 1 ((({init}))の pid)になります。

--- Process.uid

    プロセスの実ユーザ ID を返します。

--- Process.uid=uid

    プロセスの実ユーザ ID を設定します。((|uid|)) を返します。

== モジュール関数:

--- Process.getpgid(pid)
--- Process.getpgrp([pid])

    ((|pid|)) のプロセスのプロセスグループを返します。((|pid|)) が 0 
    の時や省略された時はカレントプロセスを意味します。

    プロセスグループの取得に失敗した場合は、例外 ((<Errno::EXXX>)) が
    発生します。
    ((-1.6.7 までは、getpgid() は例外を発生させていませんでした。
    p Process.getpgid(1000000) # => -1
    -))。

--- Process.getpriority(which, who)

    プロセス、プロセスグループ、ユーザの現在のプライオリティを返
    します(((<getpriority(2)|manual page>)) 参照)。

    (({Process})) モジュールは ((|which|)) として指定できる定数 
    ((<Process/PRIO_PROCESS>)), ((<Process/PRIO_PGRP>)),
    ((<Process/PRIO_USER>)) を定義しています。

    ((|who|)) には、((|which|)) の値にしたがってプロセス ID、プロセス
    グループ ID、ユーザ ID のいずれかを指定します。

    プライオリティの取得に失敗した場合は、例外 ((<Errno::EXXX>)) が発
    生します。

--- Process.initgroups(user, group)

    ((<ruby 1.8 feature>))

    ((<執筆者募集>))

    (((<initgroups(3)|manual page>)) 参照)

--- Process.kill(signal, pid ... )

    ((|pid|)) で指定されたプロセスにシグナルを送ります。((|signal|)) 
    はシグナル番号か名前(文字列または((<Symbol>)))で指定します。

    負の値を持つシグナル(あるいはシグナル名の前に(({-})))もしくは
    負の値を持つプロセス番号を与えるとプロセスではなくプロセスグループにシグナルを送ります。
    負の値のプロセス番号はプロセスグループ番号を符号反転したものと見なされます。

    全てのシグナル送信に成功した場合、指定した pid の数を返します。
    失敗した場合は例外 ((<Errno::EXXX>)) が発生します。

    存在しないシグナルを指定した場合は、例外 ((<ArgumentError>)) が発
    生します((-なお、Windows (((<mswin32>)), ((<mingw32>)))では、INT
    ILL FPE SEGV TERM BREAK ABRT しか指定できません。((<ruby 1.7 feature>))
    KILL も指定できます-))

    ((<組み込み関数/trap>))も参照してください。

--- Process.setpgrp(pid, pgrp)
--- Process.setpgrp               ((<ruby 1.7 feature>))
--- Process.setpgid(pid, pgrp)

    ((|pid|)) のプロセスグループを設定します。((|pid|)) が 0 の時はカ
    レントプロセスを意味します。

    プロセスグループの設定に成功した場合は 0 を返します。失敗した場合
    は、例外 ((<Errno::EXXX>)) が発生します。

    ((<ruby 1.7 feature>)):
    version 1.7 では、Process.setpgrp は、引数を取りません。

--- Process.setpriority(which, who, prio)

    プロセス、プロセスグループ、ユーザの現在のプライオリティを設
    定します(((<setpriority(2)|manual page>)) 参照)。

    (({Process})) モジュールは ((|which|)) として指定できる定数 
    ((<Process/PRIO_PROCESS>)), ((<Process/PRIO_PGRP>)),
    ((<Process/PRIO_USER>)) を定義しています。

    ((|who|)) には、((|which|)) の値にしたがってプロセス ID、プロセス
    グループ ID、ユーザ ID のいずれかを指定します。

    ((|prio|)) には、-20 から 20 の値を設定します。

    プライオリティの設定に成功した場合は 0 を返します。失敗した場合は、
    例外 ((<Errno::EXXX>)) が発生します。

--- Process.setsid()

    新しいセッションを作成して、tty を切り離します。デーモンを簡単に作
    ることができます。セッション ID を返します。

    セッション ID の作成に失敗した場合は、例外 ((<Errno::EXXX>)) が発
    生します。

--- Process.times     ((<ruby 1.7 feature>))

    自身のプロセスとその子プロセスが消費したユーザ/システム CPU 時間の
    積算を ((<Struct>))::Tms のオブジェクトとして返します。
    (({Struct::Tms})) は以下のメンバを持つ構造体クラスです。

      utime           # user time
      stime           # system time
      cutime          # user time of children
      cstime          # system time of children

    時間の単位は秒で、浮動小数点数で与えられます。詳細は 
    ((<times(3)|manual page>)) を参照してください。

--- Process.wait
--- Process.wait2

    子プロセスが終了するのを待ち、終了した子プロセスの pid を返します。
    子プロセスが一つもなければ例外 ((<Errno::ECHILD|Errno::EXXX>)) が
    発生します。

    (({wait2})) は、その戻り値が pid と ((<組み込み変数/$?>)) の配列であ
    る点だけが異なります。

    ((<ruby 1.7 feature>)):
    version 1.7 からは (({$?})) は((<Process::Status>)) オブジェクトで
    す。
    Process.wait と Process.waitpid の実体は同じものになりました。
    Process.wait2 と Process.waitpid2 の実体は同じものになりました。

--- Process.waitall ((<ruby 1.7 feature>))

    全ての子プロセスが終了するのを待ちます。

    終了した子プロセスの pid と終了ステータス(((<Process::Status>)))の
    配列を要素に持つ配列を返します。子プロセスがいない状態でこのメソッ
    ドを呼び出すと空の配列を返します。

    ((<組み込み変数/$?>)) には最後に終了した子プロセスの終了ステータスが
    設定されます。

    例:
        3.times {|n|
          Process.fork() { exit n }
        }
        p ret = Process.waitall
        p ret[-1][1]  , ret[-1][1].type 
        p $?          , $?.type
        => [[5245, 256], [5244, 0], [5243, 512]]
           512
           Process::Status
           512
           Process::Status

--- Process.waitpid(pid[, flags])
--- Process.waitpid2(pid[, flags])

    ((|pid|)) で指定される特定の子プロセスの終了を待ち、そのプロセスが
    終了した時に (({pid})) を返します。子プロセスが存在しなければ例外 
    ((<Errno::ECHILD|Errno::EXXX>)) が発生します。

    ((|flags|)) には、(({Process})) モジュールの定数 
    ((<Process/WNOHANG>))(ノンブロッキングモード)と
    ((<Process/WUNTRACED>)) の論理和を指定します。省略したときの値は 0 
    です。

    ノンブロッキングモードで子プロセスがまだ終了していない時には 
    (({nil})) を返します。((<waitpid(2)|manual page>)) か 
    ((<wait4(2)|manual page>)) の実装されていないマシンでは 
    ((|flags|)) はいつも (({nil})) または 0 を指定する必要があります。

    (({waitpid2})) は、その戻り値が pid と ((<組み込み変数/$?>)) の配列
    である点だけが異なります。

    ((<ruby 1.7 feature>)):
    version 1.7 からは (({$?})) は ((<Process::Status>)) オブジェクト
    です。
    Process.wait と Process.waitpid の実体は同じものになりました。
    Process.wait2 と Process.waitpid2 の実体は同じものになりました。

== 定数:

--- PRIO_PROCESS

    ((<Process/Process.getpriority>)) または 
    ((<Process/Process.setpriority>)) のプロセスプライオリティ指定。

--- PRIO_PGRP

    プロセスグループプライオリティ。

--- PRIO_USER

    ユーザプライオリティ。

--- RLIMIT_AS
--- RLIMIT_CORE
--- RLIMIT_CPU
--- RLIMIT_DATA
--- RLIMIT_FSIZE
--- RLIMIT_MEMLOCK
--- RLIMIT_NOFILE
--- RLIMIT_NPROC
--- RLIMIT_RSS
--- RLIMIT_SBSIZE
--- RLIMIT_STACK
--- RLIM_INFINITY
--- RLIM_SAVED_CUR
--- RLIM_SAVED_MAX

    ((<Process/Process.getrlimit>)) 参照。
    ((<執筆者募集>))

--- WNOHANG

    ((<Process#waitpid|Process/waitpid>)) の第二引数に指定するフラグで
    す。終了した子プロセスがない時に (({waitpid})) がブロックしません。

--- WUNTRACED

    ((<Process#waitpid|Process/waitpid>)) の第二引数に指定するフラグで
    す。子プロセスの停止によりステータスを報告していない子プロセスがあ
    る時に (({waitpid})) がブロックしません。

== 内部クラス:

--- Status  ((<ruby 1.7 feature>))

    プロセスの終了ステータスを表現するクラスです。
    ((<Process::Status>)) を参照してください。

== 内部モジュール:

--- UID         ((<ruby 1.8 feature>))
--- GID         ((<ruby 1.8 feature>))
--- Sys         ((<ruby 1.8 feature>))

    プロセスのユーザ/グループ属性に関する操作をまとめたモジュール。モ
    ジュール UID、GID は各種 Unix システム間の違いを吸収したインタフェー
    スを提供します。

    モジュール Sys は、システムコール相当のメソッドを提供します。

    それぞれ、((<Process::UID>)), ((<Process::GID>)), ((<Process::Sys>)) 
    を参照してください。
