= Net::HTTP

((<"net/http.rb">))

HTTP のクライアントのためのクラスです。

== クラスメソッド

--- HTTP.new( address, port = 80, proxy_addr = nil, proxy_port = nil )
    新しい HTTP オブジェクトを生成します。address は HTTP サーバーの FQDN で、
    port は接続するポート番号です。このメソッドではまだ接続はしません。

    proxy_addr を与えるとプロクシを介して接続するオブジェクトを生成します。

--- HTTP.start( address, port = 80, proxy_addr = nil, proxy_port = nil )
--- HTTP.start( address, port = 80, proxy_addr = nil, proxy_port = nil ) {|http| .... }
    以下と同じです。

        Net::HTTP.new(address, port, proxy_addr, proxy_port).start(&block)

--- HTTP.get( address, path, port = 80 )
    ホスト address の port 番ポートに接続して path の表現する
    エンティティボディを取得し、文字列で返します。

--- HTTP.get_print( address, path, port = 80 )
    ホスト address の port 番ポートに接続して path の表現する
    エンティティボディを取得したうえ、$stdout に << で出力します。

--- HTTP.Proxy( address, port = 80 )
    Proxy 経由で http サーバに接続するためのクラスを作成し返します。
    このクラスは Net::HTTP を継承しているので Net::HTTP と全く
    同じように使えます。指定されたプロクシを常に経由して http サーバ
    に接続します。

    address が nil のときは Net::HTTP クラスをそのまま返します。

        require 'net/http'
        proxy_class = Net::HTTP::Proxy( 'proxy.example.com', 8080 )
        http = proxy_class.new( 'www.ruby-lang.org' )
        http.start {|h|
          h.get('/ja/') # proxy.example.com 経由で接続します。
        }

--- HTTP.proxy_class?
    自身が (Proxy メソッドによって作成された) プロクシ用のクラスならば真。

--- HTTP.port
    HTTP のデフォルトポート (80)。

== メソッド

--- start
--- start {|http| .... }
    TCP コネクションを張り、HTTP セッションを開始します。
    すでにセッションが開始していたら例外 IOError を発生します。

    イテレータとして呼ばれた時はブロックの間だけセッションを接続し、
    ブロック終了とともに自動的にセッションを閉じます。

--- active?
    HTTP セッションが開始されていたら真。

--- address
    接続するアドレス

--- port
    接続するポート番号

--- open_timeout
--- open_timeout=(n)
    接続時に待つ最大秒数。この秒数たってもコネクションが
    開かなければ例外 TimeoutError を発生します。

--- read_timeout
--- read_timeout=(n)
    読みこみ (read(1) 一回) でブロックしてよい最大秒数。
    この秒数たっても読みこめなければ例外 TimeoutError を発生します。

--- finish
    HTTP セッションを終了します。セッション開始前にこのメソッドが
    呼ばれた場合は例外 IOError を発生します。

--- proxy?
    プロクシを介して接続するなら真。

--- proxy_address
    プロクシ経由で接続する HTTP オブジェクトならプロクシのアドレス。
    そうでないなら nil。

--- proxy_port
    プロクシ経由で接続する HTTP オブジェクトならプロクシのポート。
    そうでないなら nil。

--- get( path, header = nil )
--- get( path, header = nil ) {|str| .... }
    サーバ上の path にあるエンティティを取得します。また header が nil
    でなければ、リクエストを送るときにその内容を HTTP ヘッダとして書き
    こみます。header はハッシュで、「ヘッダ名 => 内容」のような形式で
    なければいけません。

    戻り値は、バージョン 1.1 では HTTPResponse とエンティティボディ文字列の
    二要素の配列です。1.2 では HTTPResponse ただひとつのみです。この場合、
    エンティティボディは response.body で得られます。

    ブロックとともに呼ばれた時はエンティティボディを少しづつブロックに
    与えます。

    1.1 では 3xx (再試行可能なエラー)に対しても例外を発生します。この場合
    HTTPResponse は例外オブジェクトから err.response で得ることができます。
    一方 1.2 では全く例外を発生しません。

        # version 1.1 (bundled with Ruby 1.6)
        response, body = http.get( '/index.html' )

        # version 1.2 (bundled with Ruby 1.7 or later)
        response = http.get( '/index.html' )

        # compatible in both version
        response , = http.get( '/index.html' )
        response.body
        
        # using block
        File.open( 'save.txt', 'w' ) {|f|
            http.get( '/~foo/', nil ) do |str|
              f.write str
            end
        }

--- head( path, header = nil )
    サーバ上の path にあるエンティティのヘッダのみを取得します。
    また header が nil でなければリクエストを送るときにその内容を
    HTTP ヘッダとして書きこみます。header はハッシュで、
    「ヘッダ名 => 内容」のような形式でなければいけません。

    HTTPResponse オブジェクトを返します。

    1.1 では 3xx (再試行可能なエラー)に対しても例外を発生します。この場合
    HTTPResponse は例外オブジェクトから err.response で得ることができます。
    一方 1.2 では全く例外を発生しません。

        response = nil
        Net::HTTP.start( 'some.www.server', 80 ) {|http|
            response = http.head( '/index.html' )
        }
        p response['content-type']

--- post( path, data, header = nil, dest = nil )
--- post( path, data, header = nil ) {|str| .... }
    サーバ上の path にあるエンティティに対し文字列 data を
    送ります。

    戻り値は get と同じように、バージョン 1.1 では HTTPResponse と
    エンティティボディ文字列の 二要素の配列です。1.2 では HTTPResponse 
    ただひとつのみです。この場合、エンティティボディは response.body で得られます。

    header は get メソッドと同じです。

    dest を与えた場合には、レスポンスは << メソッドを使って dest に書きこまれます。
    dest には << メソッドが定義されたオブジェクト、通常 ((<String>)) オブジェクトか
    ((<Array>)) オブジェクトを与えます。この dest は戻り値の HTTPResponse オブジェクトの
    body にもなります。
 
    ブロックと一緒に呼びだされたときはエンティティボディを少しづつ文字列として
    ブロックに与えます。このとき戻り値の HTTPResponse オブジェクトは有効な body を
    持ちません。

    dest とブロックを同時に与えてはいけません。同時に与えた場合は例外 ArgumentError
    を投げます。

    1.1 では 3xx (再試行可能なエラー)に対しても例外を発生します。この場合
    HTTPResponse は例外オブジェクトから err.response で得ることができます。
    一方 1.2 では全く例外を発生しません。

        # version 1.1
        response, body = http.post( '/cgi-bin/search.rb', 'query=subject&target=ruby' )

        # version 1.2
        response = http.post( '/cgi-bin/search.rb', 'query=subject&target=ruby' )

        # compatible in both version
        response , = http.post( '/cgi-bin/search.rb', 'query=subject&target=ruby' )

        # using block
        File.open( 'save.html', 'w' ) {|f|
            http.post( '/cgi-bin/search.rb',
                       'query=subject&target=ruby' ) do |str|
              f.write str
            end
        }

--- request_get( path, header = nil )
--- request_get( path, header = nil ) {|response| .... }
    path にあるエンティティを取得します。HTTPResponse
    オブジェクトを返します。

    ブロックとともに呼び出されたときは、ブロック実行中は接続を
    維持したまま HTTPResponse オブジェクトをブロックに渡します。

    このメソッドは HTTP プロトコルに関連した例外は発生させません。

        # example
        response = http.request_get( '/index.html' )
        p response['content-type']
        puts response.body          # body is already read

        # using block
        http.request_get( '/index.html' ) {|response|
            p response['content-type']
            response.read_body do |str|   # read body now
              print str
            end
        }

--- request_post( path, data, header = nil )
--- request_post( path, data, header = nil ) {|response| .... }
    path にあるエンティティを取得します。HTTPResponse
    オブジェクトを返します。

    ブロックとともに呼び出されたときは、ボディを読みこむ前に
    HTTPResponse オブジェクトをブロックに渡します。

    このメソッドは HTTP プロトコルに関連した例外は発生させません。

        # example
        response = http.post2( '/cgi-bin/nice.rb', 'datadatadata...' )
        p response.status
        puts response.body          # body is already read

        # using block
        http.post2( '/cgi-bin/nice.rb', 'datadatadata...' ) {|response|
          p response.status
          p response['content-type']
          response.read_body do |str|   # read body now
            print str
          end
        }

--- request( request [, data] )
--- request( request [, data] ) {|response| .... }
    HTTPResquest オブジェクト request を送信します。POST/PUT の時は data も
    与えられます (POST/PUT 以外で data を与えると ArgumentError を発生します)。

    ブロックとともに呼びだされたときはボディを読みこまずに HTTPResponse
    オブジェクトをブロックに与えます。

    このメソッドは HTTP プロトコルに関連した例外は発生させません。
