= Find
# find.rb version 1.8

ディレクトリ配下のファイルを探索するためのモジュールです。

== 使い方:

      require "find"

      Find.find('/foo','/bar') {|f| ...}
または
      require "find"

      include Find
      find('/foo','/bar') {|f| ...}

以下は、ruby のアーカイブに含まれるサンプルスクリプト 
((<"ruby-src:sample/trojan.rb">)) をこのモジュールで書き換えたものです。

    #! /usr/bin/env ruby
    require "find"
    # 他人が書き込み可能な危険なコマンドを探す

    for dir in ENV['PATH'].split(File::PATH_SEPARATOR)
      Find::find(dir) do |fpath|
        if File.file?(fpath) and (File.stat(fpath).mode & 022) != 0
          printf("file %s is writable from other users\n", fpath)
        end
      end
    end

== モジュール関数:
--- Find.find(dir[, ...]) {|file| }
    ((<find(1)|manual page>))のように((|dir|))配下のすべてのファイルや
    ディレクトリを一つずつ引数((|file|))に渡してブロックを実行します。
    ((|file|)) に渡される順序は不定です。

    あるディレクトリ配下の探索を省略したい場合

      require 'find'

      Find.find('/tmp') {|f|
        Find.prune if f == "/tmp/bar"
        ...
      }

    のように、((<Find/Find.prune>))を使用します。この例では "/tmp/bar" 
    配下のファイルやディレクトリを探索しません。(({prune})) の代わりに 
    ((<制御構造/next>)) を使用した場合、"/tmp/bar" 自体をスキップする
    だけで、その配下の探索は続行されます．

--- Find.prune
    ((<Find/Find.find>))メソッドのブロックにディレクトリが渡されたときにこ
    のメソッドを実行すると、そのディレクトリ配下の探索を無視します。

== 履歴:
: version 1.4 (ruby version 1.6.1)
    ディレクトリのシンボリックリンクを辿らなくなりました。
