= ERB

eRubyスクリプトを処理するクラス。
従来ERbLightと呼ばれていたもので、標準出力への印字が文字列の挿入とならない点が
erubyと異なる。


== 使い方 

ERBクラスを使うためには require 'erb' する必要がある。

    require 'erb'

    ERB.new($<.read).run


== クラスメソッド

--- ERB.new(eruby_script, safe_level=nil, trim_mode=nil, eoutvar='_erbout')
    eruby_scriptからERBを生成する。eval時の$SAFE、trim_mode(後述)、
    eoutvar(eRubyスクリプトの中でさらにERBを使うときに変更する。
    普通、変更する必要はない。)を指定できる。

== メソッド

--- ERB#run(b=TOPLEVEL_BINDING)
    ERBをbのbindingで実行し、印字する。

--- ERB#result(b=TOPLEVEL_BINDING)
    ERBをbのbindingで実行し、文字列を返す。

--- ERB#src
    変換したRubyスクリプトを取得する。

--- ERB#def_method(mod, methodname, fname='(ERB)')
    変換したRubyスクリプトをメソッドとして定義する。
    定義先のモジュールはmodで指定し、メソッド名はmethodnameで指定する。
    fnameはスクリプトを定義する際のファイル名である。主にエラー時に活躍する。
    
      erb = ERB.new(script)
      erb.def_method(MyClass, 'foo(bar)', 'foo.erb')

--- ERB#def_module(methodname='erb')
    変換したRubyスクリプトをメソッドとして定義した無名のモジュールを返す。

--- ERB#def_class(suplerklass=Object, methodname='erb')
    変換したRubyスクリプトをメソッドとして定義した無名のクラスを返す。
    ((-使い途がなさそうだ…。-))

== Module ERB::Util

--- ERB::Util.html_escape(s)
--- ERB::Util.h(s)
    HTMLの &"<> をエスケープする。
    (((<CGI/CGI.escapeHTML>))とほぼ同じ。)

--- ERB::Util.url_encode(s)
--- ERB::Util.u(s)
    文字列をURLエンコードする。
    (((<CGI/CGI.escape>))とほぼ同じ。)

== Module ERB::DefMethod

--- ERB::DefMethod.def_erb_method(methodname, erb)
    selfにerbのスクリプトをメソッドとして定義する。メソッド名はmethodnameで指定する。
    selfが文字列の時、そのファイルを読み込みERBで変換したのち、メソッドとして定義する。

      class Writer
        extend ERB::DefMethod
        def_erb_method('to_html', 'writer.erb')
        ...
      end
      ...
      puts writer.to_html

== trim_mode

trim_modeは整形の挙動を変更するオプションである。次の振舞いを指定できる。
* 改行の扱い
* %ではじまる行の扱い (2.0から追加された)


trim_modeに指定できる値は次の通り。

* ERb-1.4.x互換の指定方法
  * nil, 0: そのまま変換
  * 1: 行末が%>のとき改行を出力しない
  * 2: 行頭が<%で行末が%>のとき改行を出力しない

* 2.0からの指定方法
  * nil, "": そのまま変換
  * ">": 1と同じ
  *  "<>": 2と同じ
  * "-": 行末が-%>のとき改行を出力しない。また、行頭が<%-のとき行頭の空白文字を削除する
  * "%": %ではじまる行を<%..%>とみなして変換する。この行の改行は出力しない
  * "%>", ">%": 1と"%"の両方を行なう
  * "%<>", "<>%": 2と"%"の両方を行なう
  * "%-": "-"と"%"の両方を行なう


実行例

  # スクリプト
  <% 3.times do |n| %>
  % n = 0
  * <%= n%>
  <% end %>

  # trim_mode = nil, '', 0
    
  % n = 0
  * 0
  
  % n = 0
  * 1
  
  % n = 0
  * 2

  # trim_mode = 1, '>'
  % n = 0
  * 0% n = 0
  * 1% n = 0
  * 2

  # trim_mode = 2, '<>'
  % n = 0
  * 0
  % n = 0
  * 1
  % n = 0
  * 2

  # trim_mode = '%'

  * 0

  * 0

  * 0

  # trim_mode = '%>', '>%'
  * 0* 0* 0

  # trim_mode = '%<>', '<>%'
  * 0
  * 0
  * 0

  # スクリプト
  <% 3.times do |n| -%>
  % n = 0
    <%- m = 0 %>*
  * <%= n%>
  <% end -%>

  # trim_mode = '%-'
  *
  * 0
  *
  * 0
  *
  * 0

  # スクリプト
  <% 3.times do |n| %>
  % n = 0
    <%- m = 0 %>*
  * <%= n%>
  <% end %>

  # trim_mode = '%'
  
    *
  * 0
  
    *
  * 0
  
    *
  * 0
