###nonref

= Rubyの終了処理

Ruby はスクリプトの終端に達した場合や捕捉していない例外が発生した場
合に終了します(関数 ((<組み込み関数/exit>)) や ((<組み込み関数/abort>))
、メインスレッドに対する ((<Thread/Thread.kill>)) などは 
((<SystemExit>)) 例外を発生させます)。終了時には以下
の処理が順に実行されます。

  (1) すべてのスレッドを ((<Thread/Thread.kill>)) する。

  (1) Ruby の疑似シグナル SIGEXIT のハンドラが登録されていればそれを実
      行する(((<組み込み関数/trap>)) を参照)。

  (1) ((<制御構造/END>)) ブロック(END { ... } または関数
      ((<組み込み関数/at_exit>)) で指定したブロック)が登録されていれば、
      そのブロックを登録とは逆順に実行する。このブロックの実行中に発生
      した大域脱出はそのブロックの処理を中断するが。スクリプトはまだ終
      了しない。

  (1) ((<ObjectSpace/ObjectSpace.define_finalizer>)) により、ファイナ
      ライザが登録されていればそれらを実行する(実行順序は不定)

      ファイナライザ実行中に発生した大域脱出はそのファイナライザの処理
      を中断するが、スクリプトはまだ終了しない。

  (1) ((<exit(3)|manual page>)) により終了する

      このとき渡される終了ステータス値は終了方法によります。
      例えば、

      * スクリプトの終端に達した場合は 0
      * ((<組み込み関数/exit>)) に渡した引数
      * ((<SystemExit>)) による例外以外は 1
      * ((<SystemExit>)) を明示的に raise したときは 0
        ((-((<ruby 1.7 feature>)): ((<SystemExit>)) を明示的に raise 
        したときでも 1 で終了するようになった-))

関数 ((<組み込み関数/exit!>)) による終了は、((<_exit(2)|manual page>)) 
を実行するだけで、上記の処理はいずれも行われません。
