= Matrix
[2002-04-03]  by ((<|URL:mailto:sugawah@attglobal.net>))

(((<Numeric>))ǤȤ)򰷤饹

== 

mnĤοa(i,j)

    [ a(0,0) a(0,1) a(0,2)  a(0,3) ... a(0,n-1)   ]
    [ a(1,0) a(1,1) a(1,2)  a(1,3) ... a(1,n-1)   ]
    [ a(2,0) a(2,1) a(2,2)  a(2,3) ... a(2,n-1)   ]
    [                                             ]
    [ a(m-1,0)                         a(m-1,n-1) ]

Τ褦ˡĲɽˤ路Τ(m,n)ιȤ
m=nιm(square matrix)Ȥ

夫iܤβο¤Ӥi(the i-th row)
jܤνĤο¤Ӥj(the j-th column)Ȥ

(m,n)ϡ
礭nι()٥ȥmĽĤ¤٤ΤȤߤʤȤǤ뤷
礭m()٥ȥnĲ¤٤ΤȤߤʤȤǤ롣

iԡjˤa(i,j)(i,j)((-elementȤˤϡؤǤϡʬסʪǤϡǡפȤ򤢤Ƥ롣ؤΡǡפcomponentȤ-))(the (i,j)-th element)Ȥ

i=ja(i,j)г(diagonal element)
ʳǤг(nondiagonal element)Ȥ


== ȤUsage

Matrix饹Ȥˤϡrequire 'matrix'ɬפ롣

    require 'matrix'


== 󥹥  Instance Creation
--- Matrix.[](rows)
#    creates a matrix where `rows' indicates rows.
#    The parameter `rows' is an array of arrays,
#    e.g, Matrix[[11, 12], [21, 22]]

    rowsǤȤ롣
    rowsϥͥȤ(=)Ǥ롣
     Matrix[[11, 12], [21, 22]]

--- Matrix.rows(rows, copy = true)
#    creates a matrix where `rows' indicates rows.
#    If optional argument `copy' is false, use the array as
#    internal structure of the metrix without copying.

    rowsǤȤ롣
    rowsϥͥȤ(=)Ǥ롣
    ޤץ copy (false)ʤСʣԤʤ

--- Matrix.columns(columns)
#    creates a new matrix using `columns` as set of colums vectors.

    columns٥ȥνȤ롣

--- Matrix.diagonal(values)
#    creates a matrix where `values' indicates columns.

    гǤvalues(֥Ȥ¤)ǡгǤ0Ǥ褦롣

    (:) values˰켡Array1ĻꤹȡArrayͣǤȤ11ι󤬤Ǥ롣

--- Matrix.scalar(n, value)
#    creates a diagonal matrix such that the diagal compornents is given by `values'.

    гǤvalue()ǡгǤ0Ǥ褦n롣

--- Matrix.identity(n)
--- Matrix.unit(n)
--- Matrix.I(n)
#    creates an n-by-n unit matrix.

    nñ̹롣

    ñ̹ȤϡгǤ1ǡгǤ0Ǥ褦ʹǤ롣

--- Matrix.zero(n)
#    creates an n-by-n zero matrix.

    n롣
    ȤϡǤ0ιǤ롣

--- Matrix.row_vector(row)
#    creates a 1-by-n matrix such the row vector is `row'.
#    The parameter `row' is given as a Vector or an Array.

    Ǥrow(1,n)ι(ԥ٥ȥ)롣
    ǡrowϡ((<Vector>))ޤ((<Array>))Ϳ롣

--- Matrix.column_vector(column)
#    creates a n-by-1((-ʸ1-by-nȽ񤤤ƤΤϸ-)) matrix such that column vector is `column'.
#    The pameter `column' is given as a Vector or an Array.

    Ǥcolumn(n,1)ι(٥ȥ)롣
    ǡcolumnϡ((<Vector>))ޤ((<Array>))Ϳ롣


== ɤ߽Ф񤭹 Accessing
--- Matrix#[](i, j)
#    returns the (i,j)th-component

    (i,j)Ǥ֤

--- Matrix#row_size
#    returns the number of rows

    Ԥ礭֤

--- Matrix#column_size
#    returns the number of columns

    礭֤

--- Matrix#minor(from_row,row_size,from_col,col_size)
--- Matrix#minor(from_row..to_row,from_col..to_col)
#    returns sub matrix. parameter is specified as the following:
#    (1) from_row, row_size, from_col, size_col
#    (2) from_row..to_row, from_col..to_col

    ʬ֤ѥ᡼ϡˡǻꤹ롣
    (1) Ϲֹ, Ԥ礭, ֹ, 礭
    (2) Ϲֹ..λֹ, ֹ..λֹ

--- Matrix#[]=(i,j,x)
    (i,j)Ǥxѹ롣

Υ᥽åɤϡmatrix.rbƤʤ
ʲˡȻ򼨤

    require 'matrix'

    class Matrix
      def []=(i,j,x)
        @rows[i][j]=x
      end
    end

    m=Matrix[[11,12],[21,22]]
    m[1,1]=-1
    p m #=> Matrix[[11,12],[21,-1]]


== 黻 Arithmatics
--- Matrix#* m
#    times

    m򱦤褸֤

--- Matrix#+ m
#    plus

    mä֤

--- Matrix#- m
#    minus

    m򸺤֤

--- Matrix#/ m
#    self * m.inv

    mεչ򱦤褸֤

--- Matrix#inverse
--- Matrix#inv
#    inverse

    չ֤

--- Matrix#** n
--- Matrix#power(n)
#    power

    顼nФ٤֤

--- Matrix#** m
--- Matrix#power(m)
#    power

    mФ٤֤

== Фؿ Matrix functions
--- Matrix#determinant
--- Matrix#det
#    returns the determinant

    (determinant) ((-ζʽ򸫤-))֤

--- Matrix#rank
#    returns the rank

    (rank) ((-ζʽ򸫤-))֤

--- Matrix#trace
--- Matrix#tr
#    returns the trace

    ȥ졼(trace)֤
    Υȥ졼(trace)ȤϡгǤ¤Ǥ롣

--- Matrix#transpose
--- Matrix#t
#    returns the transposed

    žֹ(transpose matrix)֤
    Ƭ˷ǤФơa(j,i)(i,j)ǤȤ(n,m)žֹȤ


== ƥ졼 Iterators

--- Matrix#row(i)
#    returns the i-th row vector.
#    When the block is supplied for the method, the block is iterated over all row vectors.

    iܤιԥ٥ȥ֤
    ֥åͿ줿Ȥϡƹԥ٥ȥˤĤơ֥å򷫤֤

--- Matrix#column(j)
#    returns the j-th column vector. 
#    When the block is supplied for the method, the block is iterated over all column vectors.

    jܤ٥ȥ֤
    ֥åͿ줿Ȥϡ٥ȥˤĤơ֥å򷫤֤

--- Matrix#collect {|x| ... } 
--- Matrix#map {|x| ... }
#    creates a matrix which is the result of iteration of given block over all components.

    γǤФƥ֥åŬѤ򷫤֤̤ǤȤƻĹ롣


== Ƚ Testing
--- Matrix#regular?
#    Is regular?

    §(regular)ʤ鿿֤

    §ǤȤϡǤꡢġεչ¸ߤ뤳ȤǤ롣

--- Matrix#singular?
#    Is singular? i.e. Is non-regular?

    ð(singular)Ǥ롢ʤ§Ǥʤʤ鿿֤

--- Matrix#square?
#    Is square?

    Ǥʤ顢֤

== Ѵ Converting
--- Matrix#row_vectors
#    array of row vectors

    ٥ȥ֤

--- Matrix#column_vectors
#    array of column vectors

    ԥ٥ȥ֤

--- Matrix#to_a
#    converts to Array

    ((<Array>))Ѵ롣
    ̤ϡͥȤ()Ȥʤ롣

--- Matrix#to_f
#    converts each element to Float

    Ǥư((<Float>))Ѵ롣

--- Matrix#to_i
#    converts each element to Integer

    Ǥ((<Integer>))Ѵ롣

--- Matrix#to_r
#    converts each element to Rational

    Ǥͭ((<Rational>))Ѵ롣


== Complex饹Ȥʻ Working with Complex class

#"require 'complex'" extends every elements of Matrix object to Complex class.
#Most of the methods of Matrix class works as expected in this extended Matrix class.

require 'complex'뤳Ȥˤäơ
Matrix֥ȤǤ((<Complex>))饹˳ĥ롣
¿Υ᥽åɤϡγĥ줿Matrix饹Ǥ⡢̤ư롣

#The following example illustrates Matrix#conjugate method which replaces every elements into its conjugate.

ϡǤʣǿִ᥽å(Matrix#conjugate)Ǥ롣

    require 'matrix'
    require 'complex'

    class Matrix
      def conjugate
        collect{|e| e.conjugate }
      end
    end


== ChangeLog

*[2004-04-23] by ((<|URL:mailto:mas@star.le.ac.uk>))
    * Matrix.diagonalսä롣
*[2002-04-03] by ((<|URL:mailto:sugawah@attglobal.net>))
    * Ȥɲ
    * Working with Complex classɲ
    * []=᥽åɤɲ
    * ƥ졼طƱˤޤȤ᤿
    * ľ
    * ¾饹ؤΥ󥯤ɲ Numeric, Vector
*[2002-04-02]  by ((<|URL:mailto:sugawah@attglobal.net>))
