= PrettyPrint
#The class implements pretty printing algorithm.
#It finds line breaks and nice indentations for grouped structure.

Υ饹 pretty printing 르ꥺμǤ
Ԥΰ֤õ¤ΤޤȤޤΤˤ줤ʥǥȤܤޤ

#By default, the class assumes that primitive elements are strings and
#each byte in the strings have single column in width.
#But it can be used for other situasions
#by giving suitable arguments for some methods:
#newline object and space generation block for (({PrettyPrint.new})),
#optional width argument for (({PrettyPrint#text})),
#(({PrettyPrint#breakable})), etc.
#There are several candidates to use them:
#text formatting using proportional fonts,
#multibyte characters which has columns diffrent to number of bytes,
#non-string formatting, etc.

ǥեȤǤϡΥ饹ϺǤŪǤʸǤꡢ
1ХȤ1ȲꤷƤޤ
ĤΥ᥽åɤФŬڤʰͿ뤳Ȥǡ
ǤʤˤѤǤޤ:
(({PrettyPrint.new})) ˤϲԥ֥Ȥȶɽ֥å
(({PrettyPrint#text}))  (({PrettyPrint#breakable})) ˤȤäˡ
ȤĤθ㤨мΤ褦ʤΤǤ礦
proportional font ȤäƥȤ
ȥХȿۤʤ褦¿Хʸ
ʸʳνϤʤɤǤ

== class methods
--- PrettyPrint.new([output[, maxwidth[, newline]]]) [{|width| ...}]
#    creates a buffer for pretty printing.

    pretty printing ΤΥХåեޤ

#    ((|output|)) is an output target.
#    If it is not specified, (({''})) is assumed.
#    It should have a (({<<})) method which accepts
#    the first argument ((|obj|)) of (({PrettyPrint#text})),
#    the first argument ((|sep|)) of (({PrettyPrint#breakable})),
#    the first argument ((|newline|)) of (({PrettyPrint.new})),
#    and
#    the result of a given block for (({PrettyPrint.new})).
    ((|output|)) Ͻǡ
    ⤷ꤵʤ (({''})) ꤵޤ
    Υ֥ȤϼΤΤդ (({<<})) 
    ᥽åɤäƤʤФʤޤ󡣤ϡ
    (({PrettyPrint#text})) 1 ((|obj|))
    (({PrettyPrint#breakable})) 1 ((|sep|))
    (({PrettyPrint.new})) 1 ((|newline|))
    
    (({PrettyPrint.new})) Ϳ줿֥åɾ̤Ǥ

#    ((|maxwidth|)) specifies maximum line length.
#    If it is not specified, 79 is assumed.
#    However actual outputs may overflow ((|maxwidth|)) if
#    long non-breakable texts are provided.

    ((|maxwidth|)) ϹԤκꤷޤ
    Ϳʤ 79 ꤵޤ
    ԤǤʤΤϤ줿
    ºݤν ((|maxwidth|)) ۤ뤳Ȥޤ

#    ((|newline|)) is used for line breaks.
#    (({"\n"})) is used if it is not specified.
    ((|newline|)) ϲԤ˻Ȥޤ
    ꤵʤ (({"\n"})) ꤵޤ

#    The block is used to generate spaces.
#    (({{|width| ' ' * width}})) is used if it is not given.
    ֥å϶ޤ
    ꤵʤ (({{|width| ' ' * width}})) Ȥޤ

--- PrettyPrint.format([output[, maxwidth[, newline[, genspace]]]]) {|pp| ...}
#    is a convenience method which is same as follows:
    ʲƱƯ򤹤ΤǴؤΤѰդƤޤ

      begin
        pp = PrettyPrint.new(output, maxwidth, newline, &genspace)
        ...
        pp.flush
        output
      end

--- PrettyPrint.singleline_format([output[, maxwidth[, newline[, genspace]]]]) {|pp| ...}
#     is similar to (({PrettyPrint.format})) but the result has no breaks.
# 
#     ((|maxwidth|)), ((|newline|)) and ((|genspace|)) are ignored.
#     The invocation of (({breakable})) in the block doesn't break a line and
#     treated as just an invocation of (({text})).

    (({PrettyPrint.format})) ˻ƤޤԤޤ󡣰 
    ((|maxwidth|)), ((|newline|))  ((|genspace|)) ̵뤵ޤ֥
     (({breakable})) μ¹ԤϡԤ (({text})) μ¹ԤǤ뤫
    Τ褦˰ޤ

== methods
--- text(obj[, width])
#    adds ((|obj|)) as a text of ((|width|)) columns in width.
    ((|obj|))  ((|width|)) ΥƥȤȤɲäޤ

#    If ((|width|)) is not specified, (({((|obj|)).length})) is used.
    ((|width|)) ꤵʤä硢(({((|obj|)).length})) Ѥޤ

--- breakable([sep[, width]])
#    tells "you can break a line here if necessary", and a
#    ((|width|))-column text ((|sep|)) is inserted if a line is not
#    broken at the point.
    ɬפʤ餳ǲԽפȤȤΤޤ
    ⤷ΰ֤ǲԤʤС
    ((|width|))Υƥ ((|sep|)) ޤ

#    If ((|sep|)) is not specified, (({" "})) is used.
    ((|sep|)) ꤵʤ (({" "})) Ѥޤ

#    If ((|width|)) is not specified, (({((|sep|)).length})) is used.
#    You will have to specify this when ((|sep|)) is a multibyte
#    character, for example.
    ((|width|)) ꤵʤС(({((|sep|)).length})) Ѥޤ
    㤨 ((|sep|)) ¿Хʸκݤ˻ꤹɬפ뤫Τޤ

--- nest(indent) {...}
#    increases left margin after newline with ((|indent|)) for line breaks added
#    in the block.
    ֥åɲä줿Ԥθκޡ ((|indent|)) ֤
    äޤ

--- group([indent[, open_obj[, close_obj[, open_width[, close_width]]]]]) {...}
#    groups line break hints added in the block.
#    The line break hints are all to be breaked or not.
    ֥åɲä줿ԤΥҥȤ򥰥롼ײޤ

#    If ((|indent|)) is specified, the method call is regarded as nested by
#    (({nest(((|indent|))) { ... }})).
    ((|indent|)) ꤵ줿硢Υ᥽åɸƤӽФ
    (({nest(((|indent|))) { ... }})) ǥͥȤƤΤȤưޤ

#    If ((|open_obj|)) is specified, (({text open_obj, open_width})) is called
#    at first.
#    If ((|close_obj|)) is specified, (({text close_obj, close_width})) is
#    called at last.
    ((|open_obj|)) ꤵ줿硢(({text open_obj, open_width})) 
    ǽ˸ƤФޤ
    ((|close_obj|)) ꤵ줿硢(({text close_obj, close_width})) 
    Ǹ˸ƤФޤ

--- flush
#    outputs buffered data.
    Хåե줿ǡϤޤ

--- first?
#    is a predicate to test the call is a first call to (({first?})) with
#    current group.
#    It is useful to format comma separated values as:
    ߤΥ롼פ (({first?})) ФǽθƤӽФɤȽꤹ
    ҸǤ
    ϥޤǶڤ줿ͤΤͭѤǤ

      pp.group(1, '[', ']') {
        xxx.each {|yyy|
          unless pp.first?
            pp.text ','
            pp.breakable
          end
          ... pretty printing yyy ...
        }
      }

== Bugs
#* Box based formatting?  Other (better) model/algorithm?
* Ȣظ? ¾Υ르ꥺ?

== References
Christian Lindig, Strictly Pretty, March 2000,
((<URL:http://www.gaertner.de/~lindig/papers/strictly-pretty.html>))

Philip Wadler, A prettier printer, March 1998,
((<URL:http://www.research.avayalabs.com/user/wadler/topics/recent.html#prettier>))
