= Resolv
Rubyǽ񤫤줿꥾(̾)饤֥ꡣ
Since it is written in Ruby, it is thread-aware.
I.e. it can resolv many hostnames concurrently.

It is possible to lookup various resources of DNS using DNS module directly.

((<ɮ罸>))

== :
  Resolv.getaddress("www.ruby-lang.org")
  Resolv.getname("210.251.121.214").to_s
  Resolv::DNS.new.getresources("www.ruby-lang.org", Resolv::DNS::Resource::IN::A).collect {|r| r.address}
  Resolv::DNS.new.getresources("ruby-lang.org", Resolv::DNS::Resource::IN::MX).collect {|r| [r.exchange.to_s, r.preference]}

== 饹᥽å:
--- Resolv.getaddress(name)
--- Resolv.getaddresses(name)
--- Resolv.each_address(name) {|address| ...}
    They lookups IP addresses of ((|name|)) which represents a hostname
    as a string.

    getaddress returns first entry of lookupped addresses.
    getaddresses returns lookupped addresses.
    each_address iterates over lookupped addresses.

    :
      Resolv.getaddress("www.ruby-lang.org").to_s #=> "210.251.121.214"

--- Resolv.getname(address)
--- Resolv.getnames(address)
--- Resolv.each_name(address) {|name| ...}
    lookups hostnames of ((|address|)) which represents IP address as a string.

    getname returns first entry of lookupped names.
    getnames returns lookupped names.
    each_names iterates over lookupped names.

    :
      Resolv.getname("210.251.121.214").to_s #=> "helium.ruby-lang.org"


== Resolv::Hosts
hostname resolver using /etc/hosts format.

=== 饹᥽å:
--- Resolv::Hosts.new(hosts='/etc/hosts')

=== ᥽å:
--- Resolv::Hosts#getaddress(name)
--- Resolv::Hosts#getaddresses(name)
--- Resolv::Hosts#each_address(name) {|address| ...}
    address lookup methods.

--- Resolv::Hosts#getname(address)
--- Resolv::Hosts#getnames(address)
--- Resolv::Hosts#each_name(address) {|name| ...}
    hostnames lookup methods.

== Resolv::DNS
DNS stub resolver.

=== 饹᥽å:
--- Resolv::DNS.new(resolv_conf='/etc/resolv.conf')

=== ᥽å:
--- Resolv::DNS#getaddress(name)
--- Resolv::DNS#getaddresses(name)
--- Resolv::DNS#each_address(name) {|address| ...}
    address lookup methods.

    ((|name|)) must be a instance of Resolv::Name or String.  Lookupped
    address is represented as an instance of Resolv::IPv4 or Resolv::IPv6.

--- Resolv::DNS#getname(address)
--- Resolv::DNS#getnames(address)
--- Resolv::DNS#each_name(address) {|name| ...}
    hostnames lookup methods.

    ((|address|)) must be a instance of Resolv::IPv4, Resolv::IPv6 or String.
    Lookupped name is represented as an instance of Resolv::Name.

--- Resolv::DNS#getresource(name, typeclass)
--- Resolv::DNS#getresources(name, typeclass)
--- Resolv::DNS#each_resource(name, typeclass) {|resource| ...}
    They lookup DNS resources of ((|name|)).
    ((|name|)) must be a instance of Resolv::Name or String.

    ((|typeclass|)) should be one of follows:
    * Resolv::DNS::Resource::IN::ANY
    * Resolv::DNS::Resource::IN::NS
    * Resolv::DNS::Resource::IN::CNAME
    * Resolv::DNS::Resource::IN::SOA
    * Resolv::DNS::Resource::IN::HINFO
    * Resolv::DNS::Resource::IN::MINFO
    * Resolv::DNS::Resource::IN::MX
    * Resolv::DNS::Resource::IN::TXT
    * Resolv::DNS::Resource::IN::ANY
    * Resolv::DNS::Resource::IN::A
    * Resolv::DNS::Resource::IN::WKS
    * Resolv::DNS::Resource::IN::PTR
    * Resolv::DNS::Resource::IN::AAAA

    Lookupped resource is represented as an instance of (a subclass of)
    Resolv::DNS::Resource.

== Resolv::DNS::Resource::IN::NS
--- name
== Resolv::DNS::Resource::IN::CNAME
--- name
== Resolv::DNS::Resource::IN::SOA
--- mname
--- rname
--- serial
--- refresh
--- retry
--- expire
--- minimum
== Resolv::DNS::Resource::IN::HINFO
--- cpu
--- os
== Resolv::DNS::Resource::IN::MINFO
--- rmailbx
--- emailbx
== Resolv::DNS::Resource::IN::MX
--- preference
--- exchange
== Resolv::DNS::Resource::IN::TXT
--- data
== Resolv::DNS::Resource::IN::A
--- address
== Resolv::DNS::Resource::IN::WKS
--- address
--- protocol
--- bitmap
== Resolv::DNS::Resource::IN::PTR
--- name
== Resolv::DNS::Resource::IN::AAAA
--- address

== Resolv::DNS::Name
=== 饹᥽å:
--- Resolv::DNS::Name.create(name)

=== ᥽å:
--- Resolv::DNS::Name#to_s

== Resolv::DNS::Resource

== Resolv::IPv4
=== 饹᥽å:
--- Resolv::IPv4.create(address)

=== ᥽å:
--- Resolv::IPv4#to_s
--- Resolv::IPv4#to_name

=== :
--- Resolv::IPv4::Regex
#    regular expression for IPv4 address.
    IPv4Υɥ쥹ɽ

== Resolv::IPv6
=== 饹᥽å:
--- Resolv::IPv6.create(address)

=== ᥽å:
--- Resolv::IPv6#to_s
--- Resolv::IPv6#to_name

=== :
--- Resolv::IPv6::Regex
#    regular expression for IPv6 address.
    IPv6Υɥ쥹ɽ

== Bugs
#NIS is not supported.
NISϥݡȤƤޤ
