# $Id: thread.rb,v 1.4 2002/09/11 03:25:40 knu Exp $

require 'features/ruby18/base'

class Thread
  alias __ruby16_join join

  def join(limit = nil)
    return self unless alive?
    return __ruby16_join if limit.nil?

    timedout = false

    curr = Thread.current

    tt = Thread.start do
      sleep limit
      timedout = true
      curr.wakeup
    end

    begin
      ret = __ruby16_join

      if timedout
	nil
      else
	ret
      end
    ensure
      tt.kill
    end
  end
end
