# $Id: tc_proc.rb,v 1.4 2002/04/16 00:21:08 nobu Exp $

require 'test/unit'
begin
  require 'features/ruby18/proc'
rescue LoadError; end

class TC_Proc < Test::Unit::TestCase
  def test_yield
    yielded = false
    assert_nothing_raised(ArgumentError) do
      proc {yielded = true}.yield
    end
    assert(yielded)
  end
  def test_yield_0
    yielded = false
    proc {|x| assert_nil(x); yielded = true}.yield()
    assert(yielded)
  end
  def test_yield_1
    yielded = false
    proc {|x| assert_nil(x); yielded = true}.yield(nil)
    assert(yielded)
  end
  def test_yield_2
    yielded = false
    proc {|x, y|
      assert_equal(1, x)
      assert_nil(y)
      yielded = true
    }.yield(1)
    assert(yielded)
  end
  def test_yield_3
    yielded = false
    proc {|x, y|
      assert_equal(1, x)
      assert_equal(2, y)
      yielded = true
    }.yield(1, 2, 3)
    assert(yielded)
  end
  def test_yield_nest_0
    yielded = false
    proc {|x, (y, z)|
      assert_equal(1, x)
      assert_nil(y)
      assert_nil(z)
      yielded = true
    }.yield(1)
    assert(yielded)
  end
  def test_yield_nest_1
    yielded = false
    proc {|x, (y, z)|
      assert_equal(1, x)
      assert_equal(2, y)
      assert_nil(z)
      yielded = true
    }.yield(1, 2)
    assert(yielded)
  end
  def test_yield_nest_2
    yielded = false
    proc {|x, (y, z)|
      assert_equal(1, x)
      assert_equal(2, y)
      assert_nil(z)
      yielded = true
    }.yield(1, [2])
    assert(yielded)
  end
  def test_yield_nest_3
    yielded = false
    proc {|x, (y, z)|
      assert_equal(1, x)
      assert_equal(2, y)
      assert_equal(3, z)
      yielded = true
    }.yield(1, [2,3,4])
    assert(yielded)
  end
  def test_yield_m
    f = proc {|*x| x}
    assert_equal([], f.yield())
    assert_equal([], f.yield([]))
    assert_equal([], f.yield(nil))
    assert_equal([1], f.yield([1]))
  end
end
