# $Id: tc_kernel.rb,v 1.1 2002/05/04 07:45:23 knu Exp $

require 'test/unit'
begin
  require 'features/ruby18/kernel'
rescue LoadError; end

class TC_Kernel < Test::Unit::TestCase
  def test_abort
    stderr = IO::pipe

    pid = fork {
      stderr[0].close
      STDERR.reopen(stderr[1])
      stderr[1].close

      aborted = false

      begin
	abort("doh!")
      rescue SystemExit
	aborted = true
      end

      STDERR.puts aborted.inspect
    }

    stderr[1].close
    Process.waitpid(pid)

    assert_equal("doh!\n", stderr[0].gets)
    assert_equal("true\n", stderr[0].gets)
    stderr[0].close
  end
end
