#
# rubyloader.rb
#
#   Copyright (c) 1999-2002 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#
#   $Id: rubyloader.rb,v 1.3 2002/01/05 06:19:34 aamine Exp $
#

require 'rbconfig'


module RubyLoader

  module_function

  def find_feature( feature )
    with_ext( feature ) do |fname|
      $LOAD_PATH.each do |dir|
        path = dir + '/' + fname
        if File.file? path
          return path
        end
      end
    end

    nil
  end

  def provided?( feature )
    with_ext( feature ) do |fn|
      $".index fn and return true
    end

    false
  end

  alias required? provided?

  def provide( feature )
    $".push feature
  end

  def with_ext( feature )
    if /\.(?:rb|#{Config::CONFIG['DLEXT']})\z/o === feature
      yield feature
    else
      [ 'rb', Config::CONFIG['DLEXT'] ].each do |ext|
        yield feature + '.' + ext
      end
    end
  end

end
