require "misen/style"

module Misen
  class SgmlExStyle < SgmlStyle
    def extended_inlines
      ["sgml_attr", "sgml_content"]
    end

    def sgml_attr_regexp
      %r"@@(#{IDENT_RE})@@"o
    end

    def sgml_content_regexp
      %r"##(#{IDENT_RE})##"o
    end

    def sgml_content_format(string)
      string = string.dup
      string.gsub!('&', '&amp;')
      string.gsub!('<', '&lt;')
      string.gsub!('>', '&gt;')
      string.gsub!('"', '&quot;')
      string.gsub!("'", '&#39;')
      string
    end
    alias sgml_attr_format sgml_content_format

    def sgml_attr_get_identifier(matches)
      matches[1]
    end
    alias sgml_content_get_identifier sgml_attr_get_identifier
  end #/SgmlExStyle
  STYLE_SGML_EX = SgmlExStyle.new
  
end #/Misen
