require "dpklib/collection"
require "dpklib/error"
require "misen/node"

module Misen
  InvalidExpansionDataError = Dpklib.new_error_class(StandardError) { |object|
    "Unsuitable data for expansion: #{object.inspect}"
  }

  ExpandByMember = Module.new
  class << self
    def expand_nodes(nodes, expansion_data)
      dowith_array_data(expansion_data) { |data|
        case data
        when nil, false; ""
        when true; expand_nodes_with_dictionary(nodes, {})
        when Hash; expand_nodes_with_dictionary(nodes, data)
        when ExpandByMember
          wrapped = wrap_expand_by_member(data)
          expand_nodes_with_dictionary(nodes, wrapped)
        else
          data.to_s
        end
      }
    end

    private
    def wrap_expand_by_member(expand_by_member)
      proc { |key|
        expand_by_member.__send__(key)
      }
    end

    def data_for_node(dictionary, node)
      dictionary[node.identifier.intern]
    end

    def expand_node_with_dictionary(node, dictionary_data)
      case node
      when Misen::BlockNode
        data = data_for_node(dictionary_data, node)
        expand_nodes(node.children, data)
      when Misen::InlineNode
        nodedata = data_for_node(dictionary_data, node)
        dowith_array_data(nodedata) { |data|
          node.format(data.to_s)
        }
      else
        node.to_s
      end
    end

    def dowith_array_data(data, &block)
      case data
      when Array
        collected = data.collect { |atom|
          dowith_array_data(atom, &block)
        }
        collected.to_s
      else
        yield(data)
      end
    end

    def expand_nodes_with_dictionary(nodes, dictionary_data)
      str = ""
      nodes.each { |node|
        str << expand_node_with_dictionary(node, dictionary_data)
      }
      str
    end
  end #/<< self
end #/Misen
