require "dpklib/dpkstd"
require "dpklib/gtk/dialog"
require "gtk"

module Dpklib_Gtk
  class << self
    def wait_while(&loop_condition)
      while yield
        Gtk.main_iteration
      end
    end

    def wait_widget_hidden_or_destroyed(widget)
      wait_while {
        begin
          widget.visible?
        rescue ArgumentError  # = object is destroyed
          false
        end
      }
    end

    def with_freeze_widget(*widgets, &block)
      widgets.each { |widget|
        widget.freeze
      }
      begin
        yield
      ensure
        widgets.reverse_each { |widget|
          widget.thaw
        }
      end
    end

    def with_protected(error_stream = nil, &block)
      error_stream ||= $stderr
      begin
        yield
      rescue Exception
        error_stream.puts Dpklib.stacktrace_message($!)
        Dpklib_Gtk.alert( Dpklib.error_description($!) )
        false
      end
    end
  end #/<< self
end #/Dpklib_Gtk
