require 'date'
require 'dpklib/collection'

module Dpklib
  class CalendarMatrix < Struct.new(:month_date)
    class Day < Struct.new(:week, :wday, :date)
      def wday=(wday)
        unless (0...7) === wday then
          self.week += (wday / 7).to_i
          wday = wday % 7
        end
        super
      end

      def succ!
        self.date += 1
        self.wday += 1
      end
    end

    class BaseDay < Day
      def initialize(date)
        super()
        basedate = Date.new(date.year, date.month, 1)
        self.date = basedate
        self.week = 0
        self.wday = basedate.wday
      end

      def date2day(date)
        day = Day.new
        day.week = self.week
        day.wday = self.wday + (date - self.date)
        day.date = date

        day
      end
    end #/BaseDay


    def each_day(date_range = nil, &block)
      date_range = default_date_range unless date_range

      baseday = BaseDay.new(self.month_date)
      enum = YAEnumerator.new do |iter|
        day = baseday.date2day( date_range.first )
        date_range.each do |date|
          iter[day.clone]
          day.succ!
        end
      end

      block_given?() ? enum.each(&block) : enum
    end

    def each_week(date_range = nil, &block)
      date_range = default_date_range unless date_range

      enum = YAEnumerator.new do |iter|
        days = each_day(date_range).to_a
        until days.empty? do
          week = days[0].week
          days_of_week = days.cut_until! { |day|
            day.week > week
          }
          iter[week, days_of_week]
        end
      end

      block_given?() ? enum.each(&block) : enum
    end

    private
    def default_date_range
      month_date = Date.new(self.month_date.year, self.month_date.month, 1 )
      from = month_date
      from -= from.wday
      to = (month_date >> 1)
      to += (7 - to.wday)
      from...to
    end

  end #/CalendarMatrix

end #/Dpklib
