
module Dpklib
  def self.bench(trycount = 1, &target)
    GC.start
    start_time = Time.now
    trycount.times do
      yield
    end
    Time.now - start_time
  end

  def self.bench_times(trycount = 1, &target)
    GC.start
    start_times = Time.times
    trycount.times do
      yield
    end
    finish_times = Time.times
    "user: #{finish_times.utime - start_times.utime}, system: #{finish_times.stime - start_times.stime}"
  end
end #/Dpklib
