require "dpklib/assert"
require "rubyunit"

require "dpklib/update-monitor"

class TESTCASE_UpdateMonitor < RUNIT::TestCase
  include Dpklib::RUNIT_Assert

  def test_it
    mtime = nil
    monitor = Dpklib::UpdateMonitor.new {
      mtime
    }

    # No file
    mtime = nil

    monitor.update
    assert_unless monitor.up_to_date?
    assert_if monitor.lost?
    
    # File is created.
    mtime = 1
    assert_unless monitor.up_to_date?
    assert_unless monitor.lost?

    monitor.update

    assert_if monitor.up_to_date?
    assert_unless monitor.lost?

    # File is updated.
    mtime = 2
    assert_unless monitor.up_to_date?
    assert_unless monitor.lost?

    monitor.update

    assert_if monitor.up_to_date?
    assert_unless monitor.lost?

    # File went lost.
    mtime = nil
    assert_unless monitor.up_to_date?
    assert_if monitor.lost?

    monitor.update

    assert_unless monitor.up_to_date?
    assert_if monitor.lost?
  end

end #/TESTCASE_UpdateMonitor
