=begin
  locale.rb - Locale module

  Copyright (C) 2002  Masao Mutoh <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: locale.rb,v 1.2 2002/07/06 14:45:35 mutoh Exp $
=end

if /cygwin|mingw|mswin32|bccwin32/ =~ PLATFORM
  require 'gettext/locale_win32'
else
  require 'gettext/locale_default'
end

module Locale
  def locale(value = "")
	lc = _locale(value)
	lc == nil ? "C" : lc
	ret = nil
	["LC_ALL", "LC_CTYPE", "LC_MESSAGES", "LANG"].each do |env|
	  ret = ENV[env]
	  break if ret
	end
	ret ? ret : lc
  end

  def codeset
	cs = _codeset
	cs == nil ? "UTF-8" : cs
  end

  module_function :locale, :codeset
end

if __FILE__ == $0
  p Locale.locale
  p Locale.codeset
end
