#!/usr/local/bin/ruby
# Directory Compare
#   by Shin-ichiro HARA (sinara@blade.nagaokaut.ac.jp)
#
# Date: 2003.02.28
# Version: 2.00.00

#require "forwardable"

########## QuasiFile ##########
class QuasiFile
  StringMethods = String.instance_methods(true)
  StatMethods = File::Stat.instance_methods(true)
  
  (StringMethods - StatMethods).each do |meth|
    eval "def #{meth}(*a, &b); @path.#{meth}(*a, &b); end"
  end
  
  (StatMethods - StringMethods).each do |meth|
    eval "def #{meth}(*a, &b); @stat && @stat.#{meth}(*a, &b); end"
  end
  
  include Comparable
  
  attr_reader :path, :stat
  
  def initialize(fn)
    @path = fn
    @stat = File.exist?(fn) ? File.stat(fn) : nil
  end

  def size
    @stat ? @stat.size : nil
  end
  
  def exist?
    @stat ? true : false
  end
  
  def <=>(o)
    if exist?
      o.exist? ? stat <=> o.stat : 1
    else
      o.exist? ? -1 : 0
    end	
  end
  
  def content
    directory? ? Dir.entries(@path).find_all{|x| x !~ /^\.\.?$/} : []
  end

  def inspect; @path; end
  
  def to_s
    @path
  end
end
  
########## DirCompare ##########
class DirCompare
  def parse(*qfs, &b)
    catch(:prune) do
      dir_sw = false
      union = []
      qfs.each do |qf|
	if qf.directory?
	  dir_sw = true
	  union |= qf.content
	end
      end

      if dir_sw
	yield(:in, *qfs)
	union.sort!
	union.each do |name|
	  qfs0 = qfs.map{|qf| QuasiFile.new(File.join(qf.path, name))}
	  parse(*qfs0, &b)
	end
	yield(:out, *qfs)
      else
	yield(:empty, *qfs)
      end
    end
  end

  def initialize(visitor = nil)
    @visitor = visitor
  end

  def run(*paths)
    qfs = paths.map{|path| QuasiFile.new(path)}
    parse(*qfs) do |mod, *qfs0|
      @visitor.run(mod, *qfs0)
    end
  end
  
  alias compare run
end

module DirRun
  def meth_name(mod, *qfs)
    names = qfs.map{|qf|
      if qf.exist?
	if qf.directory?
	  "dir"
	elsif qf.file?
	  "file"
	else
	  "unknown"
	end
      else
	"non"
      end
    }
    names.push mod.to_s if mod == :out
    names.join("_")
  end

  def param(*a)
    a
  end
end

module DirWalk
  def param(*a)
    a.map{|qf| qf.path}
  end
end

########## DirWalker ##########
class DirRunner
  include DirRun

  def run(mod, sqf)
    send(meth_name(mod, sqf), *param(sqf))
  end

  def file(s)
  end

  def dir(s)
  end
  
  def dir_out(s)
  end

  def non(s)
  end
end

class DirWalker < DirRunner
  include DirWalk
end

########## DirPairWalker ##########
class DirPairRunner
  include DirRun
  
  def run(mod, sqf, tqf)
    if sqf.file? && tqf.file?
      if sqf > tqf
	file_gt_file(*param(sqf, tqf))
      elsif sqf < tqf
	file_lt_file(*param(sqf, tqf))
      else
	file_eq_file(*param(sqf, tqf))
      end
    else
      send(meth_name(mod, sqf, tqf), *param(sqf, tqf))
    end
  end

  def file_file(s, t)
  end

  def file_lt_file(s, t)
    file_file(s, t)
  end

  def file_gt_file(s, t)
    file_file(s, t)
  end

  def file_eq_file(s, t)
    file_file(s, t)
  end

  def file_dir(s, t)
  end

  def file_dir_out(s, t)
  end

  def file_non(s, t)
  end

  def dir_file(s, t)
  end

  def dir_file_out(s, t)
  end

  def dir_dir(s, t)
  end

  def dir_dir_out(s, t)
  end

  def dir_non(s, t)
  end

  def dir_non_out(s, t)
  end

  def non_file(s, t)
  end

  def non_dir(s, t)
  end

  def non_dir_out(s, t)
  end

  def non_non(s, t)
  end
end

class DirPairWalker < DirPairRunner
  include DirWalk
end

########## DirPairViewer ##########
class DirPairViewer < DirPairWalker
  def file_lt_file(s, t)
    puts "file_lt_file: #{s} #{t}"
  end

  def file_gt_file(s, t)
    puts "file_gt_file: #{s} #{t}"
  end

  def file_eq_file(s, t)
    puts "file_eq_file: #{s} #{t}"
  end

  def file_dir(s, t)
    puts "file_dir: #{s} #{t}"
  end

  def file_dir(s, t)
    puts "file_dir_out: #{s} #{t}"
  end

  def file_non(s, t)
    puts "file_non: #{s} #{t}"
  end

  def dir_file(s, t)
    puts "dir_file: #{s} #{t}"
  end

  def dir_file_out(s, t)
    puts "dir_file_out: #{s} #{t}"
  end

  def dir_dir(s, t)
    puts "dir_dir: #{s} #{t}"
  end

  def dir_dir_out(s, t)
    puts "dir_dir_out: #{s} #{t}"
  end

  def in_dir_non(s, t)
    puts "in_dir_non: #{s} #{t}"
  end

  def dir_non_out(s, t)
    puts "dir_non_out: #{s} #{t}"
  end

  def non_file(s, t)
    puts "non_file: #{s} #{t}"
  end

  def non_dir(s, t)
    puts "non_dir: #{s} #{t}"
  end

  def non_dir_out(s, t)
    puts "non_dir_out: #{s} #{t}"
  end

  def non_non(s, t)
    puts "non_non: #{s} #{t}"
  end
end

if $0 == __FILE__
  visitor = DirPairViewer.new
  dc = DirCompare.new(visitor)
  dirs = ARGV.map{|dir| dir.sub(/#{File::SEPARATOR}?$/o, '')}
  dc.run(*dirs)
end
