require "dpklib/compare-wrap"
require "misen/style-sgml"
require "misen/util"
require "runit/testcase"

class TESTCASE_MisenExpand < RUNIT::TestCase
  class TestData < Struct.new(:block, :inline)
    include Misen::ExpandByMember
  end #/TestData

  class TestStyle < Misen::SgmlExStyle
    def extended_inlines
      super << "test"
    end

    def test_regexp
      %r"!test!"
    end

    def test_get_identifier(matches)
      "test"
    end

    def test_format(string)
      "!!#{string}!!"
    end
  end #/TestStyle
  STYLE_TEST = TestStyle.new

  def test_it
    source = '
  <misen:block>
    text1<misen:inline />
  </misen:block>
text2
'

    # Simple
    check(source, "", "")
    check(source, nil, "")
    check(source, false, "")
    check(source, true, "text2")

    # Hash
    check(source, {:block => nil}, "text2")
    check(source, {:block => true}, "text1 text2")
    check(source, {:block => "text3"}, "text3 text2")

    # Nested Hash
    check(source, {:block => {:inline => "text3"}}, "text1 text3 text2")

    # ExpandByMember
    check(source, TestData.new(TestData.new(nil, "text3"), nil),
          "text1text3text2")

    # Array
    check(source, [true, {:block => true}], "text2 text1 text2")
    check(source, {:block => {:inline => ["text3", "text4"]}},
          "text1 text3text4 text2")
  end

  def test_format
    source = '!test!'
    
    check(source, {:test => "a"}, "!!a!!")
    check(source, {:test => ["1", "2"]}, "!!1!!!!2!!")
  end

  def check(source, data, expected)
    expanded = Misen.expand_text(STYLE_TEST, source, data)
    assert_equals(Dpklib::WSIgnoredCompareWrapper[expected],
                  Dpklib::WSIgnoredCompareWrapper[expanded])
  end
end #/TESTCASE_MisenExpand
