#$IMPORT_MODULE_debug = true
require "import-module"
module Import_Module
  class Scope
    def set_methods
      meths = @target.get_orig_methods(@source)
      @target.def_orig_methods meths
      #def_methods
      mod = @mod
      @klass.class_eval do include mod end
    end

    def push()
      def_methods
      c = @target.stack.current
      @target.stack.push(update(c))
    end

    def pop
      c = @target.stack.pop
      recov_methods(c)
    end

    private
    def update(c)
      d = c.dup
      @source.methods.each do |meth|
	d[meth] = @mod
      end
      d
    end

    def def_methods
      mod = @mod
      @source.methods.__each__ do |meth|
	@klass.module_eval do
	  alias_method meth, Import_Module.name(meth, mod)
	end
      end
    end

    def recov_methods(c)
      orig_methods = @target.orig_methods
      d = @target.stack.current
      c.__each__ do |meth, mod|
	@klass.module_eval do
	  if m = d[meth] || orig_methods[meth] && :ORIG
	    alias_method meth, Import_Module.name(meth, m)
	  else
	    undef_method meth
	  end
	end
      end
    end
  end

  class Target
    attr_accessor :stack

    def initialize(klass)
      @klass = klass
      @privates = @klass.private_instance_methods #(true)
      @orig_methods = {}
      @saved_methods = {}
      resist_orig_methods
      @stack = Stack.new([Hash.new]) # diff
    end
  end

  class Stack
    private
    def export_current; end
  end
end

class << Thread
  alias new new_org
  alias start new_org
  alias fork new_org
end
