require "dpklib/hashutils"
require "rubyunit"

class TESTCASE_HashUtils < RUNIT::TestCase
  def test_struct_to_hash
    klass = Struct.new(:a, :b)
    struct = klass.new

    struct.a = 573
    struct.b = 79310

    hash = Dpklib.struct_to_hash(struct)
    
    assert_not_nil hash.include?(:a)
    assert_not_nil hash.include?(:b)

    assert_equals 573, hash[:a]
    assert_equals 79310, hash[:b]
  end

  def test_hash_to_struct
    klass = Struct.new(:a, :b, :c)
    struct = klass.new(nil, nil, 1192)

    hash = {:a => 79310, :b => 573}
    
    Dpklib.hash_to_struct(hash, struct)
    
    assert_equals 79310, struct.a
    assert_equals 573, struct.b
    assert_equals 1192, struct.c
  end

  def test_nested_hash
    hash = {}
    leaf = Dpklib.nested_hash(hash, [:a, :b, :c])
    assert_same(hash[:a][:b][:c], leaf)
    
    leaf = Dpklib.nested_hash(hash, [])
    assert_same(hash, leaf)

    leaf = Dpklib.nested_hash(hash, [:a, :x])
    assert_same(hash[:a][:x], leaf)

    hash[:a][:x] = 100
    assert_exception(Dpklib::NestedHashConflictError) {
      Dpklib.nested_hash(hash, [:a, :x])
    }
  end
end #/TESTCASE_HashUtils
