require 'rubyunit'

require 'dpklib/calendar'

class TESTCASE_Calendar < RUNIT::TestCase
  def test_it
    @calendar = Dpklib::CalendarMatrix.new
    @calendar.month_date = Date.new(2002,05)

    from = Date.new(2002,05,07)
    to = Date.new(2002,05,16)
    @date_range = (from..to)

    check_days
    check_weeks
    check_whole_month
  end

  def check_days
    days_enum = @calendar.each_day(@date_range)

    dates = days_enum.collect { |day|
      day.date
    }
    assert_equals @date_range.to_a, dates

    weeks = days_enum.collect { |day|
      day.week
    }
    assert_equals [1]*5+[2]*5, weeks

    wdays = days_enum.collect { |day|
      day.wday
    }
    assert_equals [2,3,4,5,6,0,1,2,3,4], wdays
  end

  def check_weeks
    days_enum = @calendar.each_day(@date_range)
    weeks_enum = @calendar.each_week(@date_range)

    weeks = []
    days = []
    weeks_enum.each { |week, days_of_week|
      weeks << week
      days.concat days_of_week
    }
    assert_equals [1, 2], weeks
    assert_equals days_enum.to_a, days
  end

  def check_whole_month
    days = @calendar.each_day().to_a
    assert_equals Date.new(2002,04,28), days[0].date
    assert_equals Date.new(2002,06,01), days[-1].date
    assert_equals 35, days.size
  end

end #/TESTCASE_Calendar
