#!/usr/local/bin/ruby
require "dir-compare"
require "ftools"

class Mv_o < DirPairWalker
  def initialize
    @file_dir = false
  end

  def file_file(s, t)
    File.mv(s, t)
  end

  def file_dir(s, t)
    @file_dir = true
  end

  def file_dir_out(s, t)
    @file_dir = false
    Dir.unlink(t)
    File.mv(s, t)
  end

  def file_non(s, t)
    dir = File.dirname(t)
    File.mkpath(dir) unless File.directory?(dir)
    File.mv(s, t)
  end

  def non_file(s, t)
    if @file_dir
      File.unlink(t)
    end
  end

  def dir_file(s, t)
    File.unlink(t)
    File.mv(s, t)
    throw :prune
  end

  def dir_dir_out(s, t)
    Dir.rmdir(s)
  end

  def dir_non(s, t)
    dir = File.dirname(t)
    File.mkpath(dir) unless File.directory?(dir)
    File.mv(s, t)
    throw :prune
  end
end

visitor = Mv_o.new
dc = DirCompare.new(visitor)
source, target = ARGV
dc.compare(source, target)
