require "dpklib/class"

module Dpklib
  StrictError = Class.new(Exception)
  class << StrictError
    def raise_error(message)
      raise self, message
    end
  end #/<< StrictError

  module Strict
    include Dpklib::BacktraceRewriteMethod

    def must_kindof(obj, klass)
      unless obj.kind_of?(klass)
        StrictError.raise_error "must be a #{klass}: #{obj}"
      end
      obj
    end

    def must_respond(obj, method)
      unless obj.respond_to?(method)
        StrictError.raise_error "must respond to #{method}: #{obj}"
      end
      obj
    end

    def must_if(obj)
      obj || StrictError.raise_error("cannot be nil,false: #{obj}")
      obj
    end

    def must_unless(obj)
      obj && StrictError.raise_error("must be nil,false: #{obj}")
      obj
    end

    backtrace_rewrite_method StrictError, :must_kindof
    backtrace_rewrite_method StrictError, :must_respond
    backtrace_rewrite_method StrictError, :must_if
    backtrace_rewrite_method StrictError, :must_unless

    Dpklib.install_class_module(self) do
      include Dpklib::EachargMethod
      include Dpklib::BacktraceRewriteMethod
      
      def must_method_defined(name)
        unless method_defined?(name)
          Dpklib::StrictError.raise_error("method undefined: #{self}##{name}")
        end
      end

      def must_const_defined(name)
        begin
          const_get(name)
        rescue NameError
          Dpklib::StrictError.raise_error("constant undefined #{name} in #{self}")
        end
      end
      
      eacharg_method :must_method_defined, :must_const_defined
      
      backtrace_rewrite_method Dpklib::StrictError, :must_method_defined
      backtrace_rewrite_method Dpklib::StrictError, :must_const_defined      
    end #/install_class_module
  end #/Strict

end #/Dpklib

class << Dpklib
  include Dpklib::Strict
  include Dpklib::BacktraceRewriteMethod

  def must_defined(name)
    unless eval("defined? #{name}")
      Dpklib::StrictError.raise_error("undefined: #{name}")
    end
  end

  backtrace_rewrite_method Dpklib::StrictError, :must_defined
end #/<< Dpklib
