require 'dpklib/monthday'
require 'rubyunit'
require 'date'
require 'dpklib/assert'
require 'dpklib/hour'

require 'dpklib/timearea'

class TESTCASE_TimeArea < RUNIT::TestCase
  include Dpklib::RUNIT_Assert

  def test_wildcard
    timearea = Dpklib::TimeArea["* * *"]
    assert_if timearea === Time.local(2002, 4, 1, 12, 30)
  end

  def test_etc
    timearea = Dpklib::TimeArea["* * *"]
    assert_nil timearea.etc

    timearea = Dpklib::TimeArea["* * * This is comment."]
    assert_equals "This is comment.", timearea.etc
  end

  def test_simple
    timearea = Dpklib::TimeArea["6/3 12:30 mon"]
    assert_if timearea === Time.local(2002, 6, 3, 12, 30)
    assert_unless timearea === Time.local(2002, 6, 3, 12, 31)
    assert_unless timearea === Time.local(2002, 6, 4, 12, 30)
  end

  def test_complex_day
    timearea = Dpklib::TimeArea["6/10-6/12,6/14 * *"]

    assert_unless timearea === Dpklib::MonthDay[6, 9]
    assert_if timearea === Dpklib::MonthDay[6, 10]
    assert_if timearea === Dpklib::MonthDay[6, 11]
    assert_if timearea === Dpklib::MonthDay[6, 12]
    assert_unless timearea === Dpklib::MonthDay[6, 13]
    assert_if timearea === Dpklib::MonthDay[6, 14]
  end

  def test_complex_hour
    timearea = Dpklib::TimeArea["* 10:00-11:00,12:00 *"]

    assert_unless timearea === Dpklib::Hour[9, 59]
    assert_if timearea === Dpklib::Hour[10, 0]
    assert_if timearea === Dpklib::Hour[10, 30]
    assert_unless timearea === Dpklib::Hour[11, 0]
    assert_if timearea === Dpklib::Hour[12, 0]
    assert_unless timearea === Dpklib::Hour[12, 1]
  end

  def test_complex_wday
    timearea = Dpklib::TimeArea["* * mon,tue-thu,sat"]

    # -- wday = 0 --
    date = Date.new(2002, 6, 2)

    assert_unless timearea === date
    assert_if timearea === date+1
    assert_if timearea === date+2
    assert_if timearea === date+3
    assert_if timearea === date+4
    assert_unless timearea === date+5
    assert_if timearea === date+6
  end

  def test_to_s
    check = proc { |string|
      expected = Dpklib::TimeArea[string]
      actual = Dpklib::TimeArea[ expected.to_s ]
      assert_equals expected, actual
    }
    check["* * *"]
    check["1/1 2:30 sun"]
    check["6/10-6/12,6/14 * *"]
    check["* 10:00-11:00,12:00 *"]
    check["* * mon,tue-thu,sat"]
    check["* * * This is comment."]
  end


end #/TESTCASE_TimeArea

