require "rubyunit"
require "dpklib/parsearg"

class TESTCASE_ParseArg < RUNIT::TestCase
  def test_it
    argv = []
    check_parse(Dpklib.parse_args(argv),
                [])

    argv = ["a", "b"]
    check_parse(Dpklib.parse_args(argv),
                ["a", "b"])

    argv = ["-a", "-cd", "x"]
    check_parse(Dpklib.parse_args(argv, "abcd"),
                ["x"], :a => true, :b => nil, :c => true, :d => true)

    argv = ["-r"]
    assert_nil Dpklib.parse_args(argv, "p")

    argv = ["-ab", "123", "456"]
    check_parse(Dpklib.parse_args(argv, "a", "b:"),
                ["456"], :a => true, :b => "123")

    argv = ["-g"]
    assert_nil Dpklib.parse_args(argv, nil, "g:")

    argv = ["--long", "111"]
    check_parse(Dpklib.parse_args(argv, nil, "long:"),
                [], :long => "111")
  end

  def test_multiarg_opt
    argv = nil
    parse_multiarg_opt = proc {
      Dpklib.parse_args(argv, nil, "m::")
    }

    argv = []
    check_parse(parse_multiarg_opt[], [], :m => [])

    argv = ["-m", "arg"]
    check_parse(parse_multiarg_opt[], [], :m => ["arg"])

    argv = ["-m", "1", "-m", "2"]
    check_parse(parse_multiarg_opt[], [], :m => ["1", "2"])

    argv = ["-m"]
    assert_nil parse_multiarg_opt[]
  end

  def check_parse(parsed, args, opthash = {})
    args.each_with_index { |arg, index|
      assert_equals arg, parsed[index]
    }
    opthash.each { |optname, optval|
      assert_equals optval, parsed[optname]
    }
  end
end #/TESTCASE_ParseArg
