require "dpklib/acquisition"
require "rubyunit"

class TESTCASE_Acquisition < RUNIT::TestCase
  def test_it
    parent = Dpklib::AcqObject.new
    child = Dpklib::AcqObject.new(parent)
    granchild = Dpklib::AcqObject.new(child)

    parent.acq_export_object(:test, "nyu")
    assert_equals "nyu", child.acq_invoke(:test)
    assert_equals "nyu", granchild.acq_invoke(:test)

    granchild.acq_export_object(:test, "mona")
    assert_equals "mona", granchild.acq_invoke(:test)
    assert_equals "nyu", granchild.acq_invoke_super(:test)
    
    assert_exception(Dpklib::Acquisition::CannotImportError) {
      granchild.acq_invoke(:hoge)
    }
  end

  class TestLoopObj1 < Dpklib::AcqObject
    acq_export_self :test
    acq_import :test
  end #/TestLoopObj1

  class TestLoopObj2 < Dpklib::AcqObject
    acq_import :test
    acq_export_self :test
  end #/TestLoopObj2
  
  class TestLoopObj3 < Dpklib::AcqObject
    module Mod
      include Dpklib::Acquisition
      acq_export_self :test
    end #/Mod
    acq_import :test
    include Mod
  end #/TestLoopObj3

  def test_loop
    obj = TestLoopObj1.new
    assert_equals obj, obj.test
    obj = TestLoopObj2.new
    assert_equals obj, obj.test
    obj = TestLoopObj3.new
    assert_equals obj, obj.test
  end
end #/TESTCASE_Acquisition
